/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.player2api.Character;
import com.player2.playerengine.player2api.ConversationHistory;
import com.player2.playerengine.player2api.Event;
import com.player2.playerengine.player2api.Player2APIService;
import com.player2.playerengine.player2api.Prompts;
import java.util.Deque;
import java.util.Optional;

public class AIPersistantData {
    private ConversationHistory conversationHistory;
    private Character character;
    private PlayerEngineController mod;

    public AIPersistantData(PlayerEngineController mod, Character character) {
        this.character = character;
        this.mod = mod;
        String systemPrompt = Prompts.getAINPCSystemPrompt(character, mod.getCommandExecutor().allCommands(), mod.getOwnerUsername());
        this.conversationHistory = new ConversationHistory(systemPrompt, character.name(), character.shortName());
    }

    public void clearHistory() {
        this.conversationHistory.clear();
    }

    public Event getGreetingEvent() {
        String suffix = " IMPORTANT: SINCE THIS IS THE FIRST MESSAGE, ONLY USE COMMAND `bodylang greeting`";
        if (this.conversationHistory.isLoadedFromFile()) {
            return new Event.InfoMessage("You want to welcome user back." + suffix);
        }
        return new Event.InfoMessage(this.character.greetingInfo() + suffix);
    }

    public Event dumpEventQueueToConversationHistoryAndReturnLastEvent(Deque<Event> eventQueue, Player2APIService player2apiService) {
        Event lastEvent = null;
        while (!eventQueue.isEmpty()) {
            Event event = eventQueue.poll();
            this.conversationHistory.addUserMessage(event.getConversationHistoryString(), player2apiService);
            lastEvent = event;
        }
        return lastEvent;
    }

    public ConversationHistory getConversationHistoryWrappedWithStatus(String worldStatus, String agentStatus, String altoClefDebugMsgs, Player2APIService player2apiService, Optional<String> reminderString) {
        return this.conversationHistory.copyThenWrapLatestWithStatus(worldStatus, agentStatus, altoClefDebugMsgs, player2apiService, reminderString);
    }

    public void addAssistantMessage(String llmMessage, Player2APIService player2apiService) {
        this.conversationHistory.addAssistantMessage(llmMessage, player2apiService);
    }

    public Character getCharacter() {
        return this.character;
    }

    public void updateSystemPrompt() {
        String systemPrompt = Prompts.getAINPCSystemPrompt(this.character, this.mod.getCommandExecutor().allCommands(), this.mod.getOwnerUsername());
        this.conversationHistory.setBaseSystemPrompt(systemPrompt);
    }
}

