/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api.status;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.entity.IAutomatone;
import com.player2.playerengine.player2api.status.ObjectStatus;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class StatusUtils {
    public static String getInventoryString(PlayerEngineController mod) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (int i = 0; i < mod.getBaritone().getEntityContext().inventory().method_5439(); ++i) {
            class_1799 stack = mod.getBaritone().getEntityContext().inventory().method_5438(i);
            if (stack.method_7960()) continue;
            String name = ItemHelper.stripItemName(stack.method_7909());
            counts.put(name, counts.getOrDefault(name, 0) + stack.method_7947());
        }
        ObjectStatus status = new ObjectStatus();
        for (Map.Entry entry : counts.entrySet()) {
            status.add((String)entry.getKey(), ((Integer)entry.getValue()).toString());
        }
        return status.toString();
    }

    public static String getDimensionString(PlayerEngineController mod) {
        return mod.getWorld().method_27983().method_29177().toString().replace("minecraft:", "");
    }

    public static String getWeatherString(PlayerEngineController mod) {
        boolean isRaining = mod.getWorld().method_8419();
        boolean isThundering = mod.getWorld().method_8546();
        ObjectStatus status = new ObjectStatus().add("isRaining", String.valueOf(isRaining)).add("isThundering", String.valueOf(isThundering));
        return status.toString();
    }

    public static String getSpawnPosString(PlayerEngineController mod) {
        class_2338 spawnPos = mod.getWorld().method_43126();
        return String.format("(%d, %d, %d)", spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260());
    }

    public static String getTaskStatusString(PlayerEngineController mod) {
        String noTask = "No tasks currently running.";
        List<Task> tasks = mod.getUserTaskChain().getTasks();
        return tasks.isEmpty() ? noTask : (tasks.get(0).toString().contains("LookAtOwner") ? noTask : tasks.get(0).toString());
    }

    public static String getNearbyBlocksString(PlayerEngineController mod) {
        int radius = 12;
        class_2338 center = mod.getPlayer().method_24515();
        HashMap<String, Integer> blockCounts = new HashMap<String, Integer>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    class_2338 pos = center.method_10069(dx, dy, dz);
                    String blockName = mod.getWorld().method_8320(pos).method_26204().method_9539().replace("block.minecraft.", "");
                    if (blockName.equals("air")) continue;
                    blockCounts.put(blockName, blockCounts.getOrDefault(blockName, 0) + 1);
                }
            }
        }
        ObjectStatus status = new ObjectStatus();
        for (Map.Entry entry : blockCounts.entrySet()) {
            status.add((String)entry.getKey(), ((Integer)entry.getValue()).toString());
        }
        return status.toString();
    }

    public static String getOxygenString(PlayerEngineController mod) {
        return String.format("%s/300", mod.getPlayer().method_5669());
    }

    public static String getNearbyHostileMobs(PlayerEngineController mod) {
        int radius = 32;
        ArrayList<CallSite> descriptions = new ArrayList<CallSite>();
        for (class_1297 entity : mod.getWorld().method_27909()) {
            if (!(entity instanceof class_1588) || !(entity.method_5739((class_1297)mod.getPlayer()) < (float)radius)) continue;
            String type = entity.method_5864().method_5882();
            String niceName = type.replace("entity.minecraft.", "");
            String position = entity.method_19538().method_1032(EnumSet.allOf(class_2350.class_2351.class)).toString();
            descriptions.add((CallSite)((Object)(niceName + " at " + position)));
        }
        return descriptions.isEmpty() ? String.format("no nearby hostile mobs within %d", radius) : "[" + String.join((CharSequence)",", (CharSequence[])descriptions.stream().map(s -> "\"" + s + "\"").toArray(String[]::new)) + "]";
    }

    public static String getEquippedArmorStatusString(PlayerEngineController mod) {
        class_1309 player = mod.getPlayer();
        ObjectStatus status = new ObjectStatus();
        class_1799 head = player.method_6118(class_1304.field_6169);
        class_1799 chest = player.method_6118(class_1304.field_6174);
        class_1799 legs = player.method_6118(class_1304.field_6172);
        class_1799 feet = player.method_6118(class_1304.field_6166);
        class_1799 offhand = player.method_6118(class_1304.field_6171);
        status.add("helmet", !head.method_7960() && head.method_7909() instanceof class_1738 ? head.method_7909().method_7876().replace("item.minecraft.", "") : "none");
        status.add("chestplate", !chest.method_7960() && chest.method_7909() instanceof class_1738 ? chest.method_7909().method_7876().replace("item.minecraft.", "") : "none");
        status.add("leggings", !legs.method_7960() && legs.method_7909() instanceof class_1738 ? legs.method_7909().method_7876().replace("item.minecraft.", "") : "none");
        status.add("boots", !feet.method_7960() && feet.method_7909() instanceof class_1738 ? feet.method_7909().method_7876().replace("item.minecraft.", "") : "none");
        status.add("offhand_shield", !offhand.method_7960() && offhand.method_7909() instanceof class_1819 ? offhand.method_7909().method_7876().replace("item.minecraft.", "") : "none");
        return status.toString();
    }

    public static String getNearbyPlayers(PlayerEngineController mod) {
        ArrayList<CallSite> descriptions = new ArrayList<CallSite>();
        for (class_1297 entity : mod.getEntityTracker().getCloseEntities()) {
            if (!(entity instanceof class_1657)) continue;
            class_1657 player = (class_1657)entity;
            if (!(entity.method_5739((class_1297)mod.getPlayer()) < 64.0f)) continue;
            String username = player.method_5477().getString();
            String position = entity.method_19538().method_1032(EnumSet.allOf(class_2350.class_2351.class)).toString();
            descriptions.add((CallSite)((Object)(username + " at " + position)));
        }
        return descriptions.isEmpty() ? String.format("no nearby users within %.2f", Float.valueOf(64.0f)) : "[" + String.join((CharSequence)",", (CharSequence[])descriptions.stream().map(s -> "\"" + s + "\"").toArray(String[]::new)) + "]";
    }

    public static String getNearbyNPCs(PlayerEngineController mod) {
        ArrayList<CallSite> descriptions = new ArrayList<CallSite>();
        for (class_1297 entity : mod.getEntityTracker().getCloseEntities()) {
            String username;
            if (!(entity instanceof IAutomatone) || !(entity.method_5739((class_1297)mod.getPlayer()) < 32.0f) || Objects.equals(username = entity.method_5476().getString(), mod.getPlayer().method_5476().getString())) continue;
            String position = entity.method_19538().method_1032(EnumSet.allOf(class_2350.class_2351.class)).toString();
            descriptions.add((CallSite)((Object)(username + " at " + position)));
        }
        return descriptions.isEmpty() ? String.format("no nearby npcs within %d", 32) : "[" + String.join((CharSequence)",", (CharSequence[])descriptions.stream().map(s -> "\"" + s + "\"").toArray(String[]::new)) + "]";
    }

    public static float getUserNameDistance(PlayerEngineController mod, String targetUsername) {
        for (class_1657 player : mod.getWorld().method_18456()) {
            String username = player.method_5477().getString();
            if (!username.equals(targetUsername)) continue;
            return player.method_5739((class_1297)mod.getPlayer());
        }
        return Float.MAX_VALUE;
    }

    public static String getDifficulty(PlayerEngineController mod) {
        return mod.getWorld().method_8407().toString();
    }

    public static String getTimeString(PlayerEngineController mod) {
        ObjectStatus status = new ObjectStatus();
        status.add("isDay", Boolean.toString(mod.getWorld().method_8530()));
        status.add("timeOfDay", String.format("%d/24,000", mod.getWorld().method_8532() % 24000L));
        return status.toString();
    }

    public static String getGamemodeString(PlayerEngineController mod) {
        return mod.getInteractionManager().getGameType().method_8386() ? "creative" : "survival";
    }

    public static String getCurrentPosition(PlayerEngineController mod) {
        return mod.getEntity().method_33571().toString();
    }

    public static String getTaskTree(PlayerEngineController mod) {
        Task task = mod.getUserTaskChain().getCurrentTask();
        return task == null ? "Task tree is empty" : task.getTaskTree();
    }

    public static float getDistanceToUUID(PlayerEngineController mod, UUID target) {
        for (class_1297 entity : mod.getWorld().method_27909()) {
            if (!entity.method_5667().equals(target)) continue;
            return entity.method_5739((class_1297)mod.getPlayer());
        }
        return Float.MAX_VALUE;
    }

    public static float getDistanceToUsername(PlayerEngineController mod, String username) {
        return mod.getWorld().method_18456().stream().filter(p -> p.method_5477().getString().equals(username)).findFirst().map(p -> Float.valueOf(p.method_5739((class_1297)mod.getPlayer()))).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue();
    }
}

