/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction.compound;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.ClearLiquidTask;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceObsidianBucketTask;
import com.player2.playerengine.tasks.movement.GetWithinRangeOfBlockTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.tasks.speedrun.beatgame.BeatMinecraftTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public class ConstructNetherPortalBucketTask
extends Task {
    private static final class_2382[] PORTAL_FRAME = new class_2382[]{new class_2382(0, 0, -1), new class_2382(0, 1, -1), new class_2382(0, 2, -1), new class_2382(0, 0, 2), new class_2382(0, 1, 2), new class_2382(0, 2, 2), new class_2382(0, 3, 0), new class_2382(0, 3, 1), new class_2382(0, -1, 0), new class_2382(0, -1, 1)};
    private static final class_2382[] PORTAL_INTERIOR = new class_2382[]{new class_2382(0, 0, 0), new class_2382(0, 1, 0), new class_2382(0, 2, 0), new class_2382(0, 0, 1), new class_2382(0, 1, 1), new class_2382(0, 2, 1), new class_2382(1, 0, 0), new class_2382(1, 1, 0), new class_2382(1, 2, 0), new class_2382(1, 0, 1), new class_2382(1, 1, 1), new class_2382(1, 2, 1), new class_2382(-1, 0, 0), new class_2382(-1, 1, 0), new class_2382(-1, 2, 0), new class_2382(-1, 0, 1), new class_2382(-1, 1, 1), new class_2382(-1, 2, 1)};
    private static final class_2382 PORTALABLE_REGION_SIZE = new class_2382(4, 6, 6);
    private static final class_2382 PORTAL_ORIGIN_RELATIVE_TO_REGION = new class_2382(1, 0, 2);
    private final TimerGame lavaSearchTimer = new TimerGame(5.0);
    private final MovementProgressChecker progressChecker = new MovementProgressChecker();
    private final TimeoutWanderTask wanderTask = new TimeoutWanderTask(5.0f);
    private final Task collectLavaTask = TaskCatalogue.getItemTask(class_1802.field_8187, 1);
    private final TimerGame refreshTimer = new TimerGame(11.0);
    private class_2338 portalOrigin = null;
    private Task getToLakeTask = null;
    private class_2338 currentDestroyTarget = null;
    private boolean firstSearch = false;

    @Override
    protected void onStart() {
        this.currentDestroyTarget = null;
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().push();
        mod.getBehaviour().avoidBlockBreaking(block -> {
            if (this.portalOrigin != null) {
                for (class_2382 framePosRelative : PORTAL_FRAME) {
                    class_2338 framePos = this.portalOrigin.method_10081(framePosRelative);
                    if (!block.equals((Object)framePos)) continue;
                    return mod.getWorld().method_8320(framePos).method_26204() == class_2246.field_10540;
                }
            }
            return false;
        });
        mod.getBehaviour().addProtectedItems(class_1802.field_8705, class_1802.field_8187, class_1802.field_8884, class_1802.field_8814);
        this.progressChecker.reset();
    }

    @Override
    protected Task onTick() {
        boolean needsToLookForPortal;
        PlayerEngineController mod = this.controller;
        if (this.portalOrigin != null && mod.getWorld().method_8320(this.portalOrigin.method_10084()).method_26204() == class_2246.field_10316) {
            this.setDebugState("Done constructing nether portal.");
            mod.getBlockScanner().addBlock(class_2246.field_10316, this.portalOrigin.method_10084());
            return null;
        }
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progressChecker.reset();
        }
        if (this.wanderTask.isActive() && !this.wanderTask.isFinished()) {
            this.setDebugState("Trying again.");
            this.progressChecker.reset();
            return this.wanderTask;
        }
        if (!this.progressChecker.check(mod)) {
            mod.getBaritone().getPathingBehavior().forceCancel();
            if (this.portalOrigin != null && this.currentDestroyTarget != null) {
                mod.getBlockScanner().requestBlockUnreachable(this.portalOrigin);
                mod.getBlockScanner().requestBlockUnreachable(this.currentDestroyTarget);
                if (mod.getBlockScanner().isUnreachable(this.portalOrigin) && mod.getBlockScanner().isUnreachable(this.currentDestroyTarget)) {
                    this.portalOrigin = null;
                    this.currentDestroyTarget = null;
                }
                return this.wanderTask;
            }
        }
        if (this.refreshTimer.elapsed()) {
            Debug.logMessage("Duct tape: Refreshing inventory again just in case");
            this.refreshTimer.reset();
        }
        if (this.portalOrigin != null && !this.portalOrigin.method_19769((class_2374)mod.getPlayer().method_19538(), 2000.0)) {
            this.portalOrigin = null;
            this.currentDestroyTarget = null;
        }
        if (this.currentDestroyTarget != null) {
            if (WorldHelper.isSolidBlock(this.controller, this.currentDestroyTarget)) {
                return new DestroyBlockTask(this.currentDestroyTarget);
            }
            this.currentDestroyTarget = null;
        }
        if (!mod.getItemStorage().hasItem(class_1802.field_8884) && !mod.getItemStorage().hasItem(class_1802.field_8814)) {
            this.setDebugState("Getting flint & steel");
            this.progressChecker.reset();
            return TaskCatalogue.getItemTask(class_1802.field_8884, 1);
        }
        int bucketCount = mod.getItemStorage().getItemCount(class_1802.field_8550, class_1802.field_8187, class_1802.field_8705);
        if (bucketCount < 2) {
            this.setDebugState("Getting buckets");
            this.progressChecker.reset();
            if (mod.getItemStorage().hasItem(class_1802.field_8187)) {
                return TaskCatalogue.getItemTask(class_1802.field_8705, 1);
            }
            if (mod.getItemStorage().hasItem(class_1802.field_8705)) {
                return TaskCatalogue.getItemTask(class_1802.field_8187, 1);
            }
            return mod.getEntityTracker().itemDropped(class_1802.field_8705, class_1802.field_8187) ? new PickupDroppedItemTask(new ItemTarget(new class_1792[]{class_1802.field_8705, class_1802.field_8187}, 1), true) : TaskCatalogue.getItemTask(class_1802.field_8550, 2);
        }
        boolean bl = needsToLookForPortal = this.portalOrigin == null;
        if (needsToLookForPortal) {
            this.progressChecker.reset();
            if (!mod.getItemStorage().hasItem(class_1802.field_8705)) {
                this.setDebugState("Getting water");
                this.progressChecker.reset();
                return TaskCatalogue.getItemTask(class_1802.field_8705, 1);
            }
            boolean foundSpot = false;
            if (this.firstSearch || this.lavaSearchTimer.elapsed()) {
                this.firstSearch = false;
                this.lavaSearchTimer.reset();
                Debug.logMessage("(Searching for lava lake with portalable spot nearby...)");
                class_2338 lavaPos = this.findLavaLake(mod, mod.getPlayer().method_24515());
                if (lavaPos != null) {
                    class_2338 foundPortalRegion = this.getPortalableRegion(mod, lavaPos, mod.getPlayer().method_24515(), new class_2382(-1, 0, 0), PORTALABLE_REGION_SIZE, 20);
                    if (foundPortalRegion != null) {
                        this.portalOrigin = foundPortalRegion.method_10081(PORTAL_ORIGIN_RELATIVE_TO_REGION);
                        foundSpot = true;
                        this.getToLakeTask = new GetWithinRangeOfBlockTask(this.portalOrigin, 7);
                        return this.getToLakeTask;
                    }
                    Debug.logWarning("Failed to find portalable region nearby. Consider increasing the search timeout range");
                } else {
                    Debug.logMessage("(lava lake not found)");
                }
            }
            if (!foundSpot) {
                this.setDebugState("(timeout: Looking for lava lake)");
                return new TimeoutWanderTask();
            }
        }
        if (BeatMinecraftTask.isTaskRunning(mod, this.getToLakeTask)) {
            return this.getToLakeTask;
        }
        for (class_2382 framePosRelative : PORTAL_FRAME) {
            class_2338 framePos = this.portalOrigin.method_10081(framePosRelative);
            class_2248 frameBlock = mod.getWorld().method_8320(framePos).method_26204();
            if (frameBlock != class_2246.field_10540) {
                if (!mod.getItemStorage().hasItem(class_1802.field_8187) && frameBlock != class_2246.field_10164) {
                    this.setDebugState("Collecting lava");
                    this.progressChecker.reset();
                    return this.collectLavaTask;
                }
                if (mod.getBlockScanner().isUnreachable(framePos)) {
                    this.portalOrigin = null;
                }
                return new PlaceObsidianBucketTask(framePos);
            }
            class_2338 waterCheck = framePos.method_10084();
            if (mod.getWorld().method_8320(waterCheck).method_26204() != class_2246.field_10382 || !WorldHelper.isSourceBlock(this.controller, waterCheck, true)) continue;
            this.setDebugState("Clearing water from cast");
            return new ClearLiquidTask(waterCheck);
        }
        for (class_2382 offs : PORTAL_INTERIOR) {
            class_2338 p = this.portalOrigin.method_10081(offs);
            assert (this.controller.getWorld() != null);
            if (this.controller.getWorld().method_8320(p).method_26215()) continue;
            this.setDebugState("Clearing inside of portal");
            this.currentDestroyTarget = p;
            return null;
        }
        this.setDebugState("Flinting and Steeling");
        return new InteractWithBlockTask(new ItemTarget(new class_1792[]{class_1802.field_8884, class_1802.field_8814}, 1), class_2350.field_11036, this.portalOrigin.method_10074(), true);
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof ConstructNetherPortalBucketTask;
    }

    @Override
    protected String toDebugString() {
        return "Construct Nether Portal";
    }

    private class_2338 findLavaLake(PlayerEngineController mod, class_2338 playerPos) {
        HashSet<class_2338> alreadyExplored = new HashSet<class_2338>();
        double nearestSqDistance = Double.POSITIVE_INFINITY;
        class_2338 nearestLake = null;
        List<class_2338> lavas = mod.getBlockScanner().getKnownLocations(class_2246.field_10164);
        if (!lavas.isEmpty()) {
            for (class_2338 pos : lavas) {
                int depth;
                double sqDist;
                if (alreadyExplored.contains(pos) || !((sqDist = playerPos.method_10262((class_2382)pos)) < nearestSqDistance) || (depth = this.getNumberOfBlocksAdjacent(alreadyExplored, pos)) == 0) continue;
                Debug.logMessage("Found with depth " + depth);
                if (depth < 12) continue;
                nearestSqDistance = sqDist;
                nearestLake = pos;
            }
        }
        return nearestLake;
    }

    private int getNumberOfBlocksAdjacent(HashSet<class_2338> alreadyExplored, class_2338 start) {
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        queue.add(start);
        int bonus = 0;
        while (!queue.isEmpty()) {
            int level;
            class_2338 origin = (class_2338)queue.poll();
            if (alreadyExplored.contains(origin)) continue;
            alreadyExplored.add(origin);
            assert (this.controller.getWorld() != null);
            class_2680 s = this.controller.getWorld().method_8320(origin);
            if (s.method_26204() != class_2246.field_10164 || !s.method_26227().method_15771() || (level = s.method_26227().method_15761()) != 8) continue;
            queue.addAll(List.of(origin.method_10095(), origin.method_10072(), origin.method_10078(), origin.method_10067(), origin.method_10084(), origin.method_10074()));
            ++bonus;
        }
        return bonus;
    }

    private class_2338 getPortalableRegion(PlayerEngineController mod, class_2338 lava, class_2338 playerPos, class_2382 sizeOffset, class_2382 sizeAllocation, int timeoutRange) {
        class_2382[] directions = new class_2382[]{new class_2382(1, 0, 0), new class_2382(-1, 0, 0), new class_2382(0, 0, 1), new class_2382(0, 0, -1)};
        double minDistanceToPlayer = Double.POSITIVE_INFINITY;
        class_2338 bestPos = null;
        block0: for (class_2382 direction : directions) {
            for (int offs = 1; offs < timeoutRange; ++offs) {
                class_2382 offset = new class_2382(direction.method_10263() * offs, direction.method_10264() * offs, direction.method_10260() * offs);
                boolean found = true;
                boolean solidFound = false;
                block2: for (int dx = -1; dx < sizeAllocation.method_10263() + 1; ++dx) {
                    for (int dz = -1; dz < sizeAllocation.method_10260() + 1; ++dz) {
                        for (int dy = -1; dy < sizeAllocation.method_10264(); ++dy) {
                            class_2338 toCheck = lava.method_10081(offset).method_10081(sizeOffset).method_10069(dx, dy, dz);
                            assert (this.controller.getWorld() != null);
                            class_2680 state = this.controller.getWorld().method_8320(toCheck);
                            if (state.method_26204() == class_2246.field_10164 || state.method_26204() == class_2246.field_10382 || state.method_26204() == class_2246.field_9987) {
                                found = false;
                                break block2;
                            }
                            if (dy > 1 || solidFound || !WorldHelper.isSolidBlock(this.controller, toCheck)) continue;
                            solidFound = true;
                        }
                    }
                }
                if (!solidFound) continue block0;
                if (!found) continue;
                class_2338 foundBoxCorner = lava.method_10081(offset).method_10081(sizeOffset);
                double sqDistance = foundBoxCorner.method_10262((class_2382)playerPos);
                if (!(sqDistance < minDistanceToPlayer)) continue block0;
                minDistanceToPlayer = sqDistance;
                bestPos = foundBoxCorner;
                continue block0;
            }
        }
        return bestPos;
    }
}

