/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.container;

import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.slot.EnsureFreeInventorySlotTask;
import com.player2.playerengine.util.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2621;

public class LootContainerTask
extends Task {
    private final class_2338 containerPos;
    private final List<class_1792> targets;
    private final Predicate<class_1799> check;
    private boolean finished = false;

    public LootContainerTask(class_2338 chestPos, List<class_1792> items, Predicate<class_1799> pred) {
        this.containerPos = chestPos;
        this.targets = items;
        this.check = pred;
    }

    public LootContainerTask(class_2338 chestPos, List<class_1792> items) {
        this(chestPos, items, itemStack -> true);
    }

    @Override
    protected void onStart() {
        this.controller.getBehaviour().push();
        this.controller.getBehaviour().addProtectedItems(this.targets.toArray(new class_1792[0]));
    }

    @Override
    protected Task onTick() {
        if (this.finished) {
            return null;
        }
        if (!this.containerPos.method_19771(new class_2382((int)this.controller.getEntity().method_19538().field_1352, (int)this.controller.getEntity().method_19538().field_1351, (int)this.controller.getEntity().method_19538().field_1350), 4.5)) {
            this.setDebugState("Going to container");
            return new GetToBlockTask(this.containerPos);
        }
        class_2586 class_25862 = this.controller.getWorld().method_8321(this.containerPos);
        if (class_25862 instanceof class_2621) {
            class_2621 container;
            class_2621 containerInventory = container = (class_2621)class_25862;
            LivingEntityInventory playerInventory = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
            this.controller.getItemStorage().containers.WritableCache(this.controller, this.containerPos);
            boolean somethingToLoot = false;
            this.setDebugState("Looting items: " + String.valueOf(this.targets));
            for (int i = 0; i < containerInventory.method_5439(); ++i) {
                class_1799 stack = containerInventory.method_5438(i);
                if (stack.method_7960() || !this.targets.contains(stack.method_7909()) || !this.check.test(stack)) continue;
                somethingToLoot = true;
                if (!playerInventory.insertStack(new class_1799((class_1935)stack.method_7909()))) {
                    this.setDebugState("Inventory is full, ensuring space.");
                    return new EnsureFreeInventorySlotTask();
                }
                if (playerInventory.insertStack(stack.method_7972())) {
                    containerInventory.method_5447(i, class_1799.field_8037);
                    container.method_5431();
                    this.controller.getItemStorage().registerSlotAction();
                    return null;
                }
                Debug.logWarning("Failed to insert stack even after checking for space.");
            }
            if (!somethingToLoot) {
                this.setDebugState("Container empty or has no desired items.");
                this.finished = true;
            }
            return null;
        }
        Debug.logWarning("Block at " + String.valueOf(this.containerPos) + " is not a lootable container. Stopping.");
        this.finished = true;
        return null;
    }

    @Override
    public boolean isFinished() {
        return this.finished || !this.controller.getChunkTracker().isChunkLoaded(this.containerPos) || !(this.controller.getWorld().method_8321(this.containerPos) instanceof class_2621);
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof LootContainerTask)) {
            bl = false;
        } else {
            LootContainerTask task = (LootContainerTask)other;
            bl = Objects.equals(task.containerPos, this.containerPos) && new ArrayList<class_1792>(task.targets).equals(new ArrayList<class_1792>(this.targets));
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Looting container at " + this.containerPos.method_23854();
    }
}

