/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.entity;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.trackers.storage.ItemStorageTracker;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1667;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class ShootArrowSimpleProjectileTask
extends Task {
    private final class_1297 target;
    private boolean shooting = false;
    private boolean shot = false;
    private final TimerGame shotTimer = new TimerGame(1.0);

    public ShootArrowSimpleProjectileTask(class_1297 target) {
        this.target = target;
    }

    @Override
    protected void onStart() {
        this.shooting = false;
    }

    private static Rotation calculateThrowLook(PlayerEngineController mod, class_1297 target) {
        float velocity = (float)(mod.getPlayer().method_6048() - mod.getPlayer().method_6014()) / 20.0f;
        if ((velocity = (velocity * velocity + velocity * 2.0f) / 3.0f) > 1.0f) {
            velocity = 1.0f;
        }
        class_243 targetCenter = target.method_5829().method_1005();
        double posX = targetCenter.method_10216();
        double posY = targetCenter.method_10214();
        double posZ = targetCenter.method_10215();
        double relativeX = posX - mod.getPlayer().method_23317();
        double relativeY = (posY -= (double)(1.9f - target.method_17682())) - mod.getPlayer().method_23318();
        double relativeZ = posZ - mod.getPlayer().method_23321();
        double hDistance = Math.sqrt(relativeX * relativeX + relativeZ * relativeZ);
        double hDistanceSq = hDistance * hDistance;
        float g = 0.006f;
        float velocitySq = velocity * velocity;
        float pitch = (float)(-Math.toDegrees(Math.atan(((double)velocitySq - Math.sqrt((double)(velocitySq * velocitySq) - (double)0.006f * ((double)0.006f * hDistanceSq + 2.0 * relativeY * (double)velocitySq))) / (double)0.006f * hDistance)));
        return Float.isNaN(pitch) ? new Rotation(target.method_36454(), target.method_36455()) : new Rotation(ShootArrowSimpleProjectileTask.Vec3dToYaw(mod, new class_243(posX, posY, posZ)), pitch);
    }

    private static float Vec3dToYaw(PlayerEngineController mod, class_243 vec) {
        return mod.getPlayer().method_36454() + class_3532.method_15393((float)((float)Math.toDegrees(Math.atan2(vec.method_10215() - mod.getPlayer().method_23321(), vec.method_10216() - mod.getPlayer().method_23317())) - 90.0f - mod.getPlayer().method_36454()));
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        this.setDebugState("Shooting projectile");
        List<class_1792> requiredArrows = Arrays.asList(class_1802.field_8107, class_1802.field_8236, class_1802.field_8087);
        if (mod.getItemStorage().hasItem(class_1802.field_8102)) {
            if (requiredArrows.stream().anyMatch(arg_0 -> ShootArrowSimpleProjectileTask.lambda$onTick$0(mod.getItemStorage(), arg_0))) {
                Rotation lookTarget = ShootArrowSimpleProjectileTask.calculateThrowLook(mod, this.target);
                LookHelper.lookAt(this.controller, lookTarget);
                boolean charged = mod.getPlayer().method_6048() > 20 && mod.getPlayer().method_6030().method_7909() == class_1802.field_8102;
                mod.getSlotHandler().forceEquipItem(class_1802.field_8102);
                if (LookHelper.isLookingAt(mod, lookTarget) && !this.shooting) {
                    mod.getInputControls().hold(Input.CLICK_RIGHT);
                    this.shooting = true;
                    this.shotTimer.reset();
                }
                if (this.shooting && charged) {
                    for (class_1667 arrow : mod.getEntityTracker().getTrackedEntities(class_1667.class)) {
                        class_243 delta;
                        class_243 velocity;
                        boolean isMovingTowardsTarget;
                        if (arrow.method_24921() != mod.getPlayer() || !(isMovingTowardsTarget = (velocity = arrow.method_18798()).method_1026(delta = this.target.method_19538().method_1020(arrow.method_19538())) > 0.0)) continue;
                        return null;
                    }
                    mod.getInputControls().release(Input.CLICK_RIGHT);
                    this.shot = true;
                }
                return null;
            }
        }
        Debug.logMessage("Missing items, stopping.");
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getInputControls().release(Input.CLICK_RIGHT);
    }

    @Override
    public boolean isFinished() {
        return this.shot;
    }

    @Override
    protected boolean isEqual(Task other) {
        return false;
    }

    @Override
    protected String toDebugString() {
        return "Shooting arrow at " + this.target.method_5864().method_5882();
    }

    private static /* synthetic */ boolean lambda$onTick$0(ItemStorageTracker rec$, class_1792 xva$0) {
        return rec$.hasItem(xva$0);
    }
}

