/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.misc;

import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.misc.LootDesertTempleTask;
import com.player2.playerengine.tasks.movement.SearchWithinBiomeTask;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_5321;

public class RavageDesertTemplesTask
extends Task {
    public final class_1792[] LOOT = new class_1792[]{class_1802.field_8606, class_1802.field_8511, class_1802.field_8054, class_1802.field_8858, class_1802.field_8276, class_1802.field_8680, class_1802.field_8598, class_1802.field_8175, class_1802.field_8463, class_1802.field_8695, class_1802.field_8620, class_1802.field_8687, class_1802.field_8578, class_1802.field_8560, class_1802.field_8477, class_1802.field_8807, class_1802.field_8367};
    private class_2338 currentTemple;
    private Task lootTask;
    private Task pickaxeTask;

    @Override
    protected void onStart() {
        this.controller.getBehaviour().push();
    }

    @Override
    protected Task onTick() {
        if (this.pickaxeTask != null && !this.pickaxeTask.isFinished()) {
            this.setDebugState("Need to get pickaxes first");
            return this.pickaxeTask;
        }
        if (this.lootTask != null && !this.lootTask.isFinished()) {
            this.setDebugState("Looting found temple");
            return this.lootTask;
        }
        if (StorageHelper.miningRequirementMetInventory(this.controller, MiningRequirement.WOOD)) {
            this.setDebugState("Need to get pickaxes first");
            this.pickaxeTask = new CataloguedResourceTask(new ItemTarget(class_1802.field_8647, 2));
            return this.pickaxeTask;
        }
        this.currentTemple = WorldHelper.getADesertTemple(this.controller);
        if (this.currentTemple != null) {
            this.lootTask = new LootDesertTempleTask(this.currentTemple, List.of(this.LOOT));
            this.setDebugState("Looting found temple");
            return this.lootTask;
        }
        return new SearchWithinBiomeTask((class_5321<class_1959>)class_1972.field_9424);
    }

    @Override
    protected void onStop(Task task) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof RavageDesertTemplesTask;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    protected String toDebugString() {
        return "Ravaging Desert Temples";
    }
}

