/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.misc;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.container.LootContainerTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;

public class RavageRuinedPortalsTask
extends Task {
    public final class_1792[] LOOT = new class_1792[]{class_1802.field_8675, class_1802.field_8145, class_1802.field_8281, class_1802.field_8814, class_1802.field_8884, class_1802.field_8397, class_1802.field_8463, class_1802.field_8825, class_1802.field_8303, class_1802.field_8335, class_1802.field_8322, class_1802.field_8845, class_1802.field_8862, class_1802.field_8678, class_1802.field_8416, class_1802.field_8753, class_1802.field_8597, class_1802.field_8071, class_1802.field_8695, class_1802.field_8557, class_1802.field_8721, class_1802.field_8560, class_1802.field_8494, class_1802.field_16315, class_1802.field_8367};
    private List<class_2338> notRuinedPortalChests = new ArrayList<class_2338>();
    private Task lootTask;

    @Override
    protected void onStart() {
        this.controller.getBehaviour().push();
    }

    @Override
    protected Task onTick() {
        if (this.lootTask != null && this.lootTask.isActive() && !this.lootTask.isFinished()) {
            return this.lootTask;
        }
        Optional<class_2338> closest = this.locateClosestUnopenedRuinedPortalChest(this.controller);
        if (closest.isPresent()) {
            this.lootTask = new LootContainerTask(closest.get(), List.of(this.LOOT));
            return this.lootTask;
        }
        return new TimeoutWanderTask();
    }

    @Override
    protected void onStop(Task task) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task task) {
        return task instanceof RavageRuinedPortalsTask;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    protected String toDebugString() {
        return "Ravaging Ruined Portals";
    }

    private boolean canBeLootablePortalChest(PlayerEngineController mod, class_2338 blockPos) {
        if (mod.getWorld().method_8320(blockPos.method_10086(1)).method_26204() != class_2246.field_10382 && blockPos.method_10264() >= 50) {
            for (class_2338 check : WorldHelper.scanRegion(blockPos.method_10069(-4, -2, -4), blockPos.method_10069(4, 2, 4))) {
                if (mod.getWorld().method_8320(check).method_26204() != class_2246.field_10515) continue;
                return true;
            }
            this.notRuinedPortalChests.add(blockPos);
            return false;
        }
        return false;
    }

    private Optional<class_2338> locateClosestUnopenedRuinedPortalChest(PlayerEngineController mod) {
        return WorldHelper.getCurrentDimension(this.controller) != Dimension.OVERWORLD ? Optional.empty() : mod.getBlockScanner().getNearestBlock(blockPos -> !this.notRuinedPortalChests.contains(blockPos) && WorldHelper.isUnopenedChest(this.controller, blockPos) && this.canBeLootablePortalChest(mod, (class_2338)blockPos), class_2246.field_10034);
    }
}

