/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToChunkTask;
import com.player2.playerengine.util.Debug;
import dev.architectury.event.events.common.ChunkEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;

abstract class ChunkSearchTask
extends Task {
    private final class_2338 startPoint;
    private final Object searchMutex = new Object();
    private final Set<class_1923> consideredAlready = new HashSet<class_1923>();
    private final Set<class_1923> searchedAlready = new HashSet<class_1923>();
    private final ArrayList<class_1923> searchLater = new ArrayList();
    private final ArrayList<class_1923> justLoaded = new ArrayList();
    private boolean first = true;
    private boolean finished = false;

    public ChunkSearchTask(class_2338 startPoint) {
        this.startPoint = startPoint;
    }

    public ChunkSearchTask(class_1923 chunkPos) {
        this(chunkPos.method_8323().method_10069(1, 1, 1));
    }

    public Set<class_1923> getSearchedChunks() {
        return this.searchedAlready;
    }

    public boolean finished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onStart() {
        if (this.first) {
            this.finished = false;
            this.first = false;
            class_1923 startPos = this.controller.getWorld().method_22350(this.startPoint).method_12004();
            Object object = this.searchMutex;
            synchronized (object) {
                this.searchChunkOrQueueSearch(this.controller, startPos);
            }
        }
        ChunkEvent.LOAD_DATA.register((chunk, level, data) -> {
            if (chunk != null) {
                Object object = this.searchMutex;
                synchronized (object) {
                    if (!this.searchedAlready.contains(chunk.method_12004())) {
                        this.justLoaded.add(chunk.method_12004());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Task onTick() {
        Object object = this.searchMutex;
        synchronized (object) {
            if (!this.justLoaded.isEmpty()) {
                for (class_1923 justLoaded : this.justLoaded) {
                    if (!this.searchLater.contains(justLoaded) || !this.trySearchChunk(this.controller, justLoaded)) continue;
                    this.searchLater.remove(justLoaded);
                }
            }
            this.justLoaded.clear();
        }
        class_1923 closest = this.getBestChunk(this.controller, this.searchLater);
        if (closest == null) {
            this.finished = true;
            Debug.logWarning("Failed to find any chunks to go to. If we finish, that means we scanned all possible chunks.");
            return null;
        }
        return new GetToChunkTask(closest);
    }

    protected class_1923 getBestChunk(PlayerEngineController mod, List<class_1923> chunks) {
        double lowestScore = Double.POSITIVE_INFINITY;
        class_1923 bestChunk = null;
        if (!chunks.isEmpty()) {
            for (class_1923 toSearch : chunks) {
                double distanceToCenterSq;
                double pz;
                double cx = (double)(toSearch.method_8326() + toSearch.method_8327() + 1) / 2.0;
                double cz = (double)(toSearch.method_8328() + toSearch.method_8329() + 1) / 2.0;
                double px = mod.getPlayer().method_23317();
                double distanceSq = (cx - px) * (cx - px) + (cz - (pz = mod.getPlayer().method_23321())) * (cz - pz);
                double score = distanceSq + (distanceToCenterSq = new class_243((double)this.startPoint.method_10263() - cx, 0.0, (double)this.startPoint.method_10260() - cz).method_1027()) * 0.8;
                if (!(score < lowestScore)) continue;
                lowestScore = score;
                bestChunk = toSearch;
            }
        }
        return bestChunk;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    public boolean isFinished() {
        return this.searchLater.size() == 0;
    }

    @Override
    protected boolean isEqual(Task other) {
        if (other instanceof ChunkSearchTask) {
            ChunkSearchTask task = (ChunkSearchTask)other;
            return !task.startPoint.equals((Object)this.startPoint) ? false : this.isChunkSearchEqual(task);
        }
        return false;
    }

    private void searchChunkOrQueueSearch(PlayerEngineController mod, class_1923 pos) {
        if (!this.consideredAlready.contains(pos)) {
            this.consideredAlready.add(pos);
            if (!this.trySearchChunk(mod, pos) && !this.searchedAlready.contains(pos)) {
                this.searchLater.add(pos);
            }
        }
    }

    private boolean trySearchChunk(PlayerEngineController mod, class_1923 pos) {
        if (this.searchedAlready.contains(pos)) {
            return true;
        }
        if (mod.getChunkTracker().isChunkLoaded(pos)) {
            this.searchedAlready.add(pos);
            if (this.isChunkPartOfSearchSpace(mod, pos)) {
                this.searchChunkOrQueueSearch(mod, new class_1923(pos.field_9181 + 1, pos.field_9180));
                this.searchChunkOrQueueSearch(mod, new class_1923(pos.field_9181 - 1, pos.field_9180));
                this.searchChunkOrQueueSearch(mod, new class_1923(pos.field_9181, pos.field_9180 + 1));
                this.searchChunkOrQueueSearch(mod, new class_1923(pos.field_9181, pos.field_9180 - 1));
            }
            return true;
        }
        return false;
    }

    protected abstract boolean isChunkPartOfSearchSpace(PlayerEngineController var1, class_1923 var2);

    protected abstract boolean isChunkSearchEqual(ChunkSearchTask var1);
}

