/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.chains.MobDefenseChain;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.util.baritone.GoalRunAwayFromEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1548;
import net.minecraft.class_243;

public class RunAwayFromCreepersTask
extends CustomBaritoneGoalTask {
    private final double distanceToRun;

    public RunAwayFromCreepersTask(double distance) {
        this.distanceToRun = distance;
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof RunAwayFromCreepersTask) {
            RunAwayFromCreepersTask task = (RunAwayFromCreepersTask)other;
            bl = !(Math.abs(task.distanceToRun - this.distanceToRun) > 1.0);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Run " + this.distanceToRun + " blocks away from creepers";
    }

    @Override
    protected Goal newGoal(PlayerEngineController mod) {
        mod.getBaritone().getPathingBehavior().forceCancel();
        return new GoalRunAwayFromCreepers(mod, this.distanceToRun);
    }

    private static class GoalRunAwayFromCreepers
    extends GoalRunAwayFromEntities {
        public GoalRunAwayFromCreepers(PlayerEngineController mod, double distance) {
            super(mod, distance, false, 10.0);
        }

        @Override
        protected List<class_1297> getEntities(PlayerEngineController mod) {
            return new ArrayList<class_1548>(mod.getEntityTracker().getTrackedEntities(class_1548.class));
        }

        @Override
        protected double getCostOfEntity(class_1297 entity, int x, int y, int z) {
            return entity instanceof class_1548 ? MobDefenseChain.getCreeperSafety(new class_243((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), (class_1548)entity) : super.getCostOfEntity(entity, x, y, z);
        }
    }
}

