/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.movement.SearchWithinBiomeTask;
import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.class_1802;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2282;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5321;

public class CollectCocoaBeansTask
extends ResourceTask {
    private final int count;
    private final HashSet<class_2338> wasFullyGrown = new HashSet();

    public CollectCocoaBeansTask(int targetCount) {
        super(class_1802.field_8116, targetCount);
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        Predicate<class_2338> validCocoa = blockPos -> {
            boolean mature;
            if (!mod.getChunkTracker().isChunkLoaded((class_2338)blockPos)) {
                return this.wasFullyGrown.contains(blockPos);
            }
            class_2680 s = mod.getWorld().method_8320(blockPos);
            boolean bl = mature = (Integer)s.method_11654((class_2769)class_2282.field_10779) == 2;
            if (this.wasFullyGrown.contains(blockPos)) {
                if (!mature) {
                    this.wasFullyGrown.remove(blockPos);
                }
            } else if (mature) {
                this.wasFullyGrown.add((class_2338)blockPos);
            }
            return mature;
        };
        if (mod.getBlockScanner().anyFound(validCocoa, class_2246.field_10302)) {
            this.setDebugState("Breaking cocoa blocks");
            return new DoToClosestBlockTask(DestroyBlockTask::new, validCocoa, class_2246.field_10302);
        }
        if (this.isInWrongDimension(mod)) {
            return this.getToCorrectDimensionTask(mod);
        }
        this.setDebugState("Exploring around jungles");
        return new SearchWithinBiomeTask((class_5321<class_1959>)class_1972.field_9417);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectCocoaBeansTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " cocoa beans.";
    }
}

