/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockNearbyTask;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Optional;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;

public class CollectFlintTask
extends ResourceTask {
    private static final float CLOSE_ENOUGH_FLINT = 10.0f;
    private final int count;

    public CollectFlintTask(int targetCount) {
        super(class_1802.field_8145, targetCount);
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        Optional<class_2338> closest = mod.getBlockScanner().getNearestBlock(mod.getPlayer().method_19538(), validGravel -> WorldHelper.fallingBlockSafeToBreak(this.controller, validGravel) && WorldHelper.canBreak(this.controller, validGravel), class_2246.field_10255);
        if (closest.isPresent() && closest.get().method_19769((class_2374)mod.getPlayer().method_19538(), 10.0)) {
            return new DoToClosestBlockTask(DestroyBlockTask::new, class_2246.field_10255);
        }
        return mod.getItemStorage().hasItem(class_1802.field_8110) ? new PlaceBlockNearbyTask(class_2246.field_10255) : TaskCatalogue.getItemTask(class_1802.field_8110, 1);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof CollectFlintTask) {
            CollectFlintTask task = (CollectFlintTask)other;
            bl = task.count == this.count;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect " + this.count + " flint";
    }
}

