/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.WorldHelper;
import net.minecraft.class_1802;

public class CollectFuelTask
extends Task {
    private final double targetFuel;

    public CollectFuelTask(double targetFuel) {
        this.targetFuel = targetFuel;
    }

    @Override
    protected void onStart() {
    }

    @Override
    protected Task onTick() {
        switch (WorldHelper.getCurrentDimension(this.controller)) {
            case OVERWORLD: {
                this.setDebugState("Collecting coal.");
                return TaskCatalogue.getItemTask(class_1802.field_8713, (int)Math.ceil(this.targetFuel / 8.0));
            }
            case END: {
                this.setDebugState("Going to overworld, since, well, no more fuel can be found here.");
                return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
            }
            case NETHER: {
                this.setDebugState("Going to overworld, since we COULD use wood but wood confuses the bot. A bug at the moment.");
                return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
            }
        }
        this.setDebugState("INVALID DIMENSION: " + String.valueOf((Object)WorldHelper.getCurrentDimension(this.controller)));
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (other instanceof CollectFuelTask) {
            CollectFuelTask task = (CollectFuelTask)other;
            bl = Math.abs(task.targetFuel - this.targetFuel) < 0.01;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isFinished() {
        return (double)this.controller.getItemStorage().getItemCountInventoryOnly(class_1802.field_8713) >= this.targetFuel;
    }

    @Override
    protected String toDebugString() {
        return "Collect Fuel: x" + this.targetFuel;
    }
}

