/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.movement.GetCloseToBlockTask;
import com.player2.playerengine.tasks.movement.SearchChunkForBlockTask;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Optional;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

public class CollectHoneycombTask
extends ResourceTask {
    private final boolean campfire;
    private final int count;
    private class_2338 nest;

    public CollectHoneycombTask(int targetCount) {
        super(class_1802.field_20414, targetCount);
        this.campfire = true;
        this.count = targetCount;
    }

    public CollectHoneycombTask(int targetCount, boolean useCampfire) {
        super(class_1802.field_20414, targetCount);
        this.campfire = useCampfire;
        this.count = targetCount;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        Optional<class_2338> getNearestNest;
        if (this.nest == null && (getNearestNest = mod.getBlockScanner().getNearestBlock(class_2246.field_20421)).isPresent()) {
            this.nest = getNearestNest.get();
        }
        if (this.nest == null) {
            if (this.campfire && !mod.getItemStorage().hasItemInventoryOnly(class_1802.field_17346)) {
                this.setDebugState("Can't find nest, getting campfire first...");
                return new CataloguedResourceTask(new ItemTarget(class_1802.field_17346, 1));
            }
            this.setDebugState("Alright, we're searching");
            return new SearchChunkForBlockTask(class_2246.field_20421);
        }
        if (this.campfire && !this.isCampfireUnderNest(mod, this.nest)) {
            if (!mod.getItemStorage().hasItemInventoryOnly(class_1802.field_17346)) {
                this.setDebugState("Getting a campfire");
                return new CataloguedResourceTask(new ItemTarget(class_1802.field_17346, 1));
            }
            this.setDebugState("Placing campfire");
            return new PlaceBlockTask(this.nest.method_10087(2), class_2246.field_17350);
        }
        if (!mod.getItemStorage().hasItemInventoryOnly(class_1802.field_8868)) {
            this.setDebugState("Getting shears");
            return new CataloguedResourceTask(new ItemTarget(class_1802.field_8868, 1));
        }
        if ((Integer)mod.getWorld().method_8320(this.nest).method_11654((class_2769)class_2741.field_20432) != 5) {
            if (!this.nest.method_19769((class_2374)mod.getPlayer().method_19538(), 20.0)) {
                this.setDebugState("Getting close to nest");
                return new GetCloseToBlockTask(this.nest);
            }
            this.setDebugState("Waiting for nest to get honey...");
            return null;
        }
        return new InteractWithBlockTask(class_1802.field_8868, this.nest);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectHoneycombTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " Honeycombs " + (this.campfire ? "Peacefully" : "Recklessly");
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    private boolean isCampfireUnderNest(PlayerEngineController mod, class_2338 pos) {
        for (class_2338 underPos : WorldHelper.scanRegion(pos.method_10087(6), pos.method_10074())) {
            if (mod.getWorld().method_8320(underPos).method_26204() != class_2246.field_17350) continue;
            return true;
        }
        return false;
    }
}

