/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.ToolMaterialVer;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.AbstractDoToClosestObjectTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.tasks.resources.SatisfyMiningRequirementTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.helpers.StorageHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import com.player2.playerengine.util.slots.CursorSlot;
import com.player2.playerengine.util.slots.PlayerSlot;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1542;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3545;

public class MineAndCollectTask
extends ResourceTask {
    private final class_2248[] blocksToMine;
    private final MiningRequirement requirement;
    private final TimerGame cursorStackTimer = new TimerGame(3.0);
    private final MineOrCollectTask subtask;

    public MineAndCollectTask(ItemTarget[] itemTargets, class_2248[] blocksToMine, MiningRequirement requirement) {
        super(itemTargets);
        this.requirement = requirement;
        this.blocksToMine = blocksToMine;
        this.subtask = new MineOrCollectTask(this.blocksToMine, itemTargets);
    }

    public MineAndCollectTask(ItemTarget[] blocksToMine, MiningRequirement requirement) {
        this(blocksToMine, MineAndCollectTask.itemTargetToBlockList(blocksToMine), requirement);
    }

    public MineAndCollectTask(ItemTarget target, class_2248[] blocksToMine, MiningRequirement requirement) {
        this(new ItemTarget[]{target}, blocksToMine, requirement);
    }

    public MineAndCollectTask(class_1792 item, int count, class_2248[] blocksToMine, MiningRequirement requirement) {
        this(new ItemTarget(item, count), blocksToMine, requirement);
    }

    public static class_2248[] itemTargetToBlockList(ItemTarget[] targets) {
        ArrayList<class_2248> result = new ArrayList<class_2248>(targets.length);
        for (ItemTarget target : targets) {
            for (class_1792 item : target.getMatches()) {
                class_2248 block = class_2248.method_9503((class_1792)item);
                if (block == null || WorldHelper.isAir(block)) continue;
                result.add(block);
            }
        }
        return (class_2248[])result.toArray(class_2248[]::new);
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
        mod.getBehaviour().addProtectedItems(class_1802.field_8647, class_1802.field_8387, class_1802.field_8403, class_1802.field_8377, class_1802.field_22024);
        this.subtask.resetSearch();
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return true;
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (!StorageHelper.miningRequirementMet(mod, this.requirement)) {
            return new SatisfyMiningRequirementTask(this.requirement);
        }
        if (this.subtask.isMining()) {
            this.makeSureToolIsEquipped(mod);
        }
        return this.subtask.wasWandering() && this.isInWrongDimension(mod) && !mod.getBlockScanner().anyFound(this.blocksToMine) ? this.getToCorrectDimensionTask(mod) : this.subtask;
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof MineAndCollectTask) {
            MineAndCollectTask task = (MineAndCollectTask)other;
            bl = Arrays.equals(task.blocksToMine, this.blocksToMine);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Mine And Collect";
    }

    private void makeSureToolIsEquipped(PlayerEngineController mod) {
        if (this.cursorStackTimer.elapsed() && !mod.getFoodChain().needsToEat()) {
            class_1792 item;
            assert (this.controller.getPlayer() != null);
            class_1799 cursorStack = StorageHelper.getItemStackInCursorSlot(this.controller);
            if (cursorStack != null && !cursorStack.method_7960() && (item = cursorStack.method_7909()).method_58405(cursorStack, mod.getWorld().method_8320(this.subtask.miningPos()))) {
                class_1792 currentlyEquipped = StorageHelper.getItemStackInSlot(PlayerSlot.getEquipSlot(mod.getInventory())).method_7909();
                if (item instanceof class_1766) {
                    if (currentlyEquipped instanceof class_1766) {
                        class_1766 currentPick = (class_1766)currentlyEquipped;
                        class_1766 swapPick = (class_1766)item;
                        if (ToolMaterialVer.getMiningLevel((class_1831)swapPick) > ToolMaterialVer.getMiningLevel((class_1831)currentPick)) {
                            mod.getSlotHandler().forceEquipSlot(this.controller, CursorSlot.SLOT);
                        }
                    } else {
                        mod.getSlotHandler().forceEquipSlot(this.controller, CursorSlot.SLOT);
                    }
                }
            }
            this.cursorStackTimer.reset();
        }
    }

    public static class MineOrCollectTask
    extends AbstractDoToClosestObjectTask<Object> {
        private final class_2248[] blocks;
        private final ItemTarget[] targets;
        private final Set<class_2338> blacklist = new HashSet<class_2338>();
        private final MovementProgressChecker progressChecker = new MovementProgressChecker();
        private final Task pickupTask;
        private class_2338 miningPos;

        public MineOrCollectTask(class_2248[] blocks, ItemTarget[] targets) {
            this.blocks = blocks;
            this.targets = targets;
            this.pickupTask = new PickupDroppedItemTask(targets, true);
        }

        @Override
        protected class_243 getPos(PlayerEngineController mod, Object obj) {
            if (obj instanceof class_2338) {
                class_2338 b = (class_2338)obj;
                return WorldHelper.toVec3d(b);
            }
            if (obj instanceof class_1542) {
                class_1542 item = (class_1542)obj;
                return item.method_19538();
            }
            throw new UnsupportedOperationException("Shouldn't try to get the position of object " + String.valueOf(obj) + " of type " + (obj != null ? obj.getClass().toString() : "(null object)"));
        }

        @Override
        protected Optional<Object> getClosestTo(PlayerEngineController mod, class_243 pos) {
            class_3545<Double, Optional<class_2338>> closestBlock = MineOrCollectTask.getClosestBlock(mod, pos, this.blocks);
            class_3545<Double, Optional<class_1542>> closestDrop = MineOrCollectTask.getClosestItemDrop(mod, pos, this.targets);
            double blockSq = (Double)closestBlock.method_15442();
            double dropSq = (Double)closestDrop.method_15442();
            if (mod.getExtraBaritoneSettings().isInteractionPaused()) {
                return ((Optional)closestDrop.method_15441()).map(Object.class::cast);
            }
            return dropSq <= blockSq ? ((Optional)closestDrop.method_15441()).map(Object.class::cast) : ((Optional)closestBlock.method_15441()).map(Object.class::cast);
        }

        public static class_3545<Double, Optional<class_1542>> getClosestItemDrop(PlayerEngineController mod, class_243 pos, ItemTarget ... items) {
            Optional<class_1542> closestDrop = Optional.empty();
            if (mod.getEntityTracker().itemDropped(items)) {
                closestDrop = mod.getEntityTracker().getClosestItemDrop(pos, items);
            }
            return new class_3545((Object)closestDrop.map(itemEntity -> itemEntity.method_5707(pos) + 10.0).orElse(Double.POSITIVE_INFINITY), closestDrop);
        }

        public static class_3545<Double, Optional<class_2338>> getClosestBlock(PlayerEngineController mod, class_243 pos, class_2248 ... blocks) {
            Optional<class_2338> closestBlock = mod.getBlockScanner().getNearestBlock(pos, check -> mod.getBlockScanner().isUnreachable((class_2338)check) ? false : WorldHelper.canBreak(mod, check), blocks);
            return new class_3545((Object)closestBlock.map(blockPos -> BlockPosVer.getSquaredDistance(blockPos, (class_2374)pos)).orElse(Double.POSITIVE_INFINITY), closestBlock);
        }

        @Override
        protected class_243 getOriginPos(PlayerEngineController mod) {
            return mod.getPlayer().method_19538();
        }

        @Override
        protected Task onTick() {
            PlayerEngineController mod = this.controller;
            if (mod.getBaritone().getPathingBehavior().isPathing()) {
                this.progressChecker.reset();
            }
            if (this.miningPos != null && !this.progressChecker.check(mod)) {
                mod.getBaritone().getPathingBehavior().forceCancel();
                Debug.logMessage("Failed to mine block. Suggesting it may be unreachable.");
                mod.getBlockScanner().requestBlockUnreachable(this.miningPos, 2);
                this.blacklist.add(this.miningPos);
                this.miningPos = null;
                this.progressChecker.reset();
            }
            return super.onTick();
        }

        @Override
        protected Task getGoalTask(Object obj) {
            if (!(obj instanceof class_2338)) {
                if (obj instanceof class_1542) {
                    this.miningPos = null;
                    return this.pickupTask;
                }
                throw new UnsupportedOperationException("Shouldn't try to get the goal from object " + String.valueOf(obj) + " of type " + (obj != null ? obj.getClass().toString() : "(null object)"));
            }
            class_2338 newPos = (class_2338)obj;
            if (this.miningPos == null || !this.miningPos.equals((Object)newPos)) {
                this.progressChecker.reset();
            }
            this.miningPos = newPos;
            return new DestroyBlockTask(this.miningPos);
        }

        @Override
        protected boolean isValid(PlayerEngineController mod, Object obj) {
            if (obj instanceof class_2338) {
                class_2338 b = (class_2338)obj;
                return mod.getBlockScanner().isBlockAtPosition(b, this.blocks) && WorldHelper.canBreak(this.controller, b);
            }
            if (!(obj instanceof class_1542)) {
                return false;
            }
            class_1542 drop = (class_1542)obj;
            class_1792 item = drop.method_6983().method_7909();
            if (this.targets != null) {
                for (ItemTarget target : this.targets) {
                    if (!target.matches(item)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected void onStart() {
            this.progressChecker.reset();
            this.miningPos = null;
        }

        @Override
        protected void onStop(Task interruptTask) {
        }

        @Override
        protected boolean isEqual(Task other) {
            boolean bl;
            if (!(other instanceof MineOrCollectTask)) {
                bl = false;
            } else {
                MineOrCollectTask task = (MineOrCollectTask)other;
                bl = Arrays.equals(task.blocks, this.blocks) && Arrays.equals(task.targets, this.targets);
            }
            return bl;
        }

        @Override
        protected String toDebugString() {
            return "Mining or Collecting";
        }

        public boolean isMining() {
            return this.miningPos != null;
        }

        public class_2338 miningPos() {
            return this.miningPos;
        }
    }
}

