/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers;

import com.google.common.collect.Streams;
import com.player2.playerengine.trackers.Tracker;
import com.player2.playerengine.trackers.TrackerManager;
import com.player2.playerengine.util.helpers.BaritoneHelper;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;

public class UserBlockRangeTracker
extends Tracker {
    final int AVOID_BREAKING_RANGE = 16;
    final class_2248[] USER_INDICATOR_BLOCKS = (class_2248[])Streams.concat((Stream[])new Stream[]{Arrays.stream(ItemHelper.itemsToBlocks(ItemHelper.BED))}).toArray(class_2248[]::new);
    final class_2248[] USER_BLOCKS_TO_AVOID_BREAKING = (class_2248[])Streams.concat((Stream[])new Stream[]{Arrays.asList(class_2246.field_10445).stream(), Arrays.stream(ItemHelper.itemsToBlocks(ItemHelper.LOG))}).toArray(class_2248[]::new);
    private final Set<class_2338> dontBreakBlocks = new HashSet<class_2338>();

    public UserBlockRangeTracker(TrackerManager manager) {
        super(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNearUserTrackedBlock(class_2338 pos) {
        this.ensureUpdated();
        Object object = BaritoneHelper.MINECRAFT_LOCK;
        synchronized (object) {
            return this.dontBreakBlocks.contains(pos);
        }
    }

    @Override
    protected void updateState() {
        this.dontBreakBlocks.clear();
        List<class_2338> userBlocks = this.mod.getBlockScanner().getKnownLocationsIncludeUnreachable(this.USER_INDICATOR_BLOCKS);
        HashSet<class_2248> userIndicatorBlocks = new HashSet<class_2248>(Arrays.asList(this.USER_INDICATOR_BLOCKS));
        HashSet<class_2248> userBlocksToAvoidMining = new HashSet<class_2248>(Arrays.asList(this.USER_BLOCKS_TO_AVOID_BREAKING));
        userBlocks.removeIf(bpos -> {
            class_2248 bx = this.mod.getWorld().method_8320(bpos).method_26204();
            return !userIndicatorBlocks.contains(bx);
        });
        for (class_2338 userBlockPos : userBlocks) {
            class_2338 min = userBlockPos.method_10069(-16, -16, -16);
            class_2338 max = userBlockPos.method_10069(16, 16, 16);
            for (class_2338 possible : WorldHelper.scanRegion(min, max)) {
                class_2248 b = this.mod.getWorld().method_8320(possible).method_26204();
                if (!userBlocksToAvoidMining.contains(b)) continue;
                this.dontBreakBlocks.add(possible);
            }
        }
    }

    @Override
    protected void reset() {
        this.dontBreakBlocks.clear();
    }
}

