/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.trackers.storage;

import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.trackers.Tracker;
import com.player2.playerengine.trackers.TrackerManager;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.slots.Slot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;

public class InventorySubTracker
extends Tracker {
    private final Map<class_1792, List<Integer>> itemToSlotPlayer = new HashMap<class_1792, List<Integer>>();
    private final Map<class_1792, Integer> itemCountsPlayer = new HashMap<class_1792, Integer>();

    public InventorySubTracker(TrackerManager manager) {
        super(manager);
    }

    public int getItemCount(class_1792 ... items) {
        this.ensureUpdated();
        int result = 0;
        class_1799 cursorStack = this.mod.getSlotHandler().getCursorStack();
        for (class_1792 item : items) {
            if (cursorStack.method_31574(item)) {
                result += cursorStack.method_7947();
            }
            result += this.itemCountsPlayer.getOrDefault(item, 0).intValue();
        }
        return result;
    }

    public boolean hasItem(class_1792 ... items) {
        this.ensureUpdated();
        class_1799 cursorStack = this.mod.getSlotHandler().getCursorStack();
        for (class_1792 item : items) {
            if (cursorStack.method_31574(item)) {
                return true;
            }
            if (!this.itemCountsPlayer.containsKey(item)) continue;
            return true;
        }
        return false;
    }

    public List<Slot> getSlotsWithItemsPlayerInventory(boolean includeArmor, class_1792 ... items) {
        this.ensureUpdated();
        ArrayList<Slot> result = new ArrayList<Slot>();
        LivingEntityInventory inventory = ((IInventoryProvider)this.mod.getEntity()).getLivingInventory();
        for (class_1792 item : items) {
            if (!this.itemToSlotPlayer.containsKey(item)) continue;
            for (Integer index : this.itemToSlotPlayer.get(item)) {
                result.add(new Slot(inventory.main, index));
            }
        }
        if (includeArmor) {
            for (int i = 0; i < inventory.armor.size(); ++i) {
                class_1799 stack = (class_1799)inventory.armor.get(i);
                if (!Arrays.stream(items).anyMatch(arg_0 -> ((class_1799)stack).method_31574(arg_0))) continue;
                result.add(new Slot(inventory.armor, i));
            }
        }
        class_1799 offhandStack = (class_1799)inventory.offHand.get(0);
        if (Arrays.stream(items).anyMatch(arg_0 -> ((class_1799)offhandStack).method_31574(arg_0))) {
            result.add(new Slot(inventory.offHand, 0));
        }
        return result;
    }

    public List<class_1799> getInventoryStacks() {
        this.ensureUpdated();
        LivingEntityInventory inventory = ((IInventoryProvider)this.mod.getEntity()).getLivingInventory();
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        stacks.addAll((Collection<class_1799>)inventory.main);
        stacks.addAll((Collection<class_1799>)inventory.armor);
        stacks.addAll((Collection<class_1799>)inventory.offHand);
        return stacks;
    }

    public List<Slot> getSlotsThatCanFit(class_1799 item, boolean acceptPartial) {
        this.ensureUpdated();
        ArrayList<Slot> result = new ArrayList<Slot>();
        LivingEntityInventory inventory = ((IInventoryProvider)this.mod.getEntity()).getLivingInventory();
        if (item.method_7946()) {
            for (int i = 0; i < inventory.main.size(); ++i) {
                class_1799 stackInSlot = (class_1799)inventory.main.get(i);
                if (!ItemHelper.canStackTogether(item, stackInSlot)) continue;
                int roomLeft = stackInSlot.method_7914() - stackInSlot.method_7947();
                if (!acceptPartial && roomLeft < item.method_7947()) continue;
                result.add(new Slot(inventory.main, i));
            }
        }
        for (int ix = 0; ix < inventory.main.size(); ++ix) {
            if (!((class_1799)inventory.main.get(ix)).method_7960()) continue;
            result.add(new Slot(inventory.main, ix));
        }
        return result;
    }

    public boolean hasEmptySlot() {
        this.ensureUpdated();
        return this.itemCountsPlayer.getOrDefault(class_1802.field_8162, 0) > 0;
    }

    @Override
    protected void updateState() {
        this.reset();
        LivingEntityInventory inventory = ((IInventoryProvider)this.mod.getEntity()).getLivingInventory();
        if (inventory != null) {
            class_1799 stack;
            int i;
            for (i = 0; i < inventory.main.size(); ++i) {
                stack = (class_1799)inventory.main.get(i);
                this.registerItem(stack, i, inventory.main);
            }
            for (i = 0; i < inventory.armor.size(); ++i) {
                stack = (class_1799)inventory.armor.get(i);
                this.registerItem(stack, i, inventory.armor);
            }
            for (i = 0; i < inventory.offHand.size(); ++i) {
                stack = (class_1799)inventory.offHand.get(i);
                this.registerItem(stack, i, inventory.offHand);
            }
        }
    }

    private void registerItem(class_1799 stack, int index, class_2371<class_1799> inventory) {
        class_1792 item = stack.method_7960() ? class_1802.field_8162 : stack.method_7909();
        int count = stack.method_7947();
        this.itemCountsPlayer.put(item, this.itemCountsPlayer.getOrDefault(item, 0) + count);
        if (inventory instanceof class_2371) {
            this.itemToSlotPlayer.computeIfAbsent(item, k -> new ArrayList()).add(index);
        }
    }

    @Override
    protected void reset() {
        this.itemToSlotPlayer.clear();
        this.itemCountsPlayer.clear();
    }
}

