/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util;

import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import java.util.Arrays;
import net.minecraft.class_1792;

public class CraftingRecipe {
    private ItemTarget[] slots;
    private int width;
    private int height;
    private boolean shapeless;
    private String shortName;
    private int outputCount;

    public static CraftingRecipe newShapedRecipe(class_1792[][] items, int outputCount) {
        return CraftingRecipe.newShapedRecipe(null, items, outputCount);
    }

    public static CraftingRecipe newShapedRecipe(ItemTarget[] slots, int outputCount) {
        return CraftingRecipe.newShapedRecipe(null, slots, outputCount);
    }

    public static CraftingRecipe newShapedRecipe(String shortName, class_1792[][] items, int outputCount) {
        return CraftingRecipe.newShapedRecipe(shortName, CraftingRecipe.createSlots(items), outputCount);
    }

    public static CraftingRecipe newShapedRecipe(String shortName, ItemTarget[] slots, int outputCount) {
        if (slots.length != 4 && slots.length != 9) {
            Debug.logError("Invalid shaped crafting recipe, must be either size 4 or 9. Size given: " + slots.length);
            return null;
        }
        CraftingRecipe result = new CraftingRecipe();
        result.shortName = shortName;
        result.slots = (ItemTarget[])Arrays.stream(slots).map(target -> target == null ? ItemTarget.EMPTY : target).toArray(ItemTarget[]::new);
        result.outputCount = outputCount;
        if (slots.length == 4) {
            result.width = 2;
            result.height = 2;
        } else {
            result.width = 3;
            result.height = 3;
        }
        result.shapeless = false;
        return result;
    }

    private static ItemTarget[] createSlots(ItemTarget[] slots) {
        ItemTarget[] result = new ItemTarget[slots.length];
        System.arraycopy(slots, 0, result, 0, slots.length);
        return result;
    }

    private static ItemTarget[] createSlots(class_1792[][] slots) {
        ItemTarget[] result = new ItemTarget[slots.length];
        for (int i = 0; i < slots.length; ++i) {
            result[i] = slots[i] == null ? ItemTarget.EMPTY : new ItemTarget(slots[i]);
        }
        return result;
    }

    public ItemTarget getSlot(int index) {
        ItemTarget result = this.slots[index];
        return result != null ? result : ItemTarget.EMPTY;
    }

    public int getSlotCount() {
        return this.slots.length;
    }

    public ItemTarget[] getSlots() {
        return this.slots;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isShapeless() {
        return this.shapeless;
    }

    public boolean isBig() {
        return this.slots.length > 4;
    }

    public int outputCount() {
        return this.outputCount;
    }

    public boolean equals(Object o) {
        if (o instanceof CraftingRecipe) {
            CraftingRecipe other = (CraftingRecipe)o;
            if (other.shapeless != this.shapeless) {
                return false;
            }
            if (other.outputCount != this.outputCount) {
                return false;
            }
            if (other.height != this.height) {
                return false;
            }
            if (other.width != this.width) {
                return false;
            }
            if (other.slots.length != this.slots.length) {
                return false;
            }
            for (int i = 0; i < this.slots.length; ++i) {
                if (other.slots[i] == null != (this.slots[i] == null)) {
                    return false;
                }
                if (other.slots[i] == null || other.slots[i].equals(this.slots[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        Object name = "CraftingRecipe{";
        name = this.shortName != null ? (String)name + "craft " + (String)name : (String)name + "_slots=" + (String)name + ", width=" + Arrays.toString(this.slots) + ", height=" + this.width + ", shapeless=" + this.height;
        return (String)name + "}";
    }
}

