/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;

public interface StlHelper {
    public static <T> Comparator<T> compareValues(Function<T, Double> getValue) {
        return (left, right) -> (int)Math.signum((Double)getValue.apply(left) - (Double)getValue.apply(right));
    }

    public static <T> String toString(Collection<T> thing, Function<T, String> toStringFunc) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        int i = 0;
        for (T item : thing) {
            result.append(toStringFunc.apply(item));
            if (i != thing.size() - 1) {
                result.append(",");
            }
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public static <T> String toString(T[] thing, Function<T, String> toStringFunc) {
        try {
            return StlHelper.toString(Arrays.asList(thing), toStringFunc);
        }
        catch (NullPointerException var3) {
            return "<null>";
        }
    }
}

