/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.utils.ToolSet;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.Pair;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.slots.Slot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

public class StorageHelper {
    public static class_1799 getItemStackInSlot(Slot slot) {
        return slot != null && !slot.equals(Slot.UNDEFINED) ? slot.getStack() : class_1799.field_8037;
    }

    public static class_1799 getItemStackInCursorSlot(PlayerEngineController controller) {
        return controller.getSlotHandler().getCursorStack();
    }

    public static boolean isArmorEquipped(PlayerEngineController controller, class_1792 ... any) {
        for (class_1792 item : any) {
            class_1799 equippedStack;
            if (item instanceof class_1738) {
                class_1738 armor = (class_1738)item;
                equippedStack = controller.getEntity().method_6118(armor.method_48398().method_48399());
                if (!equippedStack.method_31574(item)) continue;
                return true;
            }
            if (!(item instanceof class_1819) || !(equippedStack = controller.getEntity().method_6118(class_1304.field_6171)).method_31574(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArmorEquippedAll(PlayerEngineController controller, class_1792 ... all) {
        return Arrays.stream(all).allMatch(item -> StorageHelper.isArmorEquipped(controller, item));
    }

    public static boolean isItemInOffhand(PlayerEngineController controller, class_1792 item) {
        return controller.getEntity().method_6118(class_1304.field_6171).method_31574(item);
    }

    public static boolean isEquipped(PlayerEngineController controller, class_1792 ... items) {
        LivingEntityInventory inv = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
        return Arrays.stream(items).anyMatch(item -> inv.getMainHandStack().method_31574(item));
    }

    public static MiningRequirement getCurrentMiningRequirement(PlayerEngineController controller) {
        MiningRequirement[] order;
        for (MiningRequirement check : order = new MiningRequirement[]{MiningRequirement.DIAMOND, MiningRequirement.IRON, MiningRequirement.STONE, MiningRequirement.WOOD}) {
            if (!StorageHelper.miningRequirementMet(controller, check)) continue;
            return check;
        }
        return MiningRequirement.HAND;
    }

    private static boolean h(PlayerEngineController controller, boolean inventoryOnly, class_1792 ... items) {
        return inventoryOnly ? controller.getItemStorage().hasItemInventoryOnly(items) : controller.getItemStorage().hasItem(items);
    }

    private static boolean miningRequirementMetInner(PlayerEngineController controller, boolean inventoryOnly, MiningRequirement requirement) {
        return switch (requirement) {
            case MiningRequirement.HAND -> true;
            case MiningRequirement.WOOD -> {
                if (StorageHelper.h(controller, inventoryOnly, class_1802.field_8647) || StorageHelper.h(controller, inventoryOnly, class_1802.field_8387) || StorageHelper.h(controller, inventoryOnly, class_1802.field_8403) || StorageHelper.h(controller, inventoryOnly, class_1802.field_8335) || StorageHelper.h(controller, inventoryOnly, class_1802.field_8377) || StorageHelper.h(controller, inventoryOnly, class_1802.field_22024)) {
                    yield true;
                }
                yield false;
            }
            case MiningRequirement.STONE -> {
                if (StorageHelper.h(controller, inventoryOnly, class_1802.field_8387) || StorageHelper.h(controller, inventoryOnly, class_1802.field_8403) || StorageHelper.h(controller, inventoryOnly, class_1802.field_8335) || StorageHelper.h(controller, inventoryOnly, class_1802.field_8377) || StorageHelper.h(controller, inventoryOnly, class_1802.field_22024)) {
                    yield true;
                }
                yield false;
            }
            case MiningRequirement.IRON -> {
                if (StorageHelper.h(controller, inventoryOnly, class_1802.field_8403) || StorageHelper.h(controller, inventoryOnly, class_1802.field_8335) || StorageHelper.h(controller, inventoryOnly, class_1802.field_8377) || StorageHelper.h(controller, inventoryOnly, class_1802.field_22024)) {
                    yield true;
                }
                yield false;
            }
            case MiningRequirement.DIAMOND -> {
                if (StorageHelper.h(controller, inventoryOnly, class_1802.field_8377) || StorageHelper.h(controller, inventoryOnly, class_1802.field_22024)) {
                    yield true;
                }
                yield false;
            }
            default -> {
                Debug.logError("You missed a spot");
                yield false;
            }
        };
    }

    public static boolean miningRequirementMet(PlayerEngineController controller, MiningRequirement requirement) {
        return StorageHelper.miningRequirementMetInner(controller, false, requirement);
    }

    public static boolean miningRequirementMetInventory(PlayerEngineController controller, MiningRequirement requirement) {
        return StorageHelper.miningRequirementMetInner(controller, true, requirement);
    }

    public static Optional<Slot> getBestToolSlot(PlayerEngineController controller, class_2680 state) {
        int bestSlot = new ToolSet(controller.getPlayer()).getBestSlot(state.method_26204(), false);
        return Optional.of(new Slot(controller.getInventory().main, bestSlot));
    }

    public static boolean shouldSaveStack(PlayerEngineController controller, class_2248 block, class_1799 stack) {
        return false;
    }

    public static Optional<Slot> getGarbageSlot(PlayerEngineController controller) {
        LivingEntityInventory inventory = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
        int bestScore = Integer.MIN_VALUE;
        Slot bestSlot = null;
        for (int i = 0; i < inventory.main.size(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !ItemHelper.canThrowAwayStack(controller, stack)) continue;
            int score = 0;
            if (controller.getModSettings().isThrowaway(stack.method_7909())) {
                score += 1000;
            }
            if (stack.method_7947() < stack.method_7914()) {
                score += 100;
            }
            if ((score -= stack.method_7947()) <= bestScore) continue;
            bestScore = score;
            bestSlot = new Slot(inventory.main, i);
        }
        return Optional.ofNullable(bestSlot);
    }

    public static int getBuildingMaterialCount(PlayerEngineController controller) {
        return controller.getItemStorage().getItemCount((class_1792[])Arrays.stream(controller.getModSettings().getThrowawayItems(controller, true)).filter(item -> item instanceof class_1747 && !item.equals(class_1802.field_8110) && !item.equals(class_1802.field_8858)).toArray(class_1792[]::new));
    }

    public static boolean itemTargetsMet(PlayerEngineController controller, ItemTarget ... targetsToMeet) {
        return Arrays.stream(targetsToMeet).allMatch(target -> controller.getItemStorage().getItemCount(target.getMatches()) >= target.getTargetCount());
    }

    public static boolean itemTargetsMetInventory(PlayerEngineController controller, ItemTarget ... targetsToMeet) {
        return Arrays.stream(targetsToMeet).allMatch(target -> controller.getItemStorage().getItemCountInventoryOnly(target.getMatches()) >= target.getTargetCount());
    }

    public static boolean hasRecipeMaterialsOrTarget(PlayerEngineController controller, RecipeTarget ... targets) {
        HashMap<class_1792, Pair<ItemTarget, Integer>> required = new HashMap<class_1792, Pair<ItemTarget, Integer>>();
        for (RecipeTarget target : targets) {
            int craftsNeeded = (int)Math.ceil((double)(target.getTargetCount() - controller.getItemStorage().getItemCount(target.getOutputItem())) / (double)target.getRecipe().outputCount());
            if (craftsNeeded <= 0) continue;
            for (ItemTarget ingredient : target.getRecipe().getSlots()) {
                if (ingredient == null || ingredient.isEmpty()) continue;
                class_1792 item = ingredient.getMatches()[0];
                required.put(item, new Pair<ItemTarget, Integer>(ingredient, required.getOrDefault(item, new Pair<ItemTarget, Integer>(ingredient, 0)).getRight() + ingredient.getTargetCount() * craftsNeeded));
            }
        }
        for (class_1792 item : required.keySet()) {
            Pair req = (Pair)required.get(item);
            if (controller.getItemStorage().getItemCount((ItemTarget)req.getLeft()) >= (Integer)req.getRight()) continue;
            return false;
        }
        return true;
    }

    public static int calculateInventoryFoodScore(PlayerEngineController controller) {
        int result = 0;
        for (class_1799 stack : controller.getItemStorage().getItemStacksPlayerInventory(true)) {
            if (!ItemVer.isFood(stack)) continue;
            result += Objects.requireNonNull(ItemVer.getFoodComponent(stack.method_7909())).getHunger() * stack.method_7947();
        }
        return result;
    }

    public static double calculateInventoryFuelCount(PlayerEngineController controller) {
        double result = 0.0;
        for (class_1799 stack : controller.getItemStorage().getItemStacksPlayerInventory(true)) {
            if (!controller.getModSettings().isSupportedFuel(stack.method_7909())) continue;
            result += ItemHelper.getFuelAmount(stack.method_7909()) * (double)stack.method_7947();
        }
        return result;
    }

    public static ItemTarget[] getAllInventoryItemsAsTargets(PlayerEngineController controller, Predicate<Slot> accept) {
        class_1799 stack;
        HashMap<class_1792, Integer> counts = new HashMap<class_1792, Integer>();
        LivingEntityInventory inv = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
        for (int i = 0; i < inv.main.size(); ++i) {
            class_1799 stack2;
            Slot slot = new Slot(inv.main, i);
            if (!accept.test(slot) || (stack2 = StorageHelper.getItemStackInSlot(slot)).method_7960()) continue;
            counts.put(stack2.method_7909(), counts.getOrDefault(stack2.method_7909(), 0) + stack2.method_7947());
        }
        Slot offhandSlot = new Slot(inv.offHand, 0);
        if (accept.test(offhandSlot) && !(stack = StorageHelper.getItemStackInSlot(offhandSlot)).method_7960()) {
            counts.put(stack.method_7909(), counts.getOrDefault(stack.method_7909(), 0) + stack.method_7947());
        }
        for (int ix = 0; ix < inv.armor.size(); ++ix) {
            class_1799 stack3;
            Slot slot = new Slot(inv.armor, ix);
            if (!accept.test(slot) || (stack3 = StorageHelper.getItemStackInSlot(slot)).method_7960()) continue;
            counts.put(stack3.method_7909(), counts.getOrDefault(stack3.method_7909(), 0) + stack3.method_7947());
        }
        ItemTarget[] results = new ItemTarget[counts.size()];
        int ixx = 0;
        for (class_1792 item : counts.keySet()) {
            results[ixx++] = new ItemTarget(item, (int)((Integer)counts.get(item)));
        }
        return results;
    }

    public static int getNumberOfThrowawayBlocks(PlayerEngineController mod) {
        int totalBlockThrowaways = 0;
        if (!mod.getItemStorage().getSlotsWithItemPlayerInventory(false, mod.getModSettings().getThrowawayItems(mod)).isEmpty()) {
            for (Slot slot : mod.getItemStorage().getSlotsWithItemPlayerInventory(false, mod.getModSettings().getThrowawayItems(mod))) {
                class_1799 stack = StorageHelper.getItemStackInSlot(slot);
                if (!ItemHelper.canThrowAwayStack(mod, stack) || !(stack.method_7909() instanceof class_1747)) continue;
                totalBlockThrowaways += stack.method_7947();
            }
        }
        return totalBlockThrowaways;
    }

    public static Optional<Slot> getSlotWithThrowawayBlock(PlayerEngineController mod, boolean limitToHotbar) {
        Iterator var7;
        ArrayList<Slot> throwawayBlockItems = new ArrayList<Slot>();
        int totalBlockThrowaways = 0;
        if (!mod.getItemStorage().getSlotsWithItemPlayerInventory(false, mod.getModSettings().getThrowawayItems(mod)).isEmpty()) {
            for (Slot slot : mod.getItemStorage().getSlotsWithItemPlayerInventory(false, mod.getModSettings().getThrowawayItems(mod))) {
                class_1799 stack;
                if (Slot.isCursor(slot) || limitToHotbar && (slot.getInventorySlot() > 8 || slot.getInventorySlot() < 0) || !ItemHelper.canThrowAwayStack(mod, stack = StorageHelper.getItemStackInSlot(slot)) || !(stack.method_7909() instanceof class_1747)) continue;
                totalBlockThrowaways += stack.method_7947();
                throwawayBlockItems.add(slot);
            }
        }
        if (!throwawayBlockItems.isEmpty() && (var7 = throwawayBlockItems.iterator()).hasNext()) {
            Slot throwawayBlockItem = (Slot)var7.next();
            return Optional.ofNullable(throwawayBlockItem);
        }
        return Optional.empty();
    }
}

