/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.progresscheck;

import com.player2.playerengine.util.progresscheck.IProgressChecker;
import com.player2.playerengine.util.progresscheck.LinearProgressChecker;
import net.minecraft.class_243;

public class DistanceProgressChecker
implements IProgressChecker<class_243> {
    private final IProgressChecker<Double> distanceChecker;
    private final boolean reduceDistance;
    private class_243 start;
    private class_243 prevPos;

    public DistanceProgressChecker(IProgressChecker<Double> distanceChecker, boolean reduceDistance) {
        this.distanceChecker = distanceChecker;
        this.reduceDistance = reduceDistance;
        if (reduceDistance) {
            this.distanceChecker.setProgress(Double.NEGATIVE_INFINITY);
        }
        this.reset();
    }

    public DistanceProgressChecker(double timeout, double minDistanceToMake, boolean reduceDistance) {
        this(new LinearProgressChecker(timeout, minDistanceToMake), reduceDistance);
    }

    public DistanceProgressChecker(double timeout, double minDistanceToMake) {
        this(timeout, minDistanceToMake, false);
    }

    @Override
    public void setProgress(class_243 position) {
        if (this.start == null) {
            this.start = position;
        } else {
            double delta = position.method_1022(this.start);
            if (this.reduceDistance) {
                delta *= -1.0;
            }
            this.prevPos = position;
            this.distanceChecker.setProgress(delta);
        }
    }

    @Override
    public boolean failed() {
        return this.distanceChecker.failed();
    }

    @Override
    public void reset() {
        this.start = null;
        this.distanceChecker.setProgress(0.0);
        this.distanceChecker.reset();
    }
}

