/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.google.common.collect.Streams;
import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.control.KillAura;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.util.BlockRange;
import com.player2.playerengine.util.helpers.ConfigHelper;
import com.player2.playerengine.util.helpers.ItemHelper;
import com.player2.playerengine.util.serialization.IFailableConfigFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class PlayerEngineSettings
implements IFailableConfigFile {
    private transient boolean failedToLoad = false;
    private boolean showDebugTickMs = false;
    private boolean showTaskChains = true;
    private boolean hideAllWarningLogs = false;
    private String commandPrefix = "@";
    private String logLevel = "NORMAL";
    private String chatLogPrefix = "[Alto Clef] ";
    private boolean showTimer = true;
    private float containerItemMoveDelay = 0.2f;
    private boolean useCraftingBookToCraft = true;
    private float resourcePickupDropRange = 16.0f;
    private int minimumFoodAllowed = 0;
    private int foodUnitsToCollect = 0;
    private float resourceChestLocateRange = 500.0f;
    private float resourceMineRange = 100.0f;
    private boolean avoidSearchingDungeonChests = true;
    private boolean avoidOceanBlocks = false;
    private float entityReachRange = 4.0f;
    private boolean collectPickaxeFirst = true;
    private boolean replantCrops = true;
    private boolean mobDefense = true;
    private KillAura.Strategy forceFieldStrategy = KillAura.Strategy.SMART;
    private boolean dodgeProjectiles = true;
    private boolean killOrAvoidAnnoyingHostiles = true;
    private boolean avoidDrowning = true;
    private boolean autoCloseScreenWhenLookingOrMining = true;
    private boolean extinguishSelfWithWater = true;
    private boolean autoEat = true;
    private boolean autoMLGBucket = true;
    private boolean autoReconnect = true;
    private boolean autoRespawn = true;
    private DefaultGoToDimensionTask.OVERWORLD_TO_NETHER_BEHAVIOUR overworldToNetherBehaviour = DefaultGoToDimensionTask.OVERWORLD_TO_NETHER_BEHAVIOUR.BUILD_PORTAL_VANILLA;
    private int netherFastTravelWalkingRange = 600;
    private String idleCommand = "idle";
    private String deathCommand = "";
    private List<Item> throwawayItems = Arrays.asList(Items.f_151054_, Items.f_151064_, Items.f_41832_, Items.f_41830_, Items.f_42064_, Items.f_42170_, Items.f_41958_, Items.f_151048_, Items.f_42594_, Items.f_42329_, Items.f_151035_, Items.f_41900_, Items.f_41898_, Items.f_41901_, Items.f_41896_, Items.f_41899_, Items.f_41897_, Items.f_42048_, Items.f_42258_, Items.f_42050_, Items.f_42049_, Items.f_42095_, Items.f_42691_, Items.f_42051_, Items.f_42755_, Items.f_42102_, Items.f_41856_, Items.f_42018_);
    private int reservedBuildingBlockCount = 64;
    private boolean dontThrowAwayCustomNameItems = true;
    private boolean dontThrowAwayEnchantedItems = true;
    private boolean throwAwayUnusedItems = true;
    private List<Item> importantItems = Streams.concat((Stream[])new Stream[]{Stream.of(Items.f_42747_, Items.f_42437_, Items.f_42545_, Items.f_42713_, Items.f_42415_, Items.f_41959_, Items.f_42419_, Items.f_42418_, Items.f_42791_), Stream.of(ItemHelper.DIAMOND_ARMORS), Stream.of(ItemHelper.NETHERITE_ARMORS), Stream.of(ItemHelper.DIAMOND_TOOLS), Stream.of(ItemHelper.NETHERITE_TOOLS), Stream.of(ItemHelper.SHULKER_BOXES)}).toList();
    private boolean limitFuelsToSupportedFuels = true;
    private List<Item> supportedFuels = Streams.concat((Stream[])new Stream[]{Stream.of(Items.f_42413_, Items.f_42414_)}).toList();
    private BlockPos homeBasePosition = new BlockPos(0, 64, 0);
    private List<BlockRange> areasToProtect = Collections.emptyList();

    public static void load(Consumer<PlayerEngineSettings> onReload) {
        ConfigHelper.loadConfig("playerengine_settings.json", PlayerEngineSettings::new, PlayerEngineSettings.class, onReload);
    }

    public boolean shouldShowTaskChain() {
        return this.showTaskChains;
    }

    public boolean shouldShowDebugTickMs() {
        return this.showDebugTickMs;
    }

    public boolean shouldHideAllWarningLogs() {
        return this.hideAllWarningLogs;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getCommandPrefix() {
        return this.commandPrefix;
    }

    public String getChatLogPrefix() {
        return this.chatLogPrefix;
    }

    public boolean shouldShowTimer() {
        return this.showTimer;
    }

    public float getResourcePickupRange() {
        return this.resourcePickupDropRange;
    }

    public float getResourceChestLocateRange() {
        return this.resourceChestLocateRange;
    }

    public float getResourceMineRange() {
        return this.resourceMineRange;
    }

    public float getContainerItemMoveDelay() {
        return this.containerItemMoveDelay;
    }

    public boolean shouldUseCraftingBookToCraft() {
        return this.useCraftingBookToCraft;
    }

    public int getFoodUnitsToCollect() {
        return this.foodUnitsToCollect;
    }

    public int getMinimumFoodAllowed() {
        return this.minimumFoodAllowed;
    }

    public boolean isMobDefense() {
        return this.mobDefense;
    }

    public boolean isDodgeProjectiles() {
        return this.dodgeProjectiles;
    }

    public boolean isAutoEat() {
        return this.autoEat;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public boolean isAutoRespawn() {
        return this.autoRespawn;
    }

    public boolean shouldReplantCrops() {
        return this.replantCrops;
    }

    public boolean shouldDealWithAnnoyingHostiles() {
        return this.killOrAvoidAnnoyingHostiles;
    }

    public KillAura.Strategy getForceFieldStrategy() {
        return this.forceFieldStrategy;
    }

    public String getIdleCommand() {
        return this.idleCommand == "" ? "idle" : this.idleCommand;
    }

    public String getDeathCommand() {
        return this.deathCommand;
    }

    public boolean shouldRunIdleCommandWhenNotActive() {
        String command = this.getIdleCommand();
        return command != null && !command.isBlank();
    }

    public boolean shouldAutoMLGBucket() {
        return this.autoMLGBucket;
    }

    public boolean shouldCollectPickaxeFirst() {
        return this.collectPickaxeFirst;
    }

    public boolean shouldAvoidDrowning() {
        return this.avoidDrowning;
    }

    public boolean shouldCloseScreenWhenLookingOrMining() {
        return this.autoCloseScreenWhenLookingOrMining;
    }

    public boolean shouldExtinguishSelfWithWater() {
        return this.extinguishSelfWithWater;
    }

    public boolean shouldAvoidSearchingForDungeonChests() {
        return this.avoidSearchingDungeonChests;
    }

    public boolean shouldAvoidOcean() {
        return this.avoidOceanBlocks;
    }

    public boolean isThrowaway(Item item) {
        return this.throwawayItems.contains(item);
    }

    public boolean isImportant(Item item) {
        return this.importantItems.contains(item);
    }

    public boolean shouldThrowawayUnusedItems() {
        return this.throwAwayUnusedItems;
    }

    public int getReservedBuildingBlockCount() {
        return this.reservedBuildingBlockCount;
    }

    public boolean getDontThrowAwayCustomNameItems() {
        return this.dontThrowAwayCustomNameItems;
    }

    public boolean getDontThrowAwayEnchantedItems() {
        return this.dontThrowAwayEnchantedItems;
    }

    public float getEntityReachRange() {
        return this.entityReachRange;
    }

    public Item[] getThrowawayItems(PlayerEngineController mod, boolean includeProtected) {
        return (Item[])this.throwawayItems.stream().filter(item -> includeProtected || !mod.getBehaviour().isProtected((Item)item)).toArray(Item[]::new);
    }

    public Item[] getThrowawayItems(PlayerEngineController mod) {
        return this.getThrowawayItems(mod, false);
    }

    public boolean shouldLimitFuelsToSupportedFuels() {
        return this.limitFuelsToSupportedFuels;
    }

    public boolean isSupportedFuel(Item item) {
        return !this.limitFuelsToSupportedFuels || this.supportedFuels.contains(item);
    }

    public Item[] getSupportedFuelItems() {
        return (Item[])this.supportedFuels.toArray(Item[]::new);
    }

    public DefaultGoToDimensionTask.OVERWORLD_TO_NETHER_BEHAVIOUR getOverworldToNetherBehaviour() {
        return this.overworldToNetherBehaviour;
    }

    public int getNetherFastTravelWalkingRange() {
        return this.netherFastTravelWalkingRange;
    }

    public BlockPos getHomeBasePosition() {
        return this.homeBasePosition;
    }

    @Override
    public void onFailLoad() {
        this.failedToLoad = true;
    }

    @Override
    public boolean failedToLoad() {
        return this.failedToLoad;
    }
}

