/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine;

import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.container.CraftInTableTask;
import com.player2.playerengine.tasks.container.SmeltInFurnaceTask;
import com.player2.playerengine.tasks.container.UpgradeInSmithingTableTask;
import com.player2.playerengine.tasks.resources.CarveThenCollectTask;
import com.player2.playerengine.tasks.resources.CollectAmethystBlockTask;
import com.player2.playerengine.tasks.resources.CollectBedTask;
import com.player2.playerengine.tasks.resources.CollectBlazeRodsTask;
import com.player2.playerengine.tasks.resources.CollectBlockByOneTask;
import com.player2.playerengine.tasks.resources.CollectBucketLiquidTask;
import com.player2.playerengine.tasks.resources.CollectCoarseDirtTask;
import com.player2.playerengine.tasks.resources.CollectCocoaBeansTask;
import com.player2.playerengine.tasks.resources.CollectCropTask;
import com.player2.playerengine.tasks.resources.CollectDripstoneBlockTask;
import com.player2.playerengine.tasks.resources.CollectEggsTask;
import com.player2.playerengine.tasks.resources.CollectFlintTask;
import com.player2.playerengine.tasks.resources.CollectFlowerTask;
import com.player2.playerengine.tasks.resources.CollectGoldIngotTask;
import com.player2.playerengine.tasks.resources.CollectGoldNuggetsTask;
import com.player2.playerengine.tasks.resources.CollectHayBlockTask;
import com.player2.playerengine.tasks.resources.CollectHoneycombTask;
import com.player2.playerengine.tasks.resources.CollectIronIngotTask;
import com.player2.playerengine.tasks.resources.CollectMagmaCreamTask;
import com.player2.playerengine.tasks.resources.CollectMilkTask;
import com.player2.playerengine.tasks.resources.CollectNetherBricksTask;
import com.player2.playerengine.tasks.resources.CollectObsidianTask;
import com.player2.playerengine.tasks.resources.CollectPlanksTask;
import com.player2.playerengine.tasks.resources.CollectRedSandstoneTask;
import com.player2.playerengine.tasks.resources.CollectSandstoneTask;
import com.player2.playerengine.tasks.resources.CollectSaplingsTask;
import com.player2.playerengine.tasks.resources.CollectSticksTask;
import com.player2.playerengine.tasks.resources.CollectStrippedLogTask;
import com.player2.playerengine.tasks.resources.CollectWheatSeedsTask;
import com.player2.playerengine.tasks.resources.CollectWheatTask;
import com.player2.playerengine.tasks.resources.CollectWoolTask;
import com.player2.playerengine.tasks.resources.GetSmithingTemplateTask;
import com.player2.playerengine.tasks.resources.KillAndLootTask;
import com.player2.playerengine.tasks.resources.KillEndermanTask;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.tasks.resources.ShearAndCollectBlockTask;
import com.player2.playerengine.tasks.resources.wood.CollectBoatTask;
import com.player2.playerengine.tasks.resources.wood.CollectFenceGateTask;
import com.player2.playerengine.tasks.resources.wood.CollectFenceTask;
import com.player2.playerengine.tasks.resources.wood.CollectHangingSignTask;
import com.player2.playerengine.tasks.resources.wood.CollectSignTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenButtonTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenDoorTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenPressurePlateTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenSlabTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenStairsTask;
import com.player2.playerengine.tasks.resources.wood.CollectWoodenTrapDoorTask;
import com.player2.playerengine.tasks.squashed.CataloguedResourceTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import com.player2.playerengine.util.SmeltTarget;
import com.player2.playerengine.util.WoodType;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;

public class TaskCatalogue {
    private static final HashMap<String, Item[]> nameToItemMatches = new HashMap();
    private static final HashMap<String, CataloguedResource> nameToResourceTask = new HashMap();
    private static final HashMap<Item, CataloguedResource> itemToResourceTask = new HashMap();
    private static final HashSet<Item> resourcesObtainable = new HashSet();

    private static CataloguedResource put(String name, Item[] matches, Function<Integer, ResourceTask> getTask) {
        ArrayList<Item> supportedMatches = new ArrayList<Item>();
        for (Item item : matches) {
            supportedMatches.add(item);
        }
        matches = supportedMatches.toArray(new Item[0]);
        CataloguedResource result = new CataloguedResource(matches, getTask);
        Block[] blocks = ItemHelper.itemsToBlocks(matches);
        if (blocks.length != 0) {
            result.mineIfPresent();
        }
        result.forceDimension(Dimension.OVERWORLD);
        if (nameToResourceTask.containsKey(name)) {
            return result;
        }
        nameToResourceTask.put(name, result);
        nameToItemMatches.put(name, matches);
        resourcesObtainable.addAll(Arrays.asList(matches));
        if (matches.length == 1) {
            if (itemToResourceTask.containsKey(matches[0])) {
                throw new IllegalStateException("Tried cataloguing " + matches[0].m_5524_() + " twice!");
            }
            itemToResourceTask.put(matches[0], result);
        }
        return result;
    }

    public static Item[] getItemMatches(String name) {
        return !nameToItemMatches.containsKey(name) ? new Item[]{} : nameToItemMatches.get(name);
    }

    public static boolean isObtainable(Item item) {
        return resourcesObtainable.contains(item);
    }

    public static ItemTarget getItemTarget(String name, int count) {
        return new ItemTarget(name, count);
    }

    public static CataloguedResourceTask getSquashedItemTask(ItemTarget ... targets) {
        return new CataloguedResourceTask(true, targets);
    }

    public static ResourceTask getItemTask(String name, int count) {
        if (!TaskCatalogue.taskExists(name)) {
            Debug.logWarning("Task " + name + " does not exist. Error possibly.");
            Debug.logStack();
            return null;
        }
        return nameToResourceTask.get(name).getResource(count);
    }

    public static ResourceTask getItemTask(Item item, int count) {
        if (!TaskCatalogue.taskExists(item)) {
            Debug.logWarning("Task " + String.valueOf(item) + " does not exist. Error possibly.");
            Debug.logStack();
            return null;
        }
        return itemToResourceTask.get(item).getResource(count);
    }

    public static ResourceTask getItemTask(ItemTarget target) {
        if (target.isCatalogueItem()) {
            return TaskCatalogue.getItemTask(target.getCatalogueName(), target.getTargetCount());
        }
        return target.getMatches().length == 1 ? TaskCatalogue.getItemTask(target.getMatches()[0], target.getTargetCount()) : TaskCatalogue.getSquashedItemTask(target);
    }

    public static boolean taskExists(String name) {
        return nameToResourceTask.containsKey(name);
    }

    public static boolean taskExists(Item item) {
        return itemToResourceTask.containsKey(item);
    }

    public static Collection<String> resourceNames() {
        return nameToResourceTask.keySet();
    }

    private static CataloguedResource simple(String name, Item[] matches, Function<Integer, ResourceTask> getTask) {
        return TaskCatalogue.put(name, matches, getTask);
    }

    private static CataloguedResource simple(String name, Item matches, Function<Integer, ResourceTask> getTask) {
        return TaskCatalogue.simple(name, new Item[]{matches}, getTask);
    }

    private static CataloguedResource mine(String name, MiningRequirement requirement, Item[] toMine, Item ... targets) {
        Block[] toMineBlocks = new Block[toMine.length];
        for (int i = 0; i < toMine.length; ++i) {
            toMineBlocks[i] = Block.m_49814_((Item)toMine[i]);
        }
        return TaskCatalogue.mine(name, requirement, toMineBlocks, targets);
    }

    private static CataloguedResource mine(String name, MiningRequirement requirement, Block[] toMine, Item ... targets) {
        return TaskCatalogue.put(name, targets, count -> new MineAndCollectTask(new ItemTarget(targets, (int)count), toMine, requirement)).dontMineIfPresent();
    }

    private static CataloguedResource mine(String name, MiningRequirement requirement, Block toMine, Item target) {
        return TaskCatalogue.mine(name, requirement, new Block[]{toMine}, target);
    }

    private static CataloguedResource mine(String name, Block toMine, Item target) {
        return TaskCatalogue.mine(name, MiningRequirement.HAND, toMine, target);
    }

    private static CataloguedResource mine(String name, Item target) {
        return TaskCatalogue.mine(name, Block.m_49814_((Item)target), target);
    }

    private static CataloguedResource shear(String name, Block[] toShear, Item ... targets) {
        return TaskCatalogue.put(name, targets, count -> new ShearAndCollectBlockTask(new ItemTarget[]{new ItemTarget(targets, (int)count)}, toShear)).dontMineIfPresent();
    }

    private static CataloguedResource shear(String name, Block toShear, Item ... targets) {
        return TaskCatalogue.shear(name, new Block[]{toShear}, targets);
    }

    private static CataloguedResource shapedRecipe2x2(String name, Item match, int outputCount, String s0, String s1, String s2, String s3) {
        CraftingRecipe recipe = CraftingRecipe.newShapedRecipe(name, new ItemTarget[]{TaskCatalogue.t(s0), TaskCatalogue.t(s1), TaskCatalogue.t(s2), TaskCatalogue.t(s3)}, outputCount);
        return TaskCatalogue.put(name, new Item[]{match}, count -> new CraftInInventoryTask(new RecipeTarget(match, (int)count, recipe)));
    }

    private static CataloguedResource shapedRecipe3x3(String name, Item match, int outputCount, String s0, String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8) {
        CraftingRecipe recipe = CraftingRecipe.newShapedRecipe(name, new ItemTarget[]{TaskCatalogue.t(s0), TaskCatalogue.t(s1), TaskCatalogue.t(s2), TaskCatalogue.t(s3), TaskCatalogue.t(s4), TaskCatalogue.t(s5), TaskCatalogue.t(s6), TaskCatalogue.t(s7), TaskCatalogue.t(s8)}, outputCount);
        return TaskCatalogue.put(name, new Item[]{match}, count -> new CraftInTableTask(new RecipeTarget(match, (int)count, recipe)));
    }

    private static CataloguedResource shapedRecipe2x2Block(String name, Item match, String material) {
        return TaskCatalogue.shapedRecipe2x2(name, match, 1, material, material, material, material);
    }

    private static CataloguedResource shapedRecipe2x2Block(String name, Item match, int outputCount, String material) {
        return TaskCatalogue.shapedRecipe2x2(name, match, outputCount, material, material, material, material);
    }

    private static CataloguedResource shapedRecipe3x3Block(String name, Item match, String material) {
        return TaskCatalogue.shapedRecipe3x3(name, match, 1, material, material, material, material, material, material, material, material, material);
    }

    private static CataloguedResource shapedRecipeSlab(String name, Item match, String material) {
        return TaskCatalogue.shapedRecipe3x3(name, match, 6, null, null, null, null, null, null, material, material, material);
    }

    private static CataloguedResource shapedRecipeStairs(String name, Item match, String material) {
        return TaskCatalogue.shapedRecipe3x3(name, match, 4, material, null, null, material, material, null, material, material, material);
    }

    private static CataloguedResource shapedRecipeWall(String name, Item match, String material) {
        return TaskCatalogue.shapedRecipe3x3(name, match, 6, material, material, material, material, material, material, null, null, null);
    }

    private static CataloguedResource smelt(String name, Item[] matches, String materials, Item ... optionalMaterials) {
        return TaskCatalogue.put(name, matches, count -> new SmeltInFurnaceTask(new SmeltTarget(new ItemTarget(matches, (int)count), new ItemTarget(materials, (int)count), optionalMaterials)));
    }

    private static CataloguedResource smelt(String name, Item match, String materials, Item ... optionalMaterials) {
        return TaskCatalogue.smelt(name, new Item[]{match}, materials, optionalMaterials);
    }

    private static CataloguedResource smith(String name, Item[] matches, String materials, String tool) {
        return TaskCatalogue.put(name, matches, count -> new UpgradeInSmithingTableTask(new ItemTarget(tool, (int)count), new ItemTarget(materials, (int)count), new ItemTarget(matches, (int)count)));
    }

    private static CataloguedResource smith(String name, Item match, String materials, String tool) {
        return TaskCatalogue.smith(name, new Item[]{match}, materials, tool);
    }

    private static CataloguedResource mob(String name, Item[] matches, Class mobClass) {
        return TaskCatalogue.put(name, matches, count -> new KillAndLootTask(mobClass, new ItemTarget(matches, (int)count)));
    }

    private static CataloguedResource mob(String name, Item match, Class mobClass) {
        return TaskCatalogue.mob(name, new Item[]{match}, mobClass);
    }

    private static void mobCook(String uncookedName, String cookedName, Item uncooked, Item cooked, Class mobClass) {
        TaskCatalogue.mob(uncookedName, uncooked, mobClass);
        TaskCatalogue.smelt(cookedName, cooked, uncookedName, new Item[0]);
    }

    private static void mobCook(String uncookedName, Item uncooked, Item cooked, Class mobClass) {
        TaskCatalogue.mobCook(uncookedName, "cooked_" + uncookedName, uncooked, cooked, mobClass);
    }

    private static CataloguedResource crop(String name, Item[] matches, Block[] cropBlocks, Item[] cropSeeds) {
        return TaskCatalogue.put(name, matches, count -> new CollectCropTask(new ItemTarget(matches, (int)count), cropBlocks, cropSeeds));
    }

    public static CataloguedResource crop(String name, Item match, Block cropBlock, Item cropSeed) {
        return TaskCatalogue.crop(name, new Item[]{match}, new Block[]{cropBlock}, new Item[]{cropSeed});
    }

    private static void colorfulTasks(String baseName, Function<ItemHelper.ColorfulItems, Item> getMatch, BiFunction<ItemHelper.ColorfulItems, Integer, ResourceTask> getTask) {
        for (DyeColor dCol : DyeColor.values()) {
            MapColor mCol = dCol.m_284406_();
            ItemHelper.ColorfulItems color = ItemHelper.getColorfulItems(mCol);
            String prefix = color.colorName;
            TaskCatalogue.put(prefix + "_" + prefix, new Item[]{getMatch.apply(color)}, count -> (ResourceTask)getTask.apply(color, (Integer)count));
        }
    }

    private static CataloguedResource[] woodTasks(Function<ItemHelper.WoodItems, String> getCatalogueName, Function<ItemHelper.WoodItems, Item> getMatch, BiFunction<ItemHelper.WoodItems, Integer, ResourceTask> getTask, boolean requireNetherForNetherStuff) {
        ArrayList<CataloguedResource> result = new ArrayList<CataloguedResource>();
        for (WoodType woodType : WoodType.values()) {
            ItemHelper.WoodItems woodItems = ItemHelper.getWoodItems(woodType);
            Item match = getMatch.apply(woodItems);
            String cataloguedName = getCatalogueName.apply(woodItems);
            if (match == null) continue;
            boolean isNether = woodItems.isNetherWood();
            CataloguedResource t = TaskCatalogue.put(cataloguedName, new Item[]{match}, count -> (ResourceTask)getTask.apply(woodItems, (Integer)count));
            if (requireNetherForNetherStuff && isNether) {
                t.forceDimension(Dimension.NETHER);
            }
            result.add(t);
        }
        return (CataloguedResource[])result.toArray(CataloguedResource[]::new);
    }

    private static CataloguedResource[] woodTasks(String baseName, Function<ItemHelper.WoodItems, Item> getMatch, BiFunction<ItemHelper.WoodItems, Integer, ResourceTask> getTask, boolean requireNetherForNetherStuff) {
        return TaskCatalogue.woodTasks((ItemHelper.WoodItems woodItem) -> woodItem.prefix + "_" + woodItem.prefix, getMatch, getTask, requireNetherForNetherStuff);
    }

    private static CataloguedResource[] woodTasks(String baseName, Function<ItemHelper.WoodItems, Item> getMatch, BiFunction<ItemHelper.WoodItems, Integer, ResourceTask> getTask) {
        return TaskCatalogue.woodTasks(baseName, getMatch, getTask, false);
    }

    private static void tools(String toolMaterialName, String material, Item pickaxeItem, Item shovelItem, Item swordItem, Item axeItem, Item hoeItem) {
        String s = "stick";
        String o = null;
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_pickaxe", pickaxeItem, 1, material, material, material, o, s, o, o, s, o);
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_shovel", shovelItem, 1, o, material, o, o, s, o, o, s, o);
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_sword", swordItem, 1, o, material, o, o, material, o, o, s, o);
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_axe", axeItem, 1, material, material, o, material, s, o, o, s, o);
        TaskCatalogue.shapedRecipe3x3(toolMaterialName + "_hoe", hoeItem, 1, material, material, o, o, s, o, o, s, o);
    }

    private static void armor(String armorMaterialName, String material, Item helmetItem, Item chestplateItem, Item leggingsItem, Item bootsItem) {
        String o = null;
        TaskCatalogue.shapedRecipe3x3(armorMaterialName + "_helmet", helmetItem, 1, material, material, material, material, o, material, o, o, o);
        TaskCatalogue.shapedRecipe3x3(armorMaterialName + "_chestplate", chestplateItem, 1, material, o, material, material, material, material, material, material, material);
        TaskCatalogue.shapedRecipe3x3(armorMaterialName + "_leggings", leggingsItem, 1, material, material, material, material, o, material, material, o, material);
        TaskCatalogue.shapedRecipe3x3(armorMaterialName + "_boots", bootsItem, 1, o, o, o, material, o, material, material, o, material);
    }

    private static void alias(String newName, String original) {
        if (nameToResourceTask.containsKey(original) && nameToItemMatches.containsKey(original)) {
            nameToResourceTask.put(newName, nameToResourceTask.get(original));
            nameToItemMatches.put(newName, nameToItemMatches.get(original));
        } else {
            Debug.logWarning("Invalid resource: " + original + ". Will not create alias.");
        }
    }

    private static ItemTarget t(String cataloguedName) {
        return new ItemTarget(cataloguedName);
    }

    static {
        String p = "planks";
        String s = "stick";
        String o = null;
        TaskCatalogue.mine("log", MiningRequirement.HAND, ItemHelper.LOG, ItemHelper.LOG).anyDimension();
        TaskCatalogue.woodTasks("log", (ItemHelper.WoodItems wood) -> wood.log, (ItemHelper.WoodItems wood, Integer count) -> new MineAndCollectTask(wood.log, (int)count, new Block[]{Block.m_49814_((Item)wood.log)}, MiningRequirement.HAND), true);
        TaskCatalogue.mine("dirt", MiningRequirement.HAND, new Block[]{Blocks.f_50493_, Blocks.f_50440_, Blocks.f_152481_}, Items.f_42329_);
        TaskCatalogue.simple("cobblestone", Items.f_42594_, CollectBlockByOneTask.CollectCobblestoneTask::new).dontMineIfPresent();
        TaskCatalogue.simple("cobbled_deepslate", Items.f_151035_, CollectBlockByOneTask.CollectCobbledDeepslateTask::new).dontMineIfPresent();
        TaskCatalogue.mine("andesite", MiningRequirement.WOOD, Blocks.f_50334_, Items.f_42170_);
        TaskCatalogue.mine("granite", MiningRequirement.WOOD, Blocks.f_50122_, Items.f_41958_);
        TaskCatalogue.mine("diorite", MiningRequirement.WOOD, Blocks.f_50228_, Items.f_42064_);
        TaskCatalogue.mine("calcite", MiningRequirement.WOOD, Blocks.f_152497_, Items.f_151047_);
        TaskCatalogue.mine("tuff", MiningRequirement.WOOD, Blocks.f_152496_, Items.f_151048_);
        TaskCatalogue.mine("netherrack", MiningRequirement.WOOD, Blocks.f_50134_, Items.f_42048_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("magma_block", MiningRequirement.WOOD, Blocks.f_50450_, Items.f_42258_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("blackstone", MiningRequirement.WOOD, Blocks.f_50730_, Items.f_42755_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("basalt", MiningRequirement.WOOD, Blocks.f_50137_, Items.f_42051_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("soul_sand", Items.f_42049_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("soul_soil", Items.f_42050_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("glowstone_dust", Blocks.f_50141_, Items.f_42525_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("coal", MiningRequirement.WOOD, new Block[]{Blocks.f_49997_, Blocks.f_152469_}, Items.f_42413_);
        TaskCatalogue.mine("raw_iron", MiningRequirement.STONE, new Block[]{Blocks.f_49996_, Blocks.f_152468_}, Items.f_151050_);
        TaskCatalogue.mine("raw_gold", MiningRequirement.IRON, new Block[]{Blocks.f_49995_, Blocks.f_152467_}, Items.f_151053_);
        TaskCatalogue.mine("raw_copper", MiningRequirement.STONE, new Block[]{Blocks.f_152505_, Blocks.f_152506_}, Items.f_151051_);
        TaskCatalogue.mine("diamond", MiningRequirement.IRON, new Block[]{Blocks.f_50089_, Blocks.f_152474_}, Items.f_42415_);
        TaskCatalogue.mine("emerald", MiningRequirement.IRON, new Block[]{Blocks.f_50264_, Blocks.f_152479_}, Items.f_42616_);
        TaskCatalogue.mine("redstone", MiningRequirement.IRON, new Block[]{Blocks.f_50173_, Blocks.f_152473_}, Items.f_42451_);
        TaskCatalogue.mine("lapis_lazuli", MiningRequirement.STONE, new Block[]{Blocks.f_50059_, Blocks.f_152472_}, Items.f_42534_);
        TaskCatalogue.alias("lapis", "lapis_lazuli");
        TaskCatalogue.mine("amethyst_shard", MiningRequirement.WOOD, Blocks.f_152492_, Items.f_151049_);
        TaskCatalogue.mine("pointed_dripstone", MiningRequirement.WOOD, Blocks.f_152588_, Items.f_151087_);
        TaskCatalogue.mine("sand", Blocks.f_49992_, Items.f_41830_);
        TaskCatalogue.mine("red_sand", Blocks.f_49993_, Items.f_41831_);
        TaskCatalogue.mine("gravel", Blocks.f_49994_, Items.f_41832_);
        TaskCatalogue.mine("clay_ball", Blocks.f_50129_, Items.f_42461_);
        TaskCatalogue.mine("ancient_debris", MiningRequirement.DIAMOND, Blocks.f_50722_, Items.f_42792_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("gilded_blackstone", MiningRequirement.STONE, Blocks.f_50706_, Items.f_42758_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("oak_sapling", Blocks.f_50050_, Items.f_42799_);
        TaskCatalogue.mine("spruce_sapling", Blocks.f_50051_, Items.f_42800_);
        TaskCatalogue.mine("birch_sapling", Blocks.f_50052_, Items.f_42801_);
        TaskCatalogue.mine("jungle_sapling", Blocks.f_50053_, Items.f_41826_);
        TaskCatalogue.mine("acacia_sapling", Blocks.f_50054_, Items.f_41827_);
        TaskCatalogue.mine("dark_oak_sapling", Blocks.f_50055_, Items.f_41828_);
        TaskCatalogue.mine("mangrove_propagule", Blocks.f_220831_, Items.f_220175_);
        TaskCatalogue.mine("cherry_sapling", Blocks.f_271115_, Items.f_271375_);
        TaskCatalogue.simple("sapling", ItemHelper.SAPLINGS, CollectSaplingsTask::new);
        TaskCatalogue.simple("sandstone", Items.f_41856_, CollectSandstoneTask::new).dontMineIfPresent();
        TaskCatalogue.simple("red_sandstone", Items.f_42252_, CollectRedSandstoneTask::new).dontMineIfPresent();
        TaskCatalogue.simple("coarse_dirt", Items.f_42382_, CollectCoarseDirtTask::new).dontMineIfPresent();
        TaskCatalogue.simple("amethyst_block", Items.f_150998_, CollectAmethystBlockTask::new).dontMineIfPresent();
        TaskCatalogue.simple("dripstone_block", Items.f_151054_, CollectDripstoneBlockTask::new).dontMineIfPresent();
        TaskCatalogue.simple("flint", Items.f_42484_, CollectFlintTask::new);
        TaskCatalogue.simple("obsidian", Items.f_41999_, CollectObsidianTask::new).dontMineIfPresent();
        TaskCatalogue.simple("wool", ItemHelper.WOOL, CollectWoolTask::new);
        TaskCatalogue.simple("egg", Items.f_42521_, CollectEggsTask::new);
        TaskCatalogue.mob("bone", Items.f_42500_, Skeleton.class);
        TaskCatalogue.mob("gunpowder", Items.f_42403_, Creeper.class);
        TaskCatalogue.simple("ender_pearl", Items.f_42584_, KillEndermanTask::new);
        TaskCatalogue.mob("spider_eye", Items.f_42591_, Spider.class);
        TaskCatalogue.mob("leather", Items.f_42454_, Cow.class);
        TaskCatalogue.mob("feather", Items.f_42402_, Chicken.class);
        TaskCatalogue.mob("rotten_flesh", Items.f_42583_, Zombie.class);
        TaskCatalogue.mob("rabbit_foot", Items.f_42648_, Rabbit.class);
        TaskCatalogue.mob("rabbit_hide", Items.f_42649_, Rabbit.class);
        TaskCatalogue.mob("slime_ball", Items.f_42518_, Slime.class);
        TaskCatalogue.mob("wither_skeleton_skull", Items.f_42679_, WitherSkeleton.class).forceDimension(Dimension.NETHER);
        TaskCatalogue.mob("ink_sac", Items.f_42532_, Squid.class);
        TaskCatalogue.mob("glow_ink_sac", Items.f_151056_, GlowSquid.class);
        TaskCatalogue.mob("string", Items.f_42401_, Spider.class);
        TaskCatalogue.mine("sugar_cane", Items.f_41909_);
        TaskCatalogue.mine("brown_mushroom", MiningRequirement.HAND, new Block[]{Blocks.f_50072_, Blocks.f_50180_}, Items.f_41952_);
        TaskCatalogue.mine("red_mushroom", MiningRequirement.HAND, new Block[]{Blocks.f_50073_, Blocks.f_50181_}, Items.f_41953_);
        TaskCatalogue.mine("mushroom", MiningRequirement.HAND, new Block[]{Blocks.f_50072_, Blocks.f_50180_, Blocks.f_50073_, Blocks.f_50181_}, Items.f_41952_, Items.f_41953_);
        TaskCatalogue.mine("melon_slice", MiningRequirement.HAND, Blocks.f_50186_, Items.f_42575_);
        TaskCatalogue.mine("pumpkin", MiningRequirement.HAND, Blocks.f_50133_, Items.f_42046_);
        TaskCatalogue.mine("bell", MiningRequirement.WOOD, Blocks.f_50680_, Items.f_42777_);
        TaskCatalogue.mine("nether_wart", MiningRequirement.HAND, Blocks.f_50200_, Items.f_42588_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("crimson_fungus", MiningRequirement.HAND, Blocks.f_50700_, Items.f_41954_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("warped_fungus", MiningRequirement.HAND, Blocks.f_50691_, Items.f_41955_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("crimson_roots", MiningRequirement.HAND, Blocks.f_50654_, Items.f_41956_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("warped_roots", MiningRequirement.HAND, Blocks.f_50693_, Items.f_41957_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("weeping_vines", MiningRequirement.HAND, Blocks.f_50702_, Items.f_41907_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("twisting_vines", MiningRequirement.HAND, Blocks.f_50704_, Items.f_41908_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("nether_wart_block", MiningRequirement.HAND, Blocks.f_50451_, Items.f_42259_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("warped_wart_block", MiningRequirement.HAND, Blocks.f_50692_, Items.f_42260_).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("shroomlight", MiningRequirement.HAND, Blocks.f_50701_, Items.f_42783_).forceDimension(Dimension.NETHER);
        TaskCatalogue.simple("blaze_rod", Items.f_42585_, CollectBlazeRodsTask::new).forceDimension(Dimension.NETHER);
        TaskCatalogue.mine("quartz", MiningRequirement.WOOD, Blocks.f_50331_, Items.f_42692_).forceDimension(Dimension.NETHER);
        TaskCatalogue.simple("cocoa_beans", Items.f_42533_, CollectCocoaBeansTask::new);
        TaskCatalogue.shear("cobweb", Blocks.f_50033_, Items.f_41863_).dontMineIfPresent();
        TaskCatalogue.colorfulTasks("wool", color -> color.wool, (color, count) -> new CollectWoolTask(color.color, (int)count));
        TaskCatalogue.shear("leaves", ItemHelper.itemsToBlocks(ItemHelper.LEAVES), ItemHelper.LEAVES).dontMineIfPresent();
        for (CataloguedResource resource : TaskCatalogue.woodTasks("leaves", woodItems -> woodItems.leaves, (woodItems, count) -> woodItems.isNetherWood() ? new MineAndCollectTask(woodItems.leaves, (int)count, new Block[]{Block.m_49814_((Item)woodItems.leaves)}, MiningRequirement.HAND).forceDimension(Dimension.NETHER) : new ShearAndCollectBlockTask(woodItems.leaves, (int)count, Block.m_49814_((Item)woodItems.leaves)))) {
            resource.dontMineIfPresent();
        }
        TaskCatalogue.mine("bamboo", Blocks.f_50571_, Items.f_41911_);
        TaskCatalogue.shear("vine", Blocks.f_50191_, Items.f_42029_).dontMineIfPresent();
        TaskCatalogue.shear("grass", Blocks.f_50034_, Items.f_41864_).dontMineIfPresent();
        TaskCatalogue.shear("lily_pad", Blocks.f_50196_, Items.f_42094_).dontMineIfPresent();
        TaskCatalogue.shear("tall_grass", Blocks.f_50359_, Items.f_42210_).dontMineIfPresent();
        TaskCatalogue.shear("fern", Blocks.f_50035_, Items.f_41865_).dontMineIfPresent();
        TaskCatalogue.shear("large_fern", Blocks.f_50360_, Items.f_42211_).dontMineIfPresent();
        TaskCatalogue.shear("dead_bush", Blocks.f_50036_, Items.f_41866_).dontMineIfPresent();
        TaskCatalogue.shear("glow_lichen", Blocks.f_152475_, Items.f_151025_).dontMineIfPresent();
        TaskCatalogue.simple("flower", ItemHelper.FLOWER, CollectFlowerTask::new);
        TaskCatalogue.mine("allium", Items.f_41942_);
        TaskCatalogue.mine("azure_bluet", Items.f_41943_);
        TaskCatalogue.mine("blue_orchid", Items.f_41941_);
        TaskCatalogue.mine("cactus", Items.f_41982_);
        TaskCatalogue.mine("cornflower", Items.f_41949_);
        TaskCatalogue.mine("dandelion", Items.f_41939_);
        TaskCatalogue.mine("lilac", Items.f_42207_);
        TaskCatalogue.mine("lily_of_the_valley", Items.f_41950_);
        TaskCatalogue.mine("orange_tulip", Items.f_41945_);
        TaskCatalogue.mine("oxeye_daisy", Items.f_41948_);
        TaskCatalogue.mine("pink_tulip", Items.f_41947_);
        TaskCatalogue.mine("poppy", Items.f_41940_);
        TaskCatalogue.mine("peony", Items.f_42209_);
        TaskCatalogue.mine("red_tulip", Items.f_41944_);
        TaskCatalogue.mine("rose_bush", Items.f_42208_);
        TaskCatalogue.mine("sunflower", Items.f_42206_);
        TaskCatalogue.mine("white_tulip", Items.f_41946_);
        TaskCatalogue.simple("wheat", Items.f_42405_, CollectWheatTask::new);
        TaskCatalogue.crop("carrot", Items.f_42619_, Blocks.f_50249_, Items.f_42619_);
        TaskCatalogue.crop("potato", Items.f_42620_, Blocks.f_50250_, Items.f_42620_);
        TaskCatalogue.crop("poisonous_potato", Items.f_42675_, Blocks.f_50250_, Items.f_42620_);
        TaskCatalogue.crop("beetroot", Items.f_42732_, Blocks.f_50444_, Items.f_42733_);
        TaskCatalogue.simple("wheat_seeds", Items.f_42404_, CollectWheatSeedsTask::new);
        TaskCatalogue.crop("beetroot_seeds", Items.f_42733_, Blocks.f_50444_, Items.f_42733_);
        TaskCatalogue.simple("netherite_upgrade_smithing_template", Items.f_265918_, GetSmithingTemplateTask::new);
        TaskCatalogue.alias("netherite_upgrade", "netherite_upgrade_smithing_template");
        TaskCatalogue.simple("planks", ItemHelper.PLANKS, CollectPlanksTask::new).dontMineIfPresent();
        for (CataloguedResource woodCatalogue : TaskCatalogue.woodTasks("planks", (ItemHelper.WoodItems wood) -> wood.planks, (ItemHelper.WoodItems wood, Integer count) -> {
            CollectPlanksTask result = new CollectPlanksTask(wood.planks, (int)count);
            if (wood.isNetherWood()) {
                result.logsInNether();
            }
            return result;
        }, true)) {
            woodCatalogue.dontMineIfPresent();
        }
        TaskCatalogue.simple("stripped_logs", ItemHelper.STRIPPED_LOGS, CollectStrippedLogTask::new).dontMineIfPresent();
        for (CataloguedResource woodCatalogue : TaskCatalogue.woodTasks("stripped_logs", wood -> wood.strippedLog, (wood, count) -> new CollectStrippedLogTask(wood.strippedLog, (int)count))) {
            woodCatalogue.dontMineIfPresent();
        }
        TaskCatalogue.simple("stick", Items.f_42398_, CollectSticksTask::new);
        TaskCatalogue.smelt("stone", Items.f_41905_, "cobblestone", new Item[0]).dontMineIfPresent();
        TaskCatalogue.smelt("deepslate", Items.f_151034_, "cobbled_deepslate", new Item[0]).dontMineIfPresent();
        TaskCatalogue.smelt("smooth_stone", Items.f_41994_, "stone", new Item[0]);
        TaskCatalogue.smelt("smooth_quartz", Items.f_41991_, "quartz_block", new Item[0]);
        TaskCatalogue.smelt("smooth_basalt", Items.f_151026_, "basalt", new Item[0]);
        TaskCatalogue.smelt("glass", Items.f_41904_, "sand", new Item[0]).dontMineIfPresent();
        TaskCatalogue.simple("iron_ingot", Items.f_42416_, CollectIronIngotTask::new).forceDimension(Dimension.OVERWORLD);
        TaskCatalogue.smelt("copper_ingot", Items.f_151052_, "raw_copper", Items.f_150965_);
        TaskCatalogue.smelt("charcoal", Items.f_42414_, "log", new Item[0]);
        TaskCatalogue.smelt("brick", Items.f_42460_, "clay_ball", new Item[0]);
        TaskCatalogue.smelt("nether_brick", Items.f_42691_, "netherrack", new Item[0]);
        TaskCatalogue.smelt("green_dye", Items.f_42496_, "cactus", new Item[0]);
        TaskCatalogue.simple("gold_ingot", Items.f_42417_, CollectGoldIngotTask::new).anyDimension();
        TaskCatalogue.shapedRecipe3x3Block("iron_block", Items.f_41913_, "iron_ingot");
        TaskCatalogue.shapedRecipe3x3Block("gold_block", Items.f_41912_, "gold_ingot");
        TaskCatalogue.shapedRecipe3x3Block("copper_block", Items.f_151000_, "copper_ingot");
        TaskCatalogue.shapedRecipe3x3Block("raw_iron_block", Items.f_150995_, "raw_iron");
        TaskCatalogue.shapedRecipe3x3Block("raw_gold_block", Items.f_150997_, "raw_gold");
        TaskCatalogue.shapedRecipe3x3Block("raw_copper_block", Items.f_150996_, "raw_copper");
        TaskCatalogue.shapedRecipe3x3Block("diamond_block", Items.f_41959_, "diamond");
        TaskCatalogue.shapedRecipe3x3Block("redstone_block", Items.f_42153_, "redstone");
        TaskCatalogue.shapedRecipe3x3Block("coal_block", Items.f_42200_, "coal");
        TaskCatalogue.shapedRecipe3x3Block("emerald_block", Items.f_42110_, "emerald");
        TaskCatalogue.shapedRecipe3x3Block("lapis_block", Items.f_41854_, "lapis_lazuli");
        TaskCatalogue.shapedRecipe3x3Block("slime_block", Items.f_42204_, "slime_ball");
        TaskCatalogue.shapedRecipe3x3Block("melon", Items.f_42028_, "melon_slice").dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2Block("glowstone", Items.f_42054_, "glowstone_dust").dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2Block("clay", Items.f_41983_, "clay_ball").dontMineIfPresent();
        TaskCatalogue.smelt("netherite_scrap", Items.f_42419_, "ancient_debris", new Item[0]);
        TaskCatalogue.shapedRecipe3x3("netherite_ingot", Items.f_42418_, 1, "netherite_scrap", "netherite_scrap", "netherite_scrap", "netherite_scrap", "gold_ingot", "gold_ingot", "gold_ingot", "gold_ingot", o);
        TaskCatalogue.simple("gold_nugget", Items.f_42587_, CollectGoldNuggetsTask::new);
        String str8 = "gold_nugget";
        TaskCatalogue.shapedRecipe3x3("glistering_melon_slice", Items.f_42546_, 1, str8, str8, str8, str8, "melon_slice", str8, str8, str8, str8);
        TaskCatalogue.shapedRecipe2x2("sugar", Items.f_42501_, 1, "sugar_cane", o, o, o);
        TaskCatalogue.shapedRecipe2x2("bone_meal", Items.f_42499_, 3, "bone", o, o, o);
        TaskCatalogue.shapedRecipe2x2("melon_seeds", Items.f_42578_, 1, "melon_slice", o, o, o);
        TaskCatalogue.shapedRecipe2x2("bamboo_planks", Items.f_243694_, 2, "bamboo_block", o, o, o);
        TaskCatalogue.shapedRecipe3x3Block("bamboo_block", Items.f_256933_, "bamboo");
        TaskCatalogue.simple("hay_block", Items.f_42129_, CollectHayBlockTask::new).dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2Block("polished_andesite", Items.f_42223_, 4, "andesite");
        TaskCatalogue.shapedRecipe2x2Block("polished_diorite", Items.f_42117_, 4, "diorite");
        TaskCatalogue.shapedRecipe2x2Block("polished_granite", Items.f_42011_, 4, "granite");
        TaskCatalogue.shapedRecipe2x2Block("quartz_block", Items.f_42157_, "quartz");
        TaskCatalogue.shapedRecipe2x2Block("polished_blackstone", Items.f_42759_, 4, "blackstone");
        TaskCatalogue.shapedRecipe2x2Block("polished_blackstone_bricks", Items.f_42763_, 4, "polished_blackstone");
        TaskCatalogue.shapedRecipe2x2Block("polished_basalt", Items.f_42052_, 4, "basalt");
        TaskCatalogue.shapedRecipe2x2Block("polished_deepslate", Items.f_151040_, 4, "cobbled_deepslate");
        TaskCatalogue.shapedRecipe2x2Block("deepslate_bricks", Items.f_151020_, 4, "polished_deepslate");
        TaskCatalogue.shapedRecipe2x2Block("deepslate_tiles", Items.f_151022_, 4, "deepslate_bricks");
        TaskCatalogue.shapedRecipe2x2Block("cut_copper", Items.f_151004_, 4, "copper_block");
        TaskCatalogue.shapedRecipe2x2Block("cut_sandstone", Items.f_41858_, 4, "sandstone");
        TaskCatalogue.shapedRecipe2x2Block("cut_red_sandstone", Items.f_42254_, 4, "red_sandstone");
        TaskCatalogue.shapedRecipe2x2Block("quartz_bricks", Items.f_42158_, 4, "quartz_block");
        TaskCatalogue.shapedRecipe2x2("quartz_pillar", Items.f_42159_, 4, "quartz_block", o, "quartz_block", o);
        TaskCatalogue.shapedRecipe2x2Block("stone_bricks", Items.f_42018_, 4, "stone");
        TaskCatalogue.shapedRecipe2x2("mossy_stone_bricks", Items.f_42019_, 1, "stone_bricks", "vine", o, o);
        TaskCatalogue.shapedRecipe2x2("mossy_cobblestone", Items.f_41998_, 1, "cobblestone", "vine", o, o);
        TaskCatalogue.simple("nether_bricks", Items.f_42095_, CollectNetherBricksTask::new).dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2Block("red_nether_bricks", Items.f_42261_, 4, "nether_wart");
        TaskCatalogue.smelt("cracked_stone_bricks", Items.f_42020_, "stone_bricks", new Item[0]);
        TaskCatalogue.smelt("cracked_nether_bricks", Items.f_42096_, "nether_bricks", new Item[0]);
        TaskCatalogue.smelt("cracked_polished_blackstone_bricks", Items.f_42766_, "polished_blackstone_bricks", new Item[0]);
        TaskCatalogue.smelt("cracked_deepslate_bricks", Items.f_151021_, "deepslate_bricks", new Item[0]);
        TaskCatalogue.smelt("cracked_deepslate_tiles", Items.f_151023_, "deepslate_tiles", new Item[0]);
        TaskCatalogue.smelt("smooth_sandstone", Items.f_41993_, "sandstone", new Item[0]);
        TaskCatalogue.smelt("smooth_red_sandstone", Items.f_41992_, "red_sandstone", new Item[0]);
        String B = "nether_bricks";
        String str13 = "nether_brick";
        TaskCatalogue.shapedRecipe3x3("nether_brick_fence", Items.f_42098_, 6, o, o, o, B, str13, B, B, str13, B);
        TaskCatalogue.shapedRecipe3x3("brush", Items.f_271356_, 1, o, "feather", o, o, "copper_ingot", o, o, s, o);
        TaskCatalogue.shapedRecipe3x3("paper", Items.f_42516_, 3, "sugar_cane", "sugar_cane", "sugar_cane", o, o, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2("book", Items.f_42517_, 1, "paper", "paper", "paper", "leather");
        TaskCatalogue.shapedRecipe2x2("writable_book", Items.f_42614_, 1, "book", "ink_sac", o, "feather");
        TaskCatalogue.alias("book_and_quill", "writable_book");
        TaskCatalogue.shapedRecipe3x3("bowl", Items.f_42399_, 4, p, o, p, o, p, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2("blaze_powder", Items.f_42593_, 2, "blaze_rod", o, o, o);
        TaskCatalogue.shapedRecipe2x2("ender_eye", Items.f_42545_, 1, "blaze_powder", "ender_pearl", o, o);
        TaskCatalogue.alias("eye_of_ender", "ender_eye");
        TaskCatalogue.shapedRecipe2x2("fermented_spider_eye", Items.f_42592_, 1, "brown_mushroom", "sugar", o, "spider_eye");
        TaskCatalogue.shapedRecipe3x3("fire_charge", Items.f_42613_, 3, o, "blaze_powder", o, o, "coal", o, o, "gunpowder", o);
        TaskCatalogue.shapedRecipe2x2("flower_banner_pattern", Items.f_42720_, 1, "paper", "oxeye_daisy", o, o);
        TaskCatalogue.simple("magma_cream", Items.f_42542_, CollectMagmaCreamTask::new);
        TaskCatalogue.shapedRecipeSlab("cobblestone_slab", Items.f_41927_, "cobblestone");
        TaskCatalogue.shapedRecipeStairs("cobblestone_stairs", Items.f_41965_, "cobblestone");
        TaskCatalogue.shapedRecipeWall("cobblestone_wall", Items.f_42066_, "cobblestone");
        TaskCatalogue.shapedRecipeSlab("stone_slab", Items.f_41922_, "stone");
        TaskCatalogue.shapedRecipeStairs("stone_stairs", Items.f_42371_, "stone");
        TaskCatalogue.shapedRecipeSlab("smooth_stone_slab", Items.f_41923_, "smooth_stone");
        TaskCatalogue.shapedRecipeSlab("stone_brick_slab", Items.f_41929_, "stone_bricks");
        TaskCatalogue.shapedRecipeStairs("stone_brick_stairs", Items.f_42092_, "stone_bricks");
        TaskCatalogue.shapedRecipeWall("stone_brick_wall", Items.f_42073_, "stone_bricks");
        TaskCatalogue.shapedRecipeSlab("mossy_stone_brick_slab", Items.f_42381_, "mossy_stone_bricks");
        TaskCatalogue.shapedRecipeStairs("mossy_stone_brick_stairs", Items.f_42367_, "mossy_stone_bricks");
        TaskCatalogue.shapedRecipeWall("mossy_stone_brick_wall", Items.f_42071_, "mossy_stone_bricks");
        TaskCatalogue.shapedRecipeSlab("mossy_cobblestone_slab", Items.f_42331_, "mossy_cobblestone");
        TaskCatalogue.shapedRecipeStairs("mossy_cobblestone_stairs", Items.f_42369_, "mossy_cobblestone");
        TaskCatalogue.shapedRecipeWall("mossy_cobblestone_wall", Items.f_42067_, "mossy_cobblestone");
        TaskCatalogue.shapedRecipeSlab("andesite_slab", Items.f_42336_, "andesite");
        TaskCatalogue.shapedRecipeStairs("andesite_stairs", Items.f_42375_, "andesite");
        TaskCatalogue.shapedRecipeWall("andesite_wall", Items.f_42075_, "andesite");
        TaskCatalogue.shapedRecipeSlab("granite_slab", Items.f_42335_, "granite");
        TaskCatalogue.shapedRecipeStairs("granite_stairs", Items.f_42374_, "granite");
        TaskCatalogue.shapedRecipeWall("granite_wall", Items.f_42072_, "granite");
        TaskCatalogue.shapedRecipeSlab("diorite_slab", Items.f_42339_, "diorite");
        TaskCatalogue.shapedRecipeStairs("diorite_stairs", Items.f_42378_, "diorite");
        TaskCatalogue.shapedRecipeWall("diorite_wall", Items.f_42079_, "diorite");
        TaskCatalogue.shapedRecipeSlab("polished_andesite_slab", Items.f_42338_, "polished_andesite");
        TaskCatalogue.shapedRecipeStairs("polished_andesite_stairs", Items.f_42377_, "polished_andesite");
        TaskCatalogue.shapedRecipeSlab("polished_granite_slab", Items.f_42379_, "polished_granite");
        TaskCatalogue.shapedRecipeStairs("polished_granite_stairs", Items.f_42365_, "polished_granite");
        TaskCatalogue.shapedRecipeSlab("polished_diorite_slab", Items.f_42330_, "polished_diorite");
        TaskCatalogue.shapedRecipeStairs("polished_diorite_stairs", Items.f_42368_, "polished_diorite");
        TaskCatalogue.shapedRecipeSlab("sandstone_slab", Items.f_41924_, "sandstone");
        TaskCatalogue.shapedRecipeStairs("sandstone_stairs", Items.f_42106_, "sandstone");
        TaskCatalogue.shapedRecipeWall("sandstone_wall", Items.f_42077_, "sandstone");
        TaskCatalogue.shapedRecipeSlab("cut_sandstone_slab", Items.f_41925_, "cut_sandstone");
        TaskCatalogue.shapedRecipeSlab("smooth_sandstone_slab", Items.f_42333_, "smooth_sandstone");
        TaskCatalogue.shapedRecipeStairs("smooth_sandstone_stairs", Items.f_42372_, "smooth_sandstone");
        TaskCatalogue.shapedRecipeSlab("red_sandstone_slab", Items.f_41985_, "red_sandstone");
        TaskCatalogue.shapedRecipeStairs("red_sandstone_stairs", Items.f_42255_, "red_sandstone");
        TaskCatalogue.shapedRecipeWall("red_sandstone_wall", Items.f_42070_, "red_sandstone");
        TaskCatalogue.shapedRecipeSlab("cut_red_sandstone_slab", Items.f_41986_, "cut_red_sandstone");
        TaskCatalogue.shapedRecipeSlab("smooth_red_sandstone_slab", Items.f_42380_, "smooth_red_sandstone");
        TaskCatalogue.shapedRecipeStairs("smooth_red_sandstone_stairs", Items.f_42366_, "smooth_red_sandstone");
        TaskCatalogue.shapedRecipeSlab("nether_brick_slab", Items.f_41930_, "nether_bricks");
        TaskCatalogue.shapedRecipeStairs("nether_brick_stairs", Items.f_42099_, "nether_bricks");
        TaskCatalogue.shapedRecipeWall("nether_brick_wall", Items.f_42074_, "nether_bricks");
        TaskCatalogue.shapedRecipeSlab("red_nether_brick_slab", Items.f_42337_, "red_nether_bricks");
        TaskCatalogue.shapedRecipeStairs("red_nether_brick_stairs", Items.f_42376_, "red_nether_bricks");
        TaskCatalogue.shapedRecipeWall("red_nether_brick_wall", Items.f_42076_, "red_nether_bricks");
        TaskCatalogue.shapedRecipeSlab("quartz_slab", Items.f_41931_, "quartz_block");
        TaskCatalogue.shapedRecipeStairs("quartz_stairs", Items.f_42160_, "quartz_block");
        TaskCatalogue.shapedRecipeSlab("smooth_quartz_slab", Items.f_42334_, "smooth_quartz");
        TaskCatalogue.shapedRecipeStairs("smooth_quartz_stairs", Items.f_42373_, "smooth_quartz");
        TaskCatalogue.shapedRecipeSlab("blackstone_slab", Items.f_42756_, "blackstone");
        TaskCatalogue.shapedRecipeStairs("blackstone_stairs", Items.f_42757_, "blackstone");
        TaskCatalogue.shapedRecipeWall("blackstone_wall", Items.f_42080_, "blackstone");
        TaskCatalogue.shapedRecipeSlab("polished_blackstone_slab", Items.f_42760_, "polished_blackstone");
        TaskCatalogue.shapedRecipeStairs("polished_blackstone_stairs", Items.f_42761_, "polished_blackstone");
        TaskCatalogue.shapedRecipeWall("polished_blackstone_wall", Items.f_42081_, "polished_blackstone");
        TaskCatalogue.shapedRecipeSlab("polished_blackstone_brick_slab", Items.f_42764_, "polished_blackstone_bricks");
        TaskCatalogue.shapedRecipeStairs("polished_blackstone_brick_stairs", Items.f_42765_, "polished_blackstone_bricks");
        TaskCatalogue.shapedRecipeWall("polished_blackstone_brick_wall", Items.f_42082_, "polished_blackstone_bricks");
        TaskCatalogue.shapedRecipeSlab("cut_copper_slab", Items.f_150973_, "cut_copper");
        TaskCatalogue.shapedRecipeStairs("cut_copper_stairs", Items.f_151008_, "cut_copper");
        TaskCatalogue.shapedRecipeSlab("cobbled_deepslate_slab", Items.f_151043_, "cobbled_deepslate");
        TaskCatalogue.shapedRecipeStairs("cobbled_deepslate_stairs", Items.f_151036_, "cobbled_deepslate");
        TaskCatalogue.shapedRecipeWall("cobbled_deepslate_wall", Items.f_151028_, "cobbled_deepslate");
        TaskCatalogue.shapedRecipeSlab("polished_deepslate_slab", Items.f_151044_, "polished_deepslate");
        TaskCatalogue.shapedRecipeStairs("polished_deepslate_stairs", Items.f_151037_, "polished_deepslate");
        TaskCatalogue.shapedRecipeWall("polished_deepslate_wall", Items.f_151029_, "polished_deepslate");
        TaskCatalogue.shapedRecipeSlab("deepslate_brick_slab", Items.f_151045_, "deepslate_bricks");
        TaskCatalogue.shapedRecipeStairs("deepslate_brick_stairs", Items.f_151038_, "deepslate_bricks");
        TaskCatalogue.shapedRecipeWall("deepslate_brick_wall", Items.f_151030_, "deepslate_bricks");
        TaskCatalogue.shapedRecipeSlab("deepslate_tile_slab", Items.f_151046_, "deepslate_tiles");
        TaskCatalogue.shapedRecipeStairs("deepslate_tile_stairs", Items.f_151039_, "deepslate_tiles");
        TaskCatalogue.shapedRecipeWall("deepslate_tile_wall", Items.f_151031_, "deepslate_tiles");
        TaskCatalogue.shapedRecipe2x2("chiseled_sandstone", Items.f_41857_, 1, "sandstone_slab", o, "sandstone_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_red_sandstone", Items.f_42253_, 1, "red_sandstone_slab", o, "red_sandstone_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_stone_bricks", Items.f_42021_, 1, "stone_brick_slab", o, "stone_brick_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_nether_bricks", Items.f_42097_, 1, "nether_brick_slab", o, "nether_brick_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_quartz_block", Items.f_42156_, 1, "quartz_slab", o, "quartz_slab", o);
        TaskCatalogue.shapedRecipe2x2("chiseled_deepslate", Items.f_151024_, 1, "cobbled_deepslate_slab", o, "cobbled_deepslate_slab", o);
        TaskCatalogue.tools("wooden", "planks", Items.f_42422_, Items.f_42421_, Items.f_42420_, Items.f_42423_, Items.f_42424_);
        TaskCatalogue.tools("stone", "cobblestone", Items.f_42427_, Items.f_42426_, Items.f_42425_, Items.f_42428_, Items.f_42429_);
        TaskCatalogue.tools("iron", "iron_ingot", Items.f_42385_, Items.f_42384_, Items.f_42383_, Items.f_42386_, Items.f_42387_);
        TaskCatalogue.tools("golden", "gold_ingot", Items.f_42432_, Items.f_42431_, Items.f_42430_, Items.f_42433_, Items.f_42434_);
        TaskCatalogue.tools("diamond", "diamond", Items.f_42390_, Items.f_42389_, Items.f_42388_, Items.f_42391_, Items.f_42392_);
        TaskCatalogue.armor("leather", "leather", Items.f_42407_, Items.f_42408_, Items.f_42462_, Items.f_42463_);
        TaskCatalogue.armor("iron", "iron_ingot", Items.f_42468_, Items.f_42469_, Items.f_42470_, Items.f_42471_);
        TaskCatalogue.armor("golden", "gold_ingot", Items.f_42476_, Items.f_42477_, Items.f_42478_, Items.f_42479_);
        TaskCatalogue.armor("diamond", "diamond", Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_);
        TaskCatalogue.smith("netherite_helmet", Items.f_42480_, "netherite_ingot", "diamond_helmet");
        TaskCatalogue.smith("netherite_chestplate", Items.f_42481_, "netherite_ingot", "diamond_chestplate");
        TaskCatalogue.smith("netherite_leggings", Items.f_42482_, "netherite_ingot", "diamond_leggings");
        TaskCatalogue.smith("netherite_boots", Items.f_42483_, "netherite_ingot", "diamond_boots");
        TaskCatalogue.smith("netherite_pickaxe", Items.f_42395_, "netherite_ingot", "diamond_pickaxe");
        TaskCatalogue.smith("netherite_axe", Items.f_42396_, "netherite_ingot", "diamond_axe");
        TaskCatalogue.smith("netherite_shovel", Items.f_42394_, "netherite_ingot", "diamond_shovel");
        TaskCatalogue.smith("netherite_sword", Items.f_42393_, "netherite_ingot", "diamond_sword");
        TaskCatalogue.smith("netherite_hoe", Items.f_42397_, "netherite_ingot", "diamond_hoe");
        TaskCatalogue.shapedRecipe3x3("bow", Items.f_42411_, 1, "string", s, o, "string", o, s, "string", s, o);
        TaskCatalogue.shapedRecipe3x3("arrow", Items.f_42412_, 4, "flint", o, o, s, o, o, "feather", o, o);
        String str7 = "iron_ingot";
        TaskCatalogue.shapedRecipe3x3("bucket", Items.f_42446_, 1, str7, o, str7, o, str7, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2("flint_and_steel", Items.f_42409_, 1, str7, o, o, "flint");
        TaskCatalogue.shapedRecipe2x2("shears", Items.f_42574_, 1, str7, o, o, str7);
        TaskCatalogue.shapedRecipe2x2("iron_nugget", Items.f_42749_, 9, str7, o, o, o);
        TaskCatalogue.shapedRecipe3x3("compass", Items.f_42522_, 1, o, str7, o, str7, "redstone", str7, o, str7, o);
        TaskCatalogue.shapedRecipe3x3("shield", Items.f_42740_, 1, p, str7, p, p, p, p, o, p, o);
        String str12 = "gold_ingot";
        TaskCatalogue.shapedRecipe3x3("clock", Items.f_42524_, 1, o, str12, o, str12, "redstone", str12, o, str12, o);
        TaskCatalogue.simple("water_bucket", Items.f_42447_, CollectBucketLiquidTask.CollectWaterBucketTask::new);
        TaskCatalogue.simple("lava_bucket", Items.f_42448_, CollectBucketLiquidTask.CollectLavaBucketTask::new);
        String a = "paper";
        TaskCatalogue.shapedRecipe3x3("map", Items.f_42676_, 1, a, a, a, a, "compass", a, a, a, a);
        TaskCatalogue.shapedRecipe3x3("fishing_rod", Items.f_42523_, 1, o, o, s, o, s, "string", s, o, "string");
        TaskCatalogue.shapedRecipe2x2("carrot_on_a_stick", Items.f_42684_, 1, "fishing_rod", "carrot", o, o);
        TaskCatalogue.shapedRecipe2x2("warped_fungus_on_a_stick", Items.f_42685_, 1, "fishing_rod", "warped_fungus", o, o);
        TaskCatalogue.shapedRecipe3x3("spyglass", Items.f_151059_, 1, o, "amethyst_shard", o, o, "copper_ingot", o, o, "copper_ingot", o);
        TaskCatalogue.shapedRecipe3x3("glass_bottle", Items.f_42590_, 3, "glass", o, "glass", o, "glass", o, o, o, o);
        String str6 = "leather";
        TaskCatalogue.shapedRecipe3x3("leather_horse_armor", Items.f_42654_, 1, str6, o, str6, str6, str6, str6, str6, o, str6);
        TaskCatalogue.alias("wooden_pick", "wooden_pickaxe");
        TaskCatalogue.alias("stone_pick", "stone_pickaxe");
        TaskCatalogue.alias("iron_pick", "iron_pickaxe");
        TaskCatalogue.alias("gold_pick", "golden_pickaxe");
        TaskCatalogue.alias("diamond_pick", "diamond_pickaxe");
        TaskCatalogue.alias("netherite_pick", "netherite_pickaxe");
        TaskCatalogue.simple("boat", ItemHelper.WOOD_BOAT, CollectBoatTask::new);
        TaskCatalogue.woodTasks("boat", woodItems -> woodItems.boat, (woodItems, count) -> new CollectBoatTask(woodItems.boat, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.shapedRecipe3x3("lead", Items.f_42655_, 1, "string", "string", o, "string", "slime_ball", o, o, o, "string");
        TaskCatalogue.simple("honeycomb", Items.f_42784_, CollectHoneycombTask::new);
        String h = "honeycomb";
        TaskCatalogue.shapedRecipe2x2Block("honeycomb_block", Items.f_42789_, h);
        TaskCatalogue.shapedRecipe2x2("candle", Items.f_151065_, 1, "string", o, h, o);
        TaskCatalogue.shapedRecipe3x3("beehive", Items.f_42786_, 1, p, p, p, h, h, h, p, p, p);
        TaskCatalogue.shapedRecipe2x2("crafting_table", Items.f_41960_, 1, p, p, p, p).dontMineIfPresent();
        TaskCatalogue.shapedRecipe3x3("smithing_table", Items.f_42775_, 1, "iron_ingot", "iron_ingot", o, p, p, o, p, p, o);
        TaskCatalogue.shapedRecipe3x3("grindstone", Items.f_42773_, 1, s, "stone_slab", s, p, o, p, o, o, o);
        TaskCatalogue.simple("wooden_pressure_plate", ItemHelper.WOOD_PRESSURE_PLATE, CollectWoodenPressurePlateTask::new);
        TaskCatalogue.woodTasks("pressure_plate", woodItems -> woodItems.pressurePlate, (woodItems, count) -> new CollectWoodenPressurePlateTask(woodItems.pressurePlate, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_button", ItemHelper.WOOD_BUTTON, CollectWoodenButtonTask::new);
        TaskCatalogue.woodTasks("button", woodItems -> woodItems.button, (woodItems, count) -> new CraftInInventoryTask(new RecipeTarget(woodItems.button, 1, CraftingRecipe.newShapedRecipe(woodItems.prefix + "_button", new ItemTarget[]{new ItemTarget(woodItems.planks, 1), null, null, null}, 1))));
        TaskCatalogue.shapedRecipe2x2("stone_pressure_plate", Items.f_41967_, 1, o, o, "stone", "stone");
        TaskCatalogue.shapedRecipe2x2("stone_button", Items.f_42083_, 1, "stone", o, o, o);
        TaskCatalogue.shapedRecipe2x2("polished_blackstone_pressure_plate", Items.f_41976_, 1, o, o, "polished_blackstone", "polished_blackstone");
        TaskCatalogue.shapedRecipe2x2("polished_blackstone_button", Items.f_42145_, 1, "polished_blackstone", o, o, o);
        TaskCatalogue.simple("sign", ItemHelper.WOOD_SIGN, CollectSignTask::new).dontMineIfPresent();
        TaskCatalogue.woodTasks("sign", woodItems -> woodItems.sign, (woodItems, count) -> new CollectSignTask(woodItems.sign, woodItems.prefix + "_planks", (int)count));
        String str5 = "cobblestone";
        TaskCatalogue.shapedRecipe3x3("furnace", Items.f_41962_, 1, str5, str5, str5, str5, o, str5, str5, str5, str5).dontMineIfPresent();
        TaskCatalogue.shapedRecipe3x3("dropper", Items.f_42162_, 1, str5, str5, str5, str5, o, str5, str5, "redstone", str5);
        TaskCatalogue.shapedRecipe3x3("dispenser", Items.f_41855_, 1, str5, str5, str5, str5, "bow", str5, str5, "redstone", str5);
        TaskCatalogue.shapedRecipe3x3("brewing_stand", Items.f_42543_, 1, o, o, o, o, "blaze_rod", o, str5, str5, str5);
        TaskCatalogue.shapedRecipe3x3("piston", Items.f_41869_, 1, p, p, p, str5, "iron_ingot", str5, str5, "redstone", str5);
        TaskCatalogue.shapedRecipe3x3("observer", Items.f_42264_, 1, str5, str5, str5, "redstone", "redstone", "quartz", str5, str5, str5);
        TaskCatalogue.shapedRecipe2x2("lever", Items.f_41966_, 1, s, o, str5, o);
        TaskCatalogue.simple("hanging_sign", ItemHelper.WOOD_HANGING_SIGN, CollectHangingSignTask::new).dontMineIfPresent();
        TaskCatalogue.woodTasks("hanging_sign", woodItems -> woodItems.hangingSign, (woodItems, count) -> new CollectHangingSignTask(woodItems.hangingSign, woodItems.prefix + "_stripped_logs", (int)count));
        TaskCatalogue.shapedRecipe3x3("chest", Items.f_42009_, 1, p, p, p, p, o, p, p, p, p).dontMineIfPresent();
        TaskCatalogue.shapedRecipe2x2("torch", Items.f_42000_, 4, "coal", o, s, o);
        TaskCatalogue.simple("bed", ItemHelper.BED, CollectBedTask::new);
        TaskCatalogue.colorfulTasks("bed", colors -> colors.bed, (colors, count) -> new CollectBedTask(colors.bed, colors.colorName + "_wool", (int)count));
        String str4 = "iron_ingot";
        String str11 = "iron_block";
        String m = "smooth_stone";
        TaskCatalogue.shapedRecipe3x3("anvil", Items.f_42146_, 1, str11, str11, str11, o, str4, o, str4, str4, str4);
        TaskCatalogue.shapedRecipe3x3("cauldron", Items.f_42544_, 1, str4, o, str4, str4, o, str4, str4, str4, str4);
        TaskCatalogue.shapedRecipe3x3("minecart", Items.f_42449_, 1, o, o, o, str4, o, str4, str4, str4, str4);
        TaskCatalogue.shapedRecipe3x3("iron_door", Items.f_42341_, 3, str4, str4, o, str4, str4, o, str4, str4, o);
        TaskCatalogue.shapedRecipe3x3("iron_bars", Items.f_42025_, 16, str4, str4, str4, str4, str4, str4, o, o, o);
        TaskCatalogue.shapedRecipe3x3("blast_furnace", Items.f_42770_, 1, str4, str4, str4, str4, "furnace", str4, m, m, m);
        TaskCatalogue.shapedRecipe2x2Block("iron_trapdoor", Items.f_42128_, str4);
        TaskCatalogue.shapedRecipe3x3("armor_stand", Items.f_42650_, 1, s, s, s, o, s, o, s, "smooth_stone_slab", s);
        String str3 = "obsidian";
        TaskCatalogue.shapedRecipe3x3("enchanting_table", Items.f_42100_, 1, o, "book", o, "diamond", str3, "diamond", str3, str3, str3);
        TaskCatalogue.shapedRecipe3x3("ender_chest", Items.f_42108_, 1, str3, str3, str3, str3, "ender_eye", str3, str3, str3, str3).dontMineIfPresent();
        str3 = "brick";
        TaskCatalogue.shapedRecipe3x3("decorated_pot", Items.f_271478_, 1, o, str3, o, str3, o, str3, o, str3, o);
        TaskCatalogue.shapedRecipe3x3("flower_pot", Items.f_42618_, 1, str3, o, str3, o, str3, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2Block("bricks", Items.f_41995_, str3);
        TaskCatalogue.shapedRecipeSlab("brick_slab", Items.f_41928_, str3);
        TaskCatalogue.shapedRecipeStairs("brick_stairs", Items.f_42091_, str3);
        TaskCatalogue.shapedRecipeStairs("brick_wall", Items.f_42068_, "brick");
        TaskCatalogue.shapedRecipe3x3("ladder", Items.f_41963_, 3, s, o, s, s, s, s, s, o, s);
        TaskCatalogue.shapedRecipe3x3("jukebox", Items.f_41984_, 1, p, p, p, p, "diamond", p, p, p, p);
        TaskCatalogue.shapedRecipe3x3("note_block", Items.f_41859_, 1, p, p, p, p, "redstone", p, p, p, p);
        TaskCatalogue.shapedRecipe3x3("redstone_lamp", Items.f_42105_, 1, o, "redstone", o, "redstone", "glowstone", "redstone", o, "redstone", o);
        TaskCatalogue.shapedRecipe3x3("bookshelf", Items.f_41997_, 1, p, p, p, "book", "book", "book", p, p, p);
        TaskCatalogue.shapedRecipe2x2("loom", Items.f_42719_, 1, "string", "string", p, p);
        String str2 = "glass";
        TaskCatalogue.shapedRecipe3x3("glass_pane", Items.f_42027_, 16, str2, str2, str2, str2, str2, str2, o, o, o).dontMineIfPresent();
        TaskCatalogue.simple("carved_pumpkin", Items.f_42047_, (Integer count) -> new CarveThenCollectTask(Items.f_42047_, (int)count, Blocks.f_50143_, Items.f_42046_, Blocks.f_50133_, Items.f_42574_));
        TaskCatalogue.shapedRecipe2x2("jack_o_lantern", Items.f_42055_, 1, "carved_pumpkin", o, "torch", o);
        TaskCatalogue.shapedRecipe3x3("target", Items.f_42793_, 1, o, "redstone", o, "redstone", "hay_block", "redstone", o, "redstone", o);
        TaskCatalogue.shapedRecipe3x3("campfire", Items.f_42781_, 1, o, s, o, s, "coal", s, "log", "log", "log");
        TaskCatalogue.shapedRecipe3x3("soul_campfire", Items.f_42782_, 1, o, s, o, s, "soul_soil", s, "log", "log", "log");
        TaskCatalogue.shapedRecipe3x3("soul_torch", Items.f_42053_, 4, o, "coal", o, o, s, o, o, "soul_soil", o);
        String l = "log";
        TaskCatalogue.shapedRecipe3x3("smoker", Items.f_42769_, 1, o, l, o, l, "furnace", l, o, l, o);
        String str1 = "iron_nugget";
        TaskCatalogue.shapedRecipe3x3("lantern", Items.f_42778_, 1, str1, str1, str1, str1, "torch", str1, str1, str1, str1);
        TaskCatalogue.shapedRecipe3x3("soul_lantern", Items.f_42779_, 1, str1, str1, str1, str1, "soul_torch", str1, str1, str1, str1);
        TaskCatalogue.shapedRecipe3x3("chain", Items.f_42026_, 1, o, str1, o, o, "iron_ingot", o, o, str1, o);
        String c = "chiseled_stone_bricks";
        TaskCatalogue.shapedRecipe3x3("lodestone", Items.f_42790_, 1, c, c, c, c, "netherite_ingot", c, c, c, c);
        TaskCatalogue.shapedRecipe3x3("lightning_rod", Items.f_151041_, 1, o, "copper_ingot", o, o, "copper_ingot", o, o, "copper_ingot", o);
        TaskCatalogue.shapedRecipe3x3("tinted_glass", Items.f_151011_, 2, o, "amethyst_shard", o, "amethyst_shard", "glass", "amethyst_shard", o, "amethyst_shard", o);
        TaskCatalogue.simple("wooden_stairs", ItemHelper.WOOD_STAIRS, CollectWoodenStairsTask::new);
        TaskCatalogue.woodTasks("stairs", woodItems -> woodItems.stairs, (woodItems, count) -> new CollectWoodenStairsTask(woodItems.stairs, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_slab", ItemHelper.WOOD_SLAB, CollectWoodenSlabTask::new);
        TaskCatalogue.woodTasks("slab", woodItems -> woodItems.slab, (woodItems, count) -> new CollectWoodenSlabTask(woodItems.slab, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_door", ItemHelper.WOOD_DOOR, CollectWoodenDoorTask::new);
        TaskCatalogue.woodTasks("door", woodItems -> woodItems.door, (woodItems, count) -> new CollectWoodenDoorTask(woodItems.door, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_trapdoor", ItemHelper.WOOD_TRAPDOOR, CollectWoodenTrapDoorTask::new);
        TaskCatalogue.woodTasks("trapdoor", woodItems -> woodItems.trapdoor, (woodItems, count) -> new CollectWoodenTrapDoorTask(woodItems.trapdoor, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_fence", ItemHelper.WOOD_FENCE, CollectFenceTask::new);
        TaskCatalogue.woodTasks("fence", woodItems -> woodItems.fence, (woodItems, count) -> new CollectFenceTask(woodItems.fence, woodItems.prefix + "_planks", (int)count));
        TaskCatalogue.simple("wooden_fence_gate", ItemHelper.WOOD_FENCE_GATE, CollectFenceGateTask::new);
        TaskCatalogue.woodTasks("fence_gate", woodItems -> woodItems.fenceGate, (woodItems, count) -> new CollectFenceGateTask(woodItems.fenceGate, woodItems.prefix + "_planks", (int)count));
        String r = "wooden_slab";
        TaskCatalogue.shapedRecipe3x3("chiseled_bookshelf", Items.f_244640_, 1, p, p, p, r, r, r, p, p, p).dontMineIfPresent();
        TaskCatalogue.shapedRecipe3x3("barrel", Items.f_42768_, 1, p, r, p, p, o, p, p, r, p);
        TaskCatalogue.shapedRecipe3x3("cartography_table", Items.f_42771_, 1, "paper", "paper", o, p, p, o, p, p, o);
        TaskCatalogue.shapedRecipe3x3("composter", Items.f_42726_, 1, r, o, r, r, o, r, r, r, r);
        TaskCatalogue.shapedRecipe3x3("fletching_table", Items.f_42772_, 1, "flint", "flint", o, p, p, o, p, p, o);
        TaskCatalogue.shapedRecipe3x3("lectern", Items.f_42774_, 1, r, r, r, o, "bookshelf", o, o, r, o);
        TaskCatalogue.alias("door", "wooden_door");
        TaskCatalogue.alias("trapdoor", "wooden_trapdoor");
        TaskCatalogue.alias("fence", "wooden_fence");
        TaskCatalogue.alias("fence_gate", "wooden_fence_gate");
        TaskCatalogue.shapedRecipe2x2("heavy_weighted_pressure_plate", Items.f_42151_, 1, "iron_ingot", "iron_ingot", o, o);
        TaskCatalogue.shapedRecipe2x2("light_weighted_pressure_plate", Items.f_42150_, 1, "gold_ingot", "gold_ingot", o, o);
        TaskCatalogue.shapedRecipe3x3("daylight_detector", Items.f_42152_, 1, "glass", "glass", "glass", "quartz", "quartz", "quartz", "wooden_slab", "wooden_slab", "wooden_slab");
        TaskCatalogue.shapedRecipe3x3("tripwire_hook", Items.f_42109_, 2, "iron_ingot", o, o, "stick", o, o, "planks", o, o);
        TaskCatalogue.shapedRecipe2x2("trapped_chest", Items.f_42149_, 1, "chest", "tripwire_hook", o, o);
        TaskCatalogue.shapedRecipe3x3("crossbow", Items.f_42717_, 1, s, "iron_ingot", s, "string", "tripwire_hook", "string", o, s, o);
        String t = "gunpowder";
        String n = "sand";
        TaskCatalogue.shapedRecipe3x3("tnt", Items.f_41996_, 1, t, n, t, n, t, n, t, n, t);
        TaskCatalogue.shapedRecipe2x2("sticky_piston", Items.f_41862_, 1, "slime_ball", o, "piston", o);
        TaskCatalogue.shapedRecipe2x2("redstone_torch", Items.f_41978_, 1, "redstone", o, s, o);
        TaskCatalogue.shapedRecipe3x3("repeater", Items.f_42350_, 1, "redstone_torch", "redstone", "redstone_torch", "stone", "stone", "stone", o, o, o);
        TaskCatalogue.shapedRecipe3x3("comparator", Items.f_42351_, 1, o, "redstone_torch", o, "redstone_torch", "quartz", "redstone_torch", "stone", "stone", "stone");
        String i = "iron_ingot";
        String str10 = "gold_ingot";
        TaskCatalogue.shapedRecipe3x3("rail", Items.f_41964_, 16, i, o, i, i, s, i, i, o, i);
        TaskCatalogue.shapedRecipe3x3("powered_rail", Items.f_41860_, 6, str10, o, str10, str10, s, str10, str10, "redstone", str10);
        TaskCatalogue.shapedRecipe3x3("detector_rail", Items.f_41861_, 6, i, o, i, i, "stone_pressure_plate", i, i, "redstone", i);
        TaskCatalogue.shapedRecipe3x3("activator_rail", Items.f_42161_, 6, i, s, i, i, "redstone_torch", i, i, s, i);
        TaskCatalogue.shapedRecipe3x3("hopper", Items.f_42155_, 1, i, o, i, i, "chest", i, o, i, o);
        TaskCatalogue.shapedRecipe3x3("painting", Items.f_42487_, 1, s, s, s, s, "wool", s, s, s, s);
        TaskCatalogue.shapedRecipe3x3("item_frame", Items.f_42617_, 1, s, s, s, s, "leather", s, s, s, s);
        TaskCatalogue.shapedRecipe2x2("glow_item_frame", Items.f_151063_, 1, "item_frame", "glow_ink_sac", o, o);
        TaskCatalogue.shapedRecipe2x2("chest_minecart", Items.f_42519_, 1, "chest", o, "minecart", o);
        TaskCatalogue.shapedRecipe2x2("furnace_minecart", Items.f_42520_, 1, "furnace", o, "minecart", o);
        TaskCatalogue.shapedRecipe2x2("hopper_minecart", Items.f_42694_, 1, "hopper", o, "minecart", o);
        TaskCatalogue.shapedRecipe2x2("tnt_minecart", Items.f_42693_, 1, "tnt", o, "minecart", o);
        TaskCatalogue.alias("minecart_with_chest", "chest_minecart");
        TaskCatalogue.alias("minecart_with_furnace", "furnace_minecart");
        TaskCatalogue.alias("minecart_with_hopper", "hopper_minecart");
        TaskCatalogue.alias("minecart_with_tnt", "tnt_minecart");
        TaskCatalogue.mobCook("porkchop", Items.f_42485_, Items.f_42486_, Pig.class);
        TaskCatalogue.mobCook("beef", Items.f_42579_, Items.f_42580_, Cow.class);
        TaskCatalogue.mobCook("chicken", Items.f_42581_, Items.f_42582_, Chicken.class);
        TaskCatalogue.mobCook("mutton", Items.f_42658_, Items.f_42659_, Sheep.class);
        TaskCatalogue.mobCook("rabbit", Items.f_42697_, Items.f_42698_, Rabbit.class);
        TaskCatalogue.mobCook("salmon", Items.f_42527_, Items.f_42531_, Salmon.class);
        TaskCatalogue.mobCook("cod", Items.f_42526_, Items.f_42530_, Cod.class);
        TaskCatalogue.simple("milk", Items.f_42455_, CollectMilkTask::new);
        TaskCatalogue.mine("apple", Blocks.f_50050_, Items.f_42410_);
        TaskCatalogue.smelt("baked_potato", Items.f_42674_, "potato", new Item[0]);
        TaskCatalogue.shapedRecipe2x2("mushroom_stew", Items.f_42400_, 1, "red_mushroom", "brown_mushroom", "bowl", o);
        TaskCatalogue.shapedRecipe2x2("suspicious_stew", Items.f_42718_, 1, "red_mushroom", "brown_mushroom", "bowl", "flower");
        TaskCatalogue.shapedRecipe3x3("bread", Items.f_42406_, 1, "wheat", "wheat", "wheat", o, o, o, o, o, o);
        TaskCatalogue.shapedRecipe3x3("cookie", Items.f_42572_, 8, "wheat", "cocoa_beans", "wheat", o, o, o, o, o, o);
        TaskCatalogue.shapedRecipe2x2("pumpkin_pie", Items.f_42687_, 1, "pumpkin", "sugar", o, "egg");
        TaskCatalogue.shapedRecipe3x3("cake", Items.f_42502_, 1, "milk", "milk", "milk", "sugar", "egg", "sugar", "wheat", "wheat", "wheat").dontMineIfPresent();
        String g = "gold_nugget";
        TaskCatalogue.shapedRecipe3x3("golden_carrot", Items.f_42677_, 1, g, g, g, g, "carrot", g, g, g, g);
        String str9 = "gold_ingot";
        TaskCatalogue.shapedRecipe3x3("golden_apple", Items.f_42436_, 1, str9, str9, str9, str9, "apple", str9, str9, str9, str9);
        TaskCatalogue.shapedRecipe3x3("rabbit_stew", Items.f_42699_, 1, o, "cooked_rabbit", o, "carrot", "baked_potato", "mushroom", o, "bowl", o);
        String b = "beetroot";
        TaskCatalogue.shapedRecipe3x3("beetroot_soup", Items.f_42734_, 1, b, b, b, b, b, b, o, "bowl", o);
    }

    private static class CataloguedResource {
        private final Item[] targets;
        private final Function<Integer, ResourceTask> getResource;
        private boolean mineIfPresent;
        private boolean forceDimension = false;
        private Dimension targetDimension;

        public CataloguedResource(Item[] targets, Function<Integer, ResourceTask> getResource) {
            this.targets = targets;
            this.getResource = getResource;
        }

        public CataloguedResource mineIfPresent() {
            this.mineIfPresent = true;
            return this;
        }

        public CataloguedResource dontMineIfPresent() {
            this.mineIfPresent = false;
            return this;
        }

        public CataloguedResource forceDimension(Dimension dimension) {
            this.forceDimension = true;
            this.targetDimension = dimension;
            return this;
        }

        public CataloguedResource anyDimension() {
            this.forceDimension = false;
            return this;
        }

        public ResourceTask getResource(int count) {
            ResourceTask result = this.getResource.apply(count);
            if (this.mineIfPresent) {
                result = result.mineIfPresent(ItemHelper.itemsToBlocks(this.targets));
            }
            if (this.forceDimension) {
                result = result.forceDimension(this.targetDimension);
            }
            return result;
        }
    }
}

