/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class LivingEntityInventory
implements Container,
Nameable {
    public static final int ITEM_USAGE_COOLDOWN = 5;
    public static final int MAIN_SIZE = 36;
    private static final int HOTBAR_SIZE = 9;
    public static final int OFF_HAND_SLOT = 40;
    public static final int NOT_FOUND = -1;
    public static final int[] ARMOR_SLOTS = new int[]{0, 1, 2, 3};
    public static final int[] HELMET_SLOTS = new int[]{3};
    public final NonNullList<ItemStack> main = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
    public final NonNullList<ItemStack> armor = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public final NonNullList<ItemStack> offHand = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private final List<NonNullList<ItemStack>> combinedInventory = ImmutableList.of(this.main, this.armor, this.offHand);
    public int selectedSlot;
    public LivingEntity player;
    private int changeCount;

    public LivingEntityInventory(LivingEntity player) {
        this.player = player;
    }

    public ItemStack getMainHandStack() {
        return LivingEntityInventory.isValidHotbarIndex(this.selectedSlot) ? (ItemStack)this.main.get(this.selectedSlot) : ItemStack.f_41583_;
    }

    public static int getHotbarSize() {
        return 9;
    }

    private boolean canStackAddMore(ItemStack existingStack, ItemStack stack) {
        return !existingStack.m_41619_() && ItemStack.m_150942_((ItemStack)existingStack, (ItemStack)stack) && existingStack.m_41753_() && existingStack.m_41613_() < existingStack.m_41741_() && existingStack.m_41613_() < this.m_6893_();
    }

    public int getEmptySlot() {
        for (int i = 0; i < this.main.size(); ++i) {
            if (!((ItemStack)this.main.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public void addPickBlock(ItemStack stack) {
        int i = this.getSlotWithStack(stack);
        if (LivingEntityInventory.isValidHotbarIndex(i)) {
            this.selectedSlot = i;
        } else if (i == -1) {
            int j;
            this.selectedSlot = this.getSwappableHotbarSlot();
            if (!((ItemStack)this.main.get(this.selectedSlot)).m_41619_() && (j = this.getEmptySlot()) != -1) {
                this.main.set(j, (Object)((ItemStack)this.main.get(this.selectedSlot)));
            }
            this.main.set(this.selectedSlot, (Object)stack);
        } else {
            this.swapSlotWithHotbar(i);
        }
    }

    public void swapSlotWithHotbar(int slot) {
        this.selectedSlot = this.getSwappableHotbarSlot();
        ItemStack itemStack = (ItemStack)this.main.get(this.selectedSlot);
        this.main.set(this.selectedSlot, (Object)((ItemStack)this.main.get(slot)));
        this.main.set(slot, (Object)itemStack);
    }

    public static boolean isValidHotbarIndex(int slot) {
        return slot >= 0 && slot < 9;
    }

    public int getSlotWithStack(ItemStack stack) {
        for (int i = 0; i < this.main.size(); ++i) {
            if (((ItemStack)this.main.get(i)).m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)this.main.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(ItemStack stack) {
        for (int i = 0; i < this.main.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.main.get(i);
            if (((ItemStack)this.main.get(i)).m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)this.main.get(i))) || ((ItemStack)this.main.get(i)).m_41768_() || itemStack.m_41793_() || itemStack.m_41788_()) continue;
            return i;
        }
        return -1;
    }

    public int getSwappableHotbarSlot() {
        int j;
        for (int i = 0; i < 9; ++i) {
            j = (this.selectedSlot + i) % 9;
            if (!((ItemStack)this.main.get(j)).m_41619_()) continue;
            return j;
        }
        for (int ix = 0; ix < 9; ++ix) {
            j = (this.selectedSlot + ix) % 9;
            if (((ItemStack)this.main.get(j)).m_41793_()) continue;
            return j;
        }
        return this.selectedSlot;
    }

    public void scrollInHotbar(double scrollAmount) {
        int i = (int)Math.signum(scrollAmount);
        this.selectedSlot -= i;
        while (this.selectedSlot < 0) {
            this.selectedSlot += 9;
        }
        while (this.selectedSlot >= 9) {
            this.selectedSlot -= 9;
        }
    }

    public int remove(Predicate<ItemStack> shouldRemove, int maxCount, Container craftingInventory) {
        int i = 0;
        boolean bl = maxCount == 0;
        i += ContainerHelper.m_18956_((Container)this, shouldRemove, (int)(maxCount - i), (boolean)bl);
        return i + ContainerHelper.m_18956_((Container)craftingInventory, shouldRemove, (int)(maxCount - i), (boolean)bl);
    }

    private int addStack(ItemStack stack) {
        int i = this.getOccupiedSlotWithRoomForStack(stack);
        if (i == -1) {
            i = this.getEmptySlot();
        }
        return i == -1 ? stack.m_41613_() : this.addStack(i, stack);
    }

    private int addStack(int slot, ItemStack stack) {
        Item item = stack.m_41720_();
        int i = stack.m_41613_();
        ItemStack itemStack = this.m_8020_(slot);
        if (itemStack.m_41619_()) {
            itemStack = new ItemStack((ItemLike)item, 0);
            if (stack.m_41782_()) {
                itemStack.m_41751_(stack.m_41783_().m_6426_());
            }
            this.m_6836_(slot, itemStack);
        }
        int j = i;
        if (i > itemStack.m_41741_() - itemStack.m_41613_()) {
            j = itemStack.m_41741_() - itemStack.m_41613_();
        }
        if (j > this.m_6893_() - itemStack.m_41613_()) {
            j = this.m_6893_() - itemStack.m_41613_();
        }
        if (j == 0) {
            return i;
        }
        itemStack.m_41769_(j);
        itemStack.m_41754_(5);
        return i -= j;
    }

    public int getOccupiedSlotWithRoomForStack(ItemStack stack) {
        if (this.canStackAddMore(this.m_8020_(this.selectedSlot), stack)) {
            return this.selectedSlot;
        }
        if (this.canStackAddMore(this.m_8020_(40), stack)) {
            return 40;
        }
        for (int i = 0; i < this.main.size(); ++i) {
            if (!this.canStackAddMore((ItemStack)this.main.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    public void updateItems() {
        for (NonNullList<ItemStack> defaultedList : this.combinedInventory) {
            for (int i = 0; i < defaultedList.size(); ++i) {
                if (((ItemStack)defaultedList.get(i)).m_41619_()) continue;
                ((ItemStack)defaultedList.get(i)).m_41666_(this.player.m_9236_(), (Entity)this.player, i, this.selectedSlot == i);
            }
        }
    }

    public boolean insertStack(ItemStack stack) {
        return this.insertStack(-1, stack);
    }

    public boolean insertStack(int slot, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        try {
            int i;
            if (stack.m_41768_()) {
                if (slot == -1) {
                    slot = this.getEmptySlot();
                }
                if (slot >= 0) {
                    this.main.set(slot, (Object)stack.m_278832_());
                    ((ItemStack)this.main.get(slot)).m_41754_(5);
                    return true;
                }
                return false;
            }
            do {
                i = stack.m_41613_();
                if (slot == -1) {
                    stack.m_41764_(this.addStack(stack));
                    continue;
                }
                stack.m_41764_(this.addStack(slot, stack));
            } while (!stack.m_41619_() && stack.m_41613_() < i);
            return stack.m_41613_() < i;
        }
        catch (Throwable var6) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)var6, (String)"Adding item to inventory");
            CrashReportCategory crashReportSection = crashReport.m_127514_("Item being added");
            crashReportSection.m_128159_("Item ID", (Object)Item.m_41393_((Item)stack.m_41720_()));
            crashReportSection.m_128159_("Item data", (Object)stack.m_41773_());
            crashReportSection.m_128165_("Item name", () -> stack.m_41786_().getString());
            throw new ReportedException(crashReport);
        }
    }

    public ItemStack m_7407_(int slot, int amount) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> defaultedList : this.combinedInventory) {
            if (slot < defaultedList.size()) {
                list = defaultedList;
                break;
            }
            slot -= defaultedList.size();
        }
        return list != null && !((ItemStack)list.get(slot)).m_41619_() ? ContainerHelper.m_18969_(list, (int)slot, (int)amount) : ItemStack.f_41583_;
    }

    public void removeOne(ItemStack stack) {
        block0: for (NonNullList<ItemStack> defaultedList : this.combinedInventory) {
            for (int i = 0; i < defaultedList.size(); ++i) {
                if (defaultedList.get(i) != stack) continue;
                defaultedList.set(i, (Object)ItemStack.f_41583_);
                continue block0;
            }
        }
    }

    public ItemStack m_8016_(int slot) {
        NonNullList<ItemStack> defaultedList = null;
        for (NonNullList<ItemStack> defaultedList2 : this.combinedInventory) {
            if (slot < defaultedList2.size()) {
                defaultedList = defaultedList2;
                break;
            }
            slot -= defaultedList2.size();
        }
        if (defaultedList != null && !((ItemStack)defaultedList.get(slot)).m_41619_()) {
            ItemStack itemStack = (ItemStack)defaultedList.get(slot);
            defaultedList.set(slot, (Object)ItemStack.f_41583_);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, ItemStack stack) {
        NonNullList<ItemStack> defaultedList = null;
        for (NonNullList<ItemStack> defaultedList2 : this.combinedInventory) {
            if (slot < defaultedList2.size()) {
                defaultedList = defaultedList2;
                break;
            }
            slot -= defaultedList2.size();
        }
        if (defaultedList != null) {
            defaultedList.set(slot, (Object)stack);
        }
    }

    public float getBlockBreakingSpeed(BlockState block) {
        return ((ItemStack)this.main.get(this.selectedSlot)).m_41691_(block);
    }

    public ListTag writeNbt(ListTag nbtList) {
        CompoundTag nbtCompound;
        for (int i = 0; i < this.main.size(); ++i) {
            if (((ItemStack)this.main.get(i)).m_41619_()) continue;
            nbtCompound = new CompoundTag();
            nbtCompound.m_128344_("Slot", (byte)i);
            ((ItemStack)this.main.get(i)).m_41739_(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        for (int ix = 0; ix < this.armor.size(); ++ix) {
            if (((ItemStack)this.armor.get(ix)).m_41619_()) continue;
            nbtCompound = new CompoundTag();
            nbtCompound.m_128344_("Slot", (byte)(ix + 100));
            ((ItemStack)this.armor.get(ix)).m_41739_(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        for (int ixx = 0; ixx < this.offHand.size(); ++ixx) {
            if (((ItemStack)this.offHand.get(ixx)).m_41619_()) continue;
            nbtCompound = new CompoundTag();
            nbtCompound.m_128344_("Slot", (byte)(ixx + 150));
            ((ItemStack)this.offHand.get(ixx)).m_41739_(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        return nbtList;
    }

    public void readNbt(ListTag nbtList) {
        this.main.clear();
        this.armor.clear();
        this.offHand.clear();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            int j = nbtCompound.m_128445_("Slot") & 0xFF;
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)nbtCompound);
            if (itemStack.m_41619_()) continue;
            if (j >= 0 && j < this.main.size()) {
                this.main.set(j, (Object)itemStack);
                continue;
            }
            if (j >= 100 && j < this.armor.size() + 100) {
                this.armor.set(j - 100, (Object)itemStack);
                continue;
            }
            if (j < 150 || j >= this.offHand.size() + 150) continue;
            this.offHand.set(j - 150, (Object)itemStack);
        }
    }

    public int m_6643_() {
        return this.main.size() + this.armor.size() + this.offHand.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.main) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        for (ItemStack itemStackx : this.armor) {
            if (itemStackx.m_41619_()) continue;
            return false;
        }
        for (ItemStack itemStackxx : this.offHand) {
            if (itemStackxx.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> defaultedList : this.combinedInventory) {
            if (slot < defaultedList.size()) {
                list = defaultedList;
                break;
            }
            slot -= defaultedList.size();
        }
        return list == null ? ItemStack.f_41583_ : (ItemStack)list.get(slot);
    }

    public Component m_7755_() {
        return Component.m_237115_((String)"container.inventory");
    }

    public ItemStack getArmorStack(int slot) {
        return (ItemStack)this.armor.get(slot);
    }

    public void damageArmor(DamageSource damageSource, float amount, int[] slots) {
        if (!(amount <= 0.0f)) {
            if ((amount /= 4.0f) < 1.0f) {
                amount = 1.0f;
            }
            for (int i : slots) {
                ItemStack itemStack = (ItemStack)this.armor.get(i);
                if (damageSource.m_269533_(DamageTypeTags.f_268745_) && itemStack.m_41720_().m_41475_() || !(itemStack.m_41720_() instanceof ArmorItem)) continue;
                itemStack.m_41622_((int)amount, this.player, player -> player.m_21166_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i)));
            }
        }
    }

    public void dropAll() {
        for (List list : this.combinedInventory) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemStack = (ItemStack)list.get(i);
                if (itemStack.m_41619_()) continue;
                this.player.m_19983_(itemStack);
                list.set(i, ItemStack.f_41583_);
            }
        }
    }

    public void m_6596_() {
        ++this.changeCount;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public boolean m_6542_(Player player) {
        return this.player.m_213877_() ? false : !(player.m_20280_((Entity)this.player) > 64.0);
    }

    public boolean contains(ItemStack stack) {
        for (List list : this.combinedInventory) {
            for (ItemStack itemStack : list) {
                if (itemStack.m_41619_() || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(TagKey<Item> key) {
        for (List list : this.combinedInventory) {
            for (ItemStack itemStack : list) {
                if (itemStack.m_41619_() || !itemStack.m_204117_(key)) continue;
                return true;
            }
        }
        return false;
    }

    public void clone(LivingEntityInventory other) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.m_6836_(i, other.m_8020_(i));
        }
        this.selectedSlot = other.selectedSlot;
    }

    public void m_6211_() {
        for (List list : this.combinedInventory) {
            list.clear();
        }
    }

    public void populateRecipeFinder(StackedContents finder) {
        for (ItemStack itemStack : this.main) {
            finder.m_36466_(itemStack);
        }
    }

    public ItemStack dropSelectedItem(boolean entireStack) {
        ItemStack itemStack = this.getMainHandStack();
        return itemStack.m_41619_() ? ItemStack.f_41583_ : this.m_7407_(this.selectedSlot, entireStack ? itemStack.m_41613_() : 1);
    }
}

