/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.utils;

import com.player2.playerengine.automaton.api.utils.SettingsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;

public final class BetterBlockPos
extends BlockPos {
    public static final BetterBlockPos ORIGIN = new BetterBlockPos(0, 0, 0);
    public final int x;
    public final int y;
    public final int z;

    public BetterBlockPos(int x, int y, int z) {
        super(x, y, z);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BetterBlockPos(double x, double y, double z) {
        this(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
    }

    public BetterBlockPos(BlockPos pos) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static BetterBlockPos from(BlockPos pos) {
        return pos == null ? null : new BetterBlockPos(pos);
    }

    public int hashCode() {
        return (int)BetterBlockPos.longHash(this.x, this.y, this.z);
    }

    public static long longHash(BetterBlockPos pos) {
        return BetterBlockPos.longHash(pos.x, pos.y, pos.z);
    }

    public static long longHash(int x, int y, int z) {
        long hash = 3241L;
        hash = 3457689L * hash + (long)x;
        hash = 8734625L * hash + (long)y;
        return 2873465L * hash + (long)z;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof BetterBlockPos) {
            BetterBlockPos oth = (BetterBlockPos)((Object)o);
            return oth.x == this.x && oth.y == this.y && oth.z == this.z;
        }
        BlockPos oth = (BlockPos)o;
        return oth.m_123341_() == this.x && oth.m_123342_() == this.y && oth.m_123343_() == this.z;
    }

    public BetterBlockPos up() {
        return new BetterBlockPos(this.x, this.y + 1, this.z);
    }

    public BetterBlockPos up(int amt) {
        return amt == 0 ? this : new BetterBlockPos(this.x, this.y + amt, this.z);
    }

    public BetterBlockPos down() {
        return new BetterBlockPos(this.x, this.y - 1, this.z);
    }

    public BetterBlockPos down(int amt) {
        return amt == 0 ? this : new BetterBlockPos(this.x, this.y - amt, this.z);
    }

    public BetterBlockPos offset(Direction dir) {
        Vec3i vec = dir.m_122436_();
        return new BetterBlockPos(this.x + vec.m_123341_(), this.y + vec.m_123342_(), this.z + vec.m_123343_());
    }

    public BetterBlockPos offset(Direction dir, int dist) {
        if (dist == 0) {
            return this;
        }
        Vec3i vec = dir.m_122436_();
        return new BetterBlockPos(this.x + vec.m_123341_() * dist, this.y + vec.m_123342_() * dist, this.z + vec.m_123343_() * dist);
    }

    public BetterBlockPos north() {
        return new BetterBlockPos(this.x, this.y, this.z - 1);
    }

    public BetterBlockPos north(int amt) {
        return amt == 0 ? this : new BetterBlockPos(this.x, this.y, this.z - amt);
    }

    public BetterBlockPos south() {
        return new BetterBlockPos(this.x, this.y, this.z + 1);
    }

    public BetterBlockPos south(int amt) {
        return amt == 0 ? this : new BetterBlockPos(this.x, this.y, this.z + amt);
    }

    public BetterBlockPos east() {
        return new BetterBlockPos(this.x + 1, this.y, this.z);
    }

    public BetterBlockPos east(int amt) {
        return amt == 0 ? this : new BetterBlockPos(this.x + amt, this.y, this.z);
    }

    public BetterBlockPos west() {
        return new BetterBlockPos(this.x - 1, this.y, this.z);
    }

    public BetterBlockPos west(int amt) {
        return amt == 0 ? this : new BetterBlockPos(this.x - amt, this.y, this.z);
    }

    public String toString() {
        return String.format("BetterBlockPos{x=%s,y=%s,z=%s}", SettingsUtil.maybeCensor(this.x), SettingsUtil.maybeCensor(this.y), SettingsUtil.maybeCensor(this.z));
    }
}

