/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils;

import com.player2.playerengine.automaton.api.utils.IEntityContext;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public final class BlockBreakHelper {
    private final IEntityContext ctx;
    @Nullable
    private BlockPos lastPos;

    BlockBreakHelper(IEntityContext ctx) {
        this.ctx = ctx;
    }

    public void stopBreakingBlock() {
        if (this.ctx.entity() != null && this.lastPos != null) {
            if (!this.ctx.playerController().hasBrokenBlock()) {
                this.ctx.playerController().setHittingBlock(true);
            }
            this.ctx.playerController().resetBlockRemoving();
            this.lastPos = null;
        }
    }

    public void tick(boolean isLeftClick) {
        boolean isBlockTrace;
        HitResult trace = this.ctx.objectMouseOver();
        boolean bl = isBlockTrace = trace != null && trace.m_6662_() == HitResult.Type.BLOCK;
        if (isLeftClick && isBlockTrace) {
            BlockPos pos = ((BlockHitResult)trace).m_82425_();
            if (!Objects.equals(this.lastPos, pos)) {
                this.ctx.playerController().clickBlock(pos, ((BlockHitResult)trace).m_82434_());
                this.ctx.entity().m_6674_(InteractionHand.MAIN_HAND);
            }
            if (this.ctx.playerController().onPlayerDamageBlock(pos, ((BlockHitResult)trace).m_82434_())) {
                this.ctx.entity().m_6674_(InteractionHand.MAIN_HAND);
            }
            this.ctx.playerController().setHittingBlock(false);
            this.lastPos = pos;
        } else if (this.lastPos != null) {
            this.stopBreakingBlock();
            this.lastPos = null;
        }
    }
}

