/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils;

import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.utils.BlockStateInterfaceAccessWrapper;
import com.player2.playerengine.automaton.utils.accessor.ServerChunkManagerAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class BlockStateInterface {
    private final ServerChunkManagerAccessor provider;
    protected final BlockGetter world;
    public final BlockPos.MutableBlockPos isPassableBlockPos;
    public final BlockGetter access;
    private LevelChunk prev = null;
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();

    public BlockStateInterface(IEntityContext ctx) {
        this((Level)ctx.world());
    }

    public BlockStateInterface(Level world) {
        this.world = world;
        this.provider = (ServerChunkManagerAccessor)world.m_7726_();
        this.isPassableBlockPos = new BlockPos.MutableBlockPos();
        this.access = new BlockStateInterfaceAccessWrapper(this);
    }

    public boolean worldContainsLoadedChunk(int blockX, int blockZ) {
        return this.provider.automatone$getChunkNow(blockX >> 4, blockZ >> 4) != null;
    }

    public static Block getBlock(IEntityContext ctx, BlockPos pos) {
        return BlockStateInterface.get(ctx, pos).m_60734_();
    }

    public static BlockState get(IEntityContext ctx, BlockPos pos) {
        return ctx.world().m_8055_(pos);
    }

    public BlockState get0(BlockPos pos) {
        return this.get0(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public BlockState get0(int x, int y, int z) {
        if (this.world.m_151562_(y)) {
            return AIR;
        }
        LevelChunk cached = this.prev;
        if (cached != null && cached.m_7697_().f_45578_ == x >> 4 && cached.m_7697_().f_45579_ == z >> 4) {
            return BlockStateInterface.getFromChunk(this.world, (ChunkAccess)cached, x, y, z);
        }
        LevelChunk chunk = this.provider.automatone$getChunkNow(x >> 4, z >> 4);
        if (chunk != null && !chunk.m_6430_()) {
            this.prev = chunk;
            return BlockStateInterface.getFromChunk(this.world, (ChunkAccess)chunk, x, y, z);
        }
        return AIR;
    }

    public boolean isLoaded(int x, int z) {
        LevelChunk prevChunk = this.prev;
        if (prevChunk != null && prevChunk.m_7697_().f_45578_ == x >> 4 && prevChunk.m_7697_().f_45579_ == z >> 4) {
            return true;
        }
        prevChunk = this.provider.automatone$getChunkNow(x >> 4, z >> 4);
        if (prevChunk != null && !prevChunk.m_6430_()) {
            this.prev = prevChunk;
            return true;
        }
        return false;
    }

    public static BlockState getFromChunk(BlockGetter world, ChunkAccess chunk, int x, int y, int z) {
        LevelChunkSection section = chunk.m_7103_()[world.m_151564_(y)];
        return section.m_188008_() ? AIR : section.m_62982_(x & 0xF, y & 0xF, z & 0xF);
    }
}

