/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils;

import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.utils.IInputOverrideHandler;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.behavior.Behavior;
import com.player2.playerengine.automaton.utils.BlockBreakHelper;
import com.player2.playerengine.automaton.utils.BlockPlaceHelper;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;

public final class InputOverrideHandler
extends Behavior
implements IInputOverrideHandler {
    private final Set<Input> inputForceStateMap = EnumSet.noneOf(Input.class);
    private final BlockBreakHelper blockBreakHelper;
    private final BlockPlaceHelper blockPlaceHelper;
    private boolean needsUpdate;

    public InputOverrideHandler(Baritone baritone) {
        super(baritone);
        this.blockBreakHelper = new BlockBreakHelper(baritone.getEntityContext());
        this.blockPlaceHelper = new BlockPlaceHelper(baritone.getEntityContext());
    }

    @Override
    public final synchronized boolean isInputForcedDown(Input input) {
        return input != null && this.inputForceStateMap.contains((Object)input);
    }

    @Override
    public final synchronized void setInputForceState(Input input, boolean forced) {
        if (forced) {
            this.inputForceStateMap.add(input);
        } else {
            this.inputForceStateMap.remove((Object)input);
        }
        this.needsUpdate = true;
    }

    @Override
    public final synchronized void clearAllKeys() {
        if (this.ctx.entity().m_20142_()) {
            this.ctx.entity().m_6858_(false);
        }
        this.inputForceStateMap.clear();
        this.needsUpdate = true;
    }

    @Override
    public final void onTickServer() {
        if (this.needsUpdate) {
            if (this.isInputForcedDown(Input.CLICK_LEFT)) {
                this.setInputForceState(Input.CLICK_RIGHT, false);
            }
            LivingEntity entity = this.ctx.entity();
            entity.f_20900_ = 0.0f;
            entity.f_20902_ = 0.0f;
            entity.m_20260_(false);
            entity.m_6862_(this.isInputForcedDown(Input.JUMP));
            float speed = 0.3f;
            if (this.isInputForcedDown(Input.MOVE_FORWARD)) {
                entity.f_20902_ += speed;
            }
            if (this.isInputForcedDown(Input.MOVE_BACK)) {
                entity.f_20902_ -= speed;
            }
            if (this.isInputForcedDown(Input.MOVE_LEFT)) {
                entity.f_20900_ += speed;
            }
            if (this.isInputForcedDown(Input.MOVE_RIGHT)) {
                entity.f_20900_ -= speed;
            }
            if (this.isInputForcedDown(Input.SNEAK)) {
                entity.m_20260_(true);
                entity.f_20900_ = (float)((double)entity.f_20900_ * 0.3);
                entity.f_20902_ = (float)((double)entity.f_20902_ * 0.3);
            }
            this.blockBreakHelper.tick(this.isInputForcedDown(Input.CLICK_LEFT));
            this.blockPlaceHelper.tick(this.isInputForcedDown(Input.CLICK_RIGHT));
            this.needsUpdate = false;
        }
    }

    public BlockBreakHelper getBlockBreakHelper() {
        return this.blockBreakHelper;
    }
}

