/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils.schematic.format.defaults;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.utils.schematic.StaticSchematic;
import com.player2.playerengine.automaton.utils.type.VarInt;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class SpongeSchematic
extends StaticSchematic {
    public SpongeSchematic(CompoundTag nbt) {
        this.x = nbt.m_128451_("Width");
        this.y = nbt.m_128451_("Height");
        this.z = nbt.m_128451_("Length");
        this.states = new BlockState[this.x][this.z][this.y];
        Int2ObjectArrayMap palette = new Int2ObjectArrayMap();
        CompoundTag paletteTag = nbt.m_128469_("Palette");
        for (String tag : paletteTag.m_128431_()) {
            int index = paletteTag.m_128451_(tag);
            SerializedBlockState serializedState = SerializedBlockState.getFromString(tag);
            if (serializedState == null) {
                throw new IllegalArgumentException("Unable to parse palette tag");
            }
            BlockState state = serializedState.deserialize();
            if (state == null) {
                throw new IllegalArgumentException("Unable to deserialize palette tag");
            }
            palette.put(index, (Object)state);
        }
        byte[] rawBlockData = nbt.m_128463_("BlockData");
        int[] blockData = new int[this.x * this.y * this.z];
        int offset = 0;
        for (int i = 0; i < blockData.length; ++i) {
            if (offset >= rawBlockData.length) {
                throw new IllegalArgumentException("No remaining bytes in BlockData for complete schematic");
            }
            VarInt varInt = VarInt.read(rawBlockData, offset);
            blockData[i] = varInt.getValue();
            offset += varInt.getSize();
        }
        for (int y = 0; y < this.y; ++y) {
            for (int z = 0; z < this.z; ++z) {
                for (int x = 0; x < this.x; ++x) {
                    int indexx = (y * this.z + z) * this.x + x;
                    BlockState state = (BlockState)palette.get(blockData[indexx]);
                    if (state == null) {
                        throw new IllegalArgumentException("Invalid Palette Index " + indexx);
                    }
                    this.states[x][z][y] = state;
                }
            }
        }
    }

    private static final class SerializedBlockState {
        private static final Pattern REGEX = Pattern.compile("(?<location>(\\w+:)?\\w+)(\\[(?<properties>(\\w+=\\w+,?)+)])?");
        private final ResourceLocation resourceLocation;
        private final Map<String, String> properties;
        private BlockState blockState;

        private SerializedBlockState(ResourceLocation resourceLocation, Map<String, String> properties) {
            this.resourceLocation = resourceLocation;
            this.properties = properties;
        }

        private BlockState deserialize() {
            if (this.blockState == null) {
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(this.resourceLocation);
                this.blockState = block.m_49966_();
                this.properties.keySet().stream().sorted(String::compareTo).forEachOrdered(key -> {
                    Property property = block.m_49965_().m_61081_(key);
                    if (property != null) {
                        this.blockState = SerializedBlockState.setPropertyValue(this.blockState, property, this.properties.get(key));
                    }
                });
            }
            return this.blockState;
        }

        private static SerializedBlockState getFromString(String s) {
            Matcher m = REGEX.matcher(s);
            if (!m.matches()) {
                return null;
            }
            try {
                String location = m.group("location");
                String properties = m.group("properties");
                ResourceLocation resourceLocation = new ResourceLocation(location);
                HashMap<String, String> propertiesMap = new HashMap<String, String>();
                if (properties != null) {
                    for (String property : properties.split(",")) {
                        String[] split = property.split("=");
                        propertiesMap.put(split[0], split[1]);
                    }
                }
                return new SerializedBlockState(resourceLocation, propertiesMap);
            }
            catch (Exception var11) {
                PlayerEngine.LOGGER.error((Object)var11);
                return null;
            }
        }

        private static <T extends Comparable<T>> BlockState setPropertyValue(BlockState state, Property<T> property, String value) {
            Optional parsed = property.m_6215_(value);
            if (parsed.isPresent()) {
                return (BlockState)state.m_61124_(property, (Comparable)parsed.get());
            }
            throw new IllegalArgumentException("Invalid value for property " + String.valueOf(property));
        }
    }
}

