/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.control;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.slots.PlayerSlot;
import com.player2.playerengine.util.slots.Slot;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.EmptyMapItem;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TieredItem;

public class SlotHandler {
    private final PlayerEngineController controller;
    private ItemStack cursorStack = ItemStack.f_41583_;

    public SlotHandler(PlayerEngineController controller) {
        this.controller = controller;
    }

    public ItemStack getCursorStack() {
        return this.cursorStack;
    }

    public void setCursorStack(ItemStack stack) {
        this.cursorStack = stack != null && !stack.m_41619_() ? stack : ItemStack.f_41583_;
    }

    public boolean canDoSlotAction() {
        return true;
    }

    public void registerSlotAction() {
        this.controller.getItemStorage().registerSlotAction();
    }

    public void clickSlot(Slot slot, int mouseButton, ClickType type) {
        if (slot != null && !slot.equals(Slot.UNDEFINED)) {
            NonNullList<ItemStack> inventory = slot.getInventory();
            int index = slot.getIndex();
            if (inventory == null) {
                Debug.logWarning("Attempt to click a slot without an inventory: " + String.valueOf(slot));
            } else {
                ItemStack slotStack = (ItemStack)inventory.get(index);
                switch (type) {
                    case PICKUP: {
                        ItemStack temp = this.cursorStack;
                        this.setCursorStack(slotStack);
                        inventory.set(index, (Object)temp);
                        break;
                    }
                    case QUICK_MOVE: {
                        Debug.logError("QUICK_MOVE is NYI.");
                        break;
                    }
                    default: {
                        Debug.logWarning("Unsupported SlotActionType: " + String.valueOf(type));
                    }
                }
                this.registerSlotAction();
            }
        } else if (!this.cursorStack.m_41619_()) {
            this.controller.getEntity().m_19983_(this.cursorStack.m_41777_());
            this.setCursorStack(ItemStack.f_41583_);
            this.registerSlotAction();
        }
    }

    public void forceEquipItemToOffhand(Item toEquip) {
        LivingEntityInventory inventory = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        ItemStack offhandStack = inventory.m_8020_(0);
        if (!offhandStack.m_150930_(toEquip)) {
            for (int i = 0; i < inventory.main.size(); ++i) {
                ItemStack potential = (ItemStack)inventory.main.get(i);
                if (!potential.m_150930_(toEquip)) continue;
                inventory.m_6836_(0, potential);
                inventory.main.set(i, (Object)offhandStack);
                this.registerSlotAction();
                return;
            }
        }
    }

    public boolean forceEquipItem(Item[] toEquip) {
        int finalI;
        LivingEntityInventory inventory = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        if (Arrays.stream(toEquip).allMatch(ix -> ix == inventory.getMainHandStack().m_41720_())) {
            return true;
        }
        int i = 0;
        while (i < 9) {
            finalI = i++;
            if (!Arrays.stream(toEquip).allMatch(it -> it == inventory.m_8020_(finalI).m_41720_())) continue;
            inventory.selectedSlot = i;
            this.registerSlotAction();
            return true;
        }
        int ix2 = 9;
        while (ix2 < inventory.main.size()) {
            finalI = ix2++;
            if (!Arrays.stream(toEquip).allMatch(it -> it == inventory.m_8020_(finalI).m_41720_())) continue;
            ItemStack handStack = inventory.getMainHandStack();
            inventory.m_6836_(inventory.selectedSlot, inventory.m_8020_(ix2));
            inventory.m_6836_(ix2, handStack);
            this.registerSlotAction();
            return true;
        }
        return false;
    }

    public boolean forceEquipItem(Item toEquip) {
        LivingEntityInventory inventory = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        if (inventory.getMainHandStack().m_150930_(toEquip)) {
            return true;
        }
        for (int i = 0; i < 9; ++i) {
            if (!inventory.m_8020_(i).m_150930_(toEquip)) continue;
            inventory.selectedSlot = i;
            this.registerSlotAction();
            return true;
        }
        for (int ix = 9; ix < inventory.main.size(); ++ix) {
            if (!inventory.m_8020_(ix).m_150930_(toEquip)) continue;
            ItemStack handStack = inventory.getMainHandStack();
            inventory.m_6836_(inventory.selectedSlot, inventory.m_8020_(ix));
            inventory.m_6836_(ix, handStack);
            this.registerSlotAction();
            return true;
        }
        return false;
    }

    public boolean forceDeequip(Predicate<ItemStack> isBad) {
        LivingEntityInventory inventory = ((IInventoryProvider)this.controller.getEntity()).getLivingInventory();
        ItemStack equip = inventory.getMainHandStack();
        if (isBad.test(equip)) {
            int emptySlot = inventory.getEmptySlot();
            if (emptySlot != -1) {
                if (LivingEntityInventory.isValidHotbarIndex(emptySlot)) {
                    inventory.selectedSlot = emptySlot;
                } else {
                    inventory.m_6836_(emptySlot, equip);
                    inventory.m_6836_(inventory.selectedSlot, ItemStack.f_41583_);
                }
                this.registerSlotAction();
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean forceDeequipHitTool() {
        return this.forceDeequip(stack -> stack.m_41720_() instanceof TieredItem);
    }

    public boolean forceEquipItem(ItemTarget toEquip, boolean unInterruptable) {
        if (toEquip != null && !toEquip.isEmpty()) {
            if (this.controller.getFoodChain().needsToEat() && !unInterruptable) {
                return false;
            }
            for (Item item : toEquip.getMatches()) {
                if (!this.forceEquipItem(item)) continue;
                return true;
            }
            return false;
        }
        return this.forceDeequip(stack -> !stack.m_41619_());
    }

    public void refreshInventory() {
    }

    public void forceDeequipRightClickableItem() {
        this.forceDeequip(stack -> {
            Item item = stack.m_41720_();
            return item instanceof BucketItem || item instanceof EnderEyeItem || item == Items.f_42411_ || item == Items.f_42717_ || item == Items.f_42409_ || item == Items.f_42613_ || item == Items.f_42584_ || item instanceof FireworkRocketItem || item instanceof SpawnEggItem || item == Items.f_42729_ || item == Items.f_42612_ || item instanceof PotionItem || item == Items.f_42713_ || item == Items.f_42614_ || item == Items.f_42615_ || item instanceof FishingRodItem || item instanceof FoodOnAStickItem || item == Items.f_42522_ || item instanceof EmptyMapItem || item instanceof ArmorItem || item == Items.f_42655_ || item == Items.f_42740_;
        });
    }

    private void swapSlots(Slot slot, Slot target) {
        ItemStack stack = slot.getStack();
        ItemStack targetStack = target.getStack();
        target.getInventory().set(target.getIndex(), (Object)stack);
        slot.getInventory().set(slot.getIndex(), (Object)targetStack);
    }

    public void forceEquipSlot(PlayerEngineController controller, Slot slot) {
        Slot target = PlayerSlot.getEquipSlot(controller.getInventory());
        this.swapSlots(slot, target);
    }

    public void forceEquipArmor(PlayerEngineController controller, ItemTarget target) {
        LivingEntityInventory inventory = ((IInventoryProvider)controller.getEntity()).getLivingInventory();
        block0: for (Item item : target.getMatches()) {
            if (!(item instanceof ArmorItem)) continue;
            ArmorItem armorItem = (ArmorItem)item;
            EquipmentSlot slotType = armorItem.m_266204_().m_266308_();
            if (controller.getEntity().m_6844_(slotType).m_150930_(item)) continue;
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stackInSlot = inventory.m_8020_(i);
                if (!stackInSlot.m_150930_(item)) continue;
                ItemStack currentlyEquipped = controller.getEntity().m_6844_(slotType).m_41777_();
                controller.getEntity().m_8061_(slotType, stackInSlot.m_41777_());
                inventory.m_6836_(i, currentlyEquipped);
                this.registerSlotAction();
                continue block0;
            }
        }
    }
}

