/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.eventbus;

import com.player2.playerengine.eventbus.Subscription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.Tuple;

public class EventBus {
    private static final HashMap<Class, List<Subscription>> topics = new HashMap();
    private static final List<Tuple<Class, Subscription>> toAdd = new ArrayList<Tuple<Class, Subscription>>();
    private static boolean lock;

    public static <T> void publish(T event) {
        Class<?> type = event.getClass();
        for (Tuple<Class, Subscription> toAdd : EventBus.toAdd) {
            EventBus.subscribeInternal((Class)toAdd.m_14418_(), (Subscription)toAdd.m_14419_());
        }
        toAdd.clear();
        if (topics.containsKey(type)) {
            List<Subscription> subscribers = topics.get(type);
            ArrayList<Subscription> toDelete = new ArrayList<Subscription>();
            lock = true;
            for (Subscription subRaw : subscribers) {
                try {
                    if (subRaw.shouldDelete()) {
                        toDelete.add(subRaw);
                        continue;
                    }
                    subRaw.accept(event);
                }
                catch (ClassCastException var7) {
                    System.err.println("TRIED PUBLISHING MISMAPPED EVENT: " + String.valueOf(event));
                    var7.printStackTrace();
                }
            }
            lock = false;
        }
    }

    private static <T> void subscribeInternal(Class<T> type, Subscription<T> sub) {
        if (!topics.containsKey(type)) {
            topics.put(type, new ArrayList());
        }
        topics.get(type).add(sub);
    }

    public static <T> Subscription<T> subscribe(Class<T> type, Consumer<T> consumeEvent) {
        Subscription<T> sub = new Subscription<T>(consumeEvent);
        if (lock) {
            toAdd.add((Tuple<Class, Subscription>)new Tuple(type, sub));
        } else {
            EventBus.subscribeInternal(type, sub);
        }
        return sub;
    }

    public static <T> void unsubscribe(Subscription<T> subscription) {
        if (subscription != null) {
            subscription.delete();
        }
    }
}

