/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api;

import com.google.gson.JsonObject;
import com.player2.playerengine.player2api.ConversationHistory;
import com.player2.playerengine.player2api.Player2APIService;
import com.player2.playerengine.player2api.manager.ConversationManager;
import com.player2.playerengine.player2api.utils.Utils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LLMCompleter {
    private boolean isProcessing = false;
    private final ExecutorService llmThread = Executors.newSingleThreadExecutor();
    private static final Logger LOGGER = LogManager.getLogger();

    private <T> void process(Player2APIService player2apiService, ConversationHistory history, Consumer<T> extOnLLMResponse, Consumer<String> extOnErrMsg, Utils.ThrowingFunction<ConversationHistory, T> completeConversation, boolean isConversation) {
        LOGGER.info("Called completer.process with history={}", (Object)history);
        if (this.isProcessing) {
            LOGGER.warn("Called llmcompleter.process when it was already processing! This should not happen.");
            return;
        }
        if (isConversation) {
            LOGGER.info("Setting conversation lock -> true");
            ConversationManager.Lock.waitingForResponseLock = true;
        }
        this.isProcessing = true;
        Consumer<Object> onLLMResponse = resp -> {
            try {
                extOnLLMResponse.accept(resp);
            }
            catch (Exception e) {
                LOGGER.error("[LLMCompleter/process/onLLMResponse]: Error in external llm resp, errMsg={} llmResp={}", (Object)e.getMessage(), (Object)resp.toString());
            }
            finally {
                LOGGER.info("Done processing, releasing conversation lock and setting this.completer.isprocessing -> false");
                this.isProcessing = false;
                if (isConversation) {
                    LOGGER.info("Setting conversation lock -> false");
                    ConversationManager.Lock.waitingForResponseLock = false;
                }
            }
        };
        Consumer<String> onErrMsg = errMsg -> {
            try {
                extOnErrMsg.accept((String)errMsg);
            }
            catch (Exception e) {
                LOGGER.error("[LLMCompleter/process/onErrMsg]: Error in external onErrmsg, errMsgFromException={} errMsg={}", (Object)e.getMessage(), errMsg);
            }
            finally {
                LOGGER.info("Done processing, releasing conversation lock and setting this.completer.isprocessing -> false");
                this.isProcessing = false;
                if (isConversation) {
                    LOGGER.info("Setting conversation lock -> false");
                    ConversationManager.Lock.waitingForResponseLock = false;
                }
            }
        };
        this.llmThread.submit(() -> {
            try {
                Object response = completeConversation.apply(history);
                LOGGER.info("LLMCompleter returned json={}", response);
                onLLMResponse.accept(response);
            }
            catch (Exception e) {
                onErrMsg.accept(e.getMessage() == null ? "Unknown error from CompleteConversation API" : e.getMessage());
            }
        });
    }

    public void processToJson(Player2APIService player2apiService, ConversationHistory history, Consumer<JsonObject> extOnLLMResponse, Consumer<String> extOnErrMsg, boolean isConversation) {
        this.process(player2apiService, history, extOnLLMResponse, extOnErrMsg, player2apiService::completeConversation, isConversation);
    }

    public void processToString(Player2APIService player2apiService, ConversationHistory history, Consumer<String> extOnLLMResponse, Consumer<String> extOnErrMsg, boolean isConversation) {
        this.process(player2apiService, history, extOnLLMResponse, extOnErrMsg, player2apiService::completeConversationToString, isConversation);
    }

    public boolean isAvailible() {
        return !this.isProcessing;
    }
}

