/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.examples;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.GetToBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ExampleTask2
extends Task {
    private BlockPos target = null;

    @Override
    protected void onStart() {
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().push();
        mod.getBehaviour().avoidBlockBreaking(blockPos -> {
            BlockState s = mod.getWorld().m_8055_(blockPos);
            return s.m_60734_() == Blocks.f_50050_ || s.m_60734_() == Blocks.f_49999_;
        });
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (this.target != null) {
            return new GetToBlockTask(this.target);
        }
        if (!mod.getBlockScanner().anyFound(Blocks.f_49999_)) {
            return new TimeoutWanderTask();
        }
        Optional<BlockPos> nearest = mod.getBlockScanner().getNearestBlock(Blocks.f_49999_);
        if (nearest.isPresent()) {
            BlockPos check = new BlockPos((Vec3i)nearest.get());
            while (mod.getWorld().m_8055_(check).m_60734_() == Blocks.f_49999_ || mod.getWorld().m_8055_(check).m_60734_() == Blocks.f_50050_) {
                check = check.m_7494_();
            }
            this.target = check;
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof ExampleTask2;
    }

    @Override
    public boolean isFinished() {
        return this.target != null ? this.controller.getPlayer().m_20183_().equals((Object)this.target) : super.isFinished();
    }

    @Override
    protected String toDebugString() {
        return "Standing on a tree";
    }
}

