/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.tasks.base.ITaskRequiresGrounded;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.SafeRandomShimmyTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.baritone.GoalFollowEntity;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.progresscheck.MovementProgressChecker;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;

public class GetToEntityTask
extends Task
implements ITaskRequiresGrounded {
    private final MovementProgressChecker stuckCheck = new MovementProgressChecker();
    private final MovementProgressChecker progress = new MovementProgressChecker();
    private final TimeoutWanderTask wanderTask = new TimeoutWanderTask(5.0f);
    private final Entity entity;
    private final double closeEnoughDistance;
    Block[] annoyingBlocks = new Block[]{Blocks.f_50191_, Blocks.f_50694_, Blocks.f_152538_, Blocks.f_152539_, Blocks.f_50704_, Blocks.f_50653_, Blocks.f_50703_, Blocks.f_50155_, Blocks.f_152545_, Blocks.f_152546_, Blocks.f_152547_, Blocks.f_50359_, Blocks.f_50034_, Blocks.f_50685_};
    private Task unstuckTask = null;

    public GetToEntityTask(Entity entity, double closeEnoughDistance) {
        this.entity = entity;
        this.closeEnoughDistance = closeEnoughDistance;
    }

    public GetToEntityTask(Entity entity) {
        this(entity, 1.0);
    }

    private static BlockPos[] generateSides(BlockPos pos) {
        return new BlockPos[]{pos.m_7918_(1, 0, 0), pos.m_7918_(-1, 0, 0), pos.m_7918_(0, 0, 1), pos.m_7918_(0, 0, -1), pos.m_7918_(1, 0, -1), pos.m_7918_(1, 0, 1), pos.m_7918_(-1, 0, -1), pos.m_7918_(-1, 0, 1)};
    }

    private boolean isAnnoying(PlayerEngineController mod, BlockPos pos) {
        Block[] arrayOfBlock;
        int i;
        int b;
        if (this.annoyingBlocks != null && (b = 0) < (i = (arrayOfBlock = this.annoyingBlocks).length)) {
            Block AnnoyingBlocks = arrayOfBlock[b];
            return mod.getWorld().m_8055_(pos).m_60734_() == AnnoyingBlocks || mod.getWorld().m_8055_(pos).m_60734_() instanceof DoorBlock || mod.getWorld().m_8055_(pos).m_60734_() instanceof FenceBlock || mod.getWorld().m_8055_(pos).m_60734_() instanceof FenceGateBlock || mod.getWorld().m_8055_(pos).m_60734_() instanceof FlowerBlock;
        }
        return false;
    }

    private BlockPos stuckInBlock(PlayerEngineController mod) {
        BlockPos[] toCheckHigh;
        BlockPos[] toCheck;
        BlockPos p = mod.getPlayer().m_20183_();
        if (this.isAnnoying(mod, p)) {
            return p;
        }
        if (this.isAnnoying(mod, p.m_7494_())) {
            return p.m_7494_();
        }
        for (BlockPos check : toCheck = GetToEntityTask.generateSides(p)) {
            if (!this.isAnnoying(mod, check)) continue;
            return check;
        }
        for (BlockPos checkx : toCheckHigh = GetToEntityTask.generateSides(p.m_7494_())) {
            if (!this.isAnnoying(mod, checkx)) continue;
            return checkx;
        }
        return null;
    }

    private Task getFenceUnstuckTask() {
        return new SafeRandomShimmyTask();
    }

    @Override
    protected void onStart() {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
        this.progress.reset();
        this.stuckCheck.reset();
        this.wanderTask.resetWander();
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (mod.getBaritone().getPathingBehavior().isPathing()) {
            this.progress.reset();
        }
        if (WorldHelper.isInNetherPortal(this.controller)) {
            if (!mod.getBaritone().getPathingBehavior().isPathing()) {
                this.setDebugState("Getting out from nether portal");
                mod.getInputControls().hold(Input.SNEAK);
                mod.getInputControls().hold(Input.MOVE_FORWARD);
                return null;
            }
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.MOVE_BACK);
            mod.getInputControls().release(Input.MOVE_FORWARD);
        } else if (mod.getBaritone().getPathingBehavior().isPathing()) {
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().release(Input.MOVE_BACK);
            mod.getInputControls().release(Input.MOVE_FORWARD);
        }
        if (this.unstuckTask != null && this.unstuckTask.isActive() && !this.unstuckTask.isFinished() && this.stuckInBlock(mod) != null) {
            this.setDebugState("Getting unstuck from block.");
            this.stuckCheck.reset();
            mod.getBaritone().getCustomGoalProcess().onLostControl();
            mod.getBaritone().getExploreProcess().onLostControl();
            return this.unstuckTask;
        }
        if (!this.progress.check(mod) || !this.stuckCheck.check(mod)) {
            BlockPos blockStuck = this.stuckInBlock(mod);
            if (blockStuck != null) {
                this.unstuckTask = this.getFenceUnstuckTask();
                return this.unstuckTask;
            }
            this.stuckCheck.reset();
        }
        if (this.wanderTask.isActive() && !this.wanderTask.isFinished()) {
            this.progress.reset();
            this.setDebugState("Failed to get to target, wandering for a bit.");
            return this.wanderTask;
        }
        if (!mod.getBaritone().getCustomGoalProcess().isActive()) {
            mod.getBaritone().getCustomGoalProcess().setGoalAndPath(new GoalFollowEntity(this.entity, this.closeEnoughDistance));
        }
        if (mod.getPlayer().m_19950_(this.entity, this.closeEnoughDistance)) {
            this.progress.reset();
        }
        if (!this.progress.check(mod)) {
            return this.wanderTask;
        }
        this.setDebugState("Going to entity");
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBaritone().getPathingBehavior().forceCancel();
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof GetToEntityTask)) {
            bl = false;
        } else {
            GetToEntityTask task = (GetToEntityTask)other;
            bl = task.entity.equals((Object)this.entity) && Math.abs(task.closeEnoughDistance - this.closeEnoughDistance) < 0.1;
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Approach entity " + this.entity.m_6095_().m_20675_();
    }
}

