/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.CustomBaritoneGoalTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.baritone.GoalDirectionXZ;
import net.minecraft.world.phys.Vec3;

public class GoInDirectionXZTask
extends CustomBaritoneGoalTask {
    private final Vec3 origin;
    private final Vec3 delta;
    private final double sidePenalty;

    public GoInDirectionXZTask(Vec3 origin, Vec3 delta, double sidePenalty) {
        this.origin = origin;
        this.delta = delta;
        this.sidePenalty = sidePenalty;
    }

    private static boolean closeEnough(Vec3 a, Vec3 b) {
        return a.m_82557_(b) < 0.001;
    }

    @Override
    protected Goal newGoal(PlayerEngineController mod) {
        try {
            return new GoalDirectionXZ(this.origin, this.delta, this.sidePenalty);
        }
        catch (Exception var3) {
            Debug.logMessage("Invalid goal direction XZ (probably zero distance)");
            return null;
        }
    }

    @Override
    protected boolean isEqual(Task other) {
        boolean bl;
        if (!(other instanceof GoInDirectionXZTask)) {
            bl = false;
        } else {
            GoInDirectionXZTask task = (GoInDirectionXZTask)other;
            bl = GoInDirectionXZTask.closeEnough(task.origin, this.origin) && GoInDirectionXZTask.closeEnough(task.delta, this.delta);
        }
        return bl;
    }

    @Override
    protected String toDebugString() {
        return "Going in direction: <" + this.origin.f_82479_ + "," + this.origin.f_82481_ + "> direction: <" + this.delta.f_82479_ + "," + this.delta.f_82481_ + ">";
    }
}

