/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.movement;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.multiversion.blockpos.BlockPosVer;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.movement.DefaultGoToDimensionTask;
import com.player2.playerengine.tasks.movement.GoInDirectionXZTask;
import com.player2.playerengine.tasks.movement.PickupDroppedItemTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class LocateStrongholdCoordinatesTask
extends Task {
    private static final int EYE_RETHROW_DISTANCE = 10;
    private static final int SECOND_EYE_THROW_DISTANCE = 30;
    private final int targetEyes;
    private final int minimumEyes;
    private final TimerGame throwTimer = new TimerGame(5.0);
    private EyeDirection cachedEyeDirection = null;
    private EyeDirection cachedEyeDirection2 = null;
    private Entity currentThrownEye = null;
    private Vec3i strongholdEstimatePos = null;

    public LocateStrongholdCoordinatesTask(int targetEyes, int minimumEyes) {
        this.targetEyes = targetEyes;
        this.minimumEyes = minimumEyes;
    }

    public LocateStrongholdCoordinatesTask(int targetEyes) {
        this(targetEyes, 12);
    }

    static Vec3i calculateIntersection(Vec3 start1, Vec3 direction1, Vec3 start2, Vec3 direction2) {
        double t2 = (direction1.f_82481_ * start2.f_82479_ - direction1.f_82481_ * start1.f_82479_ - direction1.f_82479_ * start2.f_82481_ + direction1.f_82479_ * start1.f_82481_) / (direction1.f_82479_ * direction2.f_82481_ - direction1.f_82481_ * direction2.f_82479_);
        BlockPos blockPos = BlockPosVer.ofFloored((Position)start2.m_82549_(direction2.m_82490_(t2)));
        return new Vec3i(blockPos.m_123341_(), 0, blockPos.m_123343_());
    }

    @Override
    protected void onStart() {
    }

    public boolean isSearching() {
        return this.cachedEyeDirection != null;
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (WorldHelper.getCurrentDimension(this.controller) != Dimension.OVERWORLD) {
            this.setDebugState("Going to overworld");
            return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
        }
        if (mod.getItemStorage().getItemCount(Items.f_42545_) < this.minimumEyes && mod.getEntityTracker().itemDropped(Items.f_42545_) && !mod.getEntityTracker().entityFound(EyeOfEnder.class)) {
            this.setDebugState("Picking up dropped ender eye.");
            return new PickupDroppedItemTask(Items.f_42545_, this.targetEyes);
        }
        if (mod.getEntityTracker().entityFound(EyeOfEnder.class)) {
            if (this.currentThrownEye == null || !this.currentThrownEye.m_6084_()) {
                Debug.logMessage("New eye direction");
                Debug.logMessage(this.currentThrownEye == null ? "null" : "is not alive");
                List<EyeOfEnder> enderEyes = mod.getEntityTracker().getTrackedEntities(EyeOfEnder.class);
                if (!enderEyes.isEmpty()) {
                    for (EyeOfEnder enderEye : enderEyes) {
                        this.currentThrownEye = enderEye;
                    }
                }
                if (this.cachedEyeDirection2 != null) {
                    this.cachedEyeDirection = null;
                    this.cachedEyeDirection2 = null;
                } else if (this.cachedEyeDirection == null) {
                    this.cachedEyeDirection = new EyeDirection(this.currentThrownEye.m_20182_());
                } else {
                    this.cachedEyeDirection2 = new EyeDirection(this.currentThrownEye.m_20182_());
                }
            }
            if (this.cachedEyeDirection2 != null) {
                this.cachedEyeDirection2.updateEyePos(this.currentThrownEye.m_20182_());
            } else if (this.cachedEyeDirection != null) {
                this.cachedEyeDirection.updateEyePos(this.currentThrownEye.m_20182_());
            }
            if (mod.getEntityTracker().getClosestEntity(EyeOfEnder.class).isPresent() && !mod.getBaritone().getPathingBehavior().isPathing()) {
                LookHelper.lookAt(mod, mod.getEntityTracker().getClosestEntity(EyeOfEnder.class).get().m_146892_());
            }
            this.setDebugState("Waiting for eye to travel.");
            return null;
        }
        if (this.cachedEyeDirection2 != null && !mod.getEntityTracker().entityFound(EyeOfEnder.class) && this.strongholdEstimatePos == null) {
            if (this.cachedEyeDirection2.getAngle() >= this.cachedEyeDirection.getAngle()) {
                Debug.logMessage("2nd eye thrown at wrong position, or points to different stronghold. Rethrowing");
                this.cachedEyeDirection = this.cachedEyeDirection2;
                this.cachedEyeDirection2 = null;
            } else {
                Vec3 throwOrigin = this.cachedEyeDirection.getOrigin();
                Vec3 throwOrigin2 = this.cachedEyeDirection2.getOrigin();
                Vec3 throwDelta = this.cachedEyeDirection.getDelta();
                Vec3 throwDelta2 = this.cachedEyeDirection2.getDelta();
                this.strongholdEstimatePos = LocateStrongholdCoordinatesTask.calculateIntersection(throwOrigin, throwDelta, throwOrigin2, throwDelta2);
                Debug.logMessage("Stronghold is at " + this.strongholdEstimatePos.m_123341_() + ", " + this.strongholdEstimatePos.m_123343_() + " (" + (int)mod.getPlayer().m_20182_().m_82554_(Vec3.m_82528_((Vec3i)this.strongholdEstimatePos)) + " blocks away)");
            }
        }
        if (this.strongholdEstimatePos != null && mod.getPlayer().m_20182_().m_82554_(Vec3.m_82528_((Vec3i)this.strongholdEstimatePos)) < 10.0 && WorldHelper.getCurrentDimension(this.controller) == Dimension.OVERWORLD) {
            this.strongholdEstimatePos = null;
            this.cachedEyeDirection = null;
            this.cachedEyeDirection2 = null;
        }
        if (!mod.getEntityTracker().entityFound(EyeOfEnder.class) && this.strongholdEstimatePos == null) {
            if (WorldHelper.getCurrentDimension(this.controller) == Dimension.NETHER) {
                this.setDebugState("Going to overworld.");
                return new DefaultGoToDimensionTask(Dimension.OVERWORLD);
            }
            if (!mod.getItemStorage().hasItem(Items.f_42545_)) {
                this.setDebugState("Collecting eye of ender.");
                return TaskCatalogue.getItemTask(Items.f_42545_, 1);
            }
            if (this.cachedEyeDirection == null) {
                this.setDebugState("Throwing first eye.");
            } else {
                this.setDebugState("Throwing second eye.");
                double sqDist = mod.getPlayer().m_20238_(this.cachedEyeDirection.getOrigin());
                if (sqDist < 900.0 && this.cachedEyeDirection != null) {
                    return new GoInDirectionXZTask(this.cachedEyeDirection.getOrigin(), this.cachedEyeDirection.getDelta().m_82524_(1.5707964f), 1.0);
                }
            }
            if (mod.getSlotHandler().forceEquipItem(Items.f_42545_)) {
                this.throwEye(this.controller.getWorld(), this.controller.getEntity());
            } else {
                Debug.logWarning("Failed to equip eye of ender to throw.");
            }
            return null;
        }
        if ((this.cachedEyeDirection == null || this.cachedEyeDirection.hasDelta()) && (this.cachedEyeDirection2 == null || this.cachedEyeDirection2.hasDelta())) {
            return null;
        }
        this.setDebugState("Waiting for thrown eye to appear...");
        return null;
    }

    private void throwEye(ServerLevel world, LivingEntity user) {
        BlockPos blockPos = world.m_215011_(StructureTags.f_215882_, user.m_20183_(), 100, false);
        if (blockPos != null) {
            EyeOfEnder eyeOfEnderEntity = new EyeOfEnder((Level)world, user.m_20185_(), user.m_20227_(0.5), user.m_20189_());
            eyeOfEnderEntity.m_36972_(user.m_21205_());
            eyeOfEnderEntity.m_36967_(blockPos);
            world.m_214171_(GameEvent.f_157778_, eyeOfEnderEntity.m_20182_(), GameEvent.Context.m_223717_((Entity)user));
            world.m_7967_((Entity)eyeOfEnderEntity);
            world.m_6263_((Player)null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11898_, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.m_213780_().m_188501_() * 0.4f + 0.8f));
            world.m_5898_((Player)null, 1003, user.m_20183_(), 0);
            user.m_21205_().m_41774_(1);
            user.m_21011_(InteractionHand.MAIN_HAND, true);
        }
    }

    @Override
    protected void onStop(Task interruptTask) {
    }

    public Optional<BlockPos> getStrongholdCoordinates() {
        return this.strongholdEstimatePos == null ? Optional.empty() : Optional.of(new BlockPos(this.strongholdEstimatePos));
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof LocateStrongholdCoordinatesTask;
    }

    @Override
    protected String toDebugString() {
        return "Locating stronghold coordinates";
    }

    @Override
    public boolean isFinished() {
        return this.strongholdEstimatePos != null;
    }

    private static class EyeDirection {
        private final Vec3 start;
        private Vec3 end;

        public EyeDirection(Vec3 startPos) {
            this.start = startPos;
        }

        public void updateEyePos(Vec3 endPos) {
            this.end = endPos;
        }

        public Vec3 getOrigin() {
            return this.start;
        }

        public Vec3 getDelta() {
            return this.end == null ? Vec3.f_82478_ : this.end.m_82546_(this.start);
        }

        public double getAngle() {
            return this.end == null ? 0.0 : Math.atan2(this.getDelta().m_7096_(), this.getDelta().m_7094_());
        }

        public boolean hasDelta() {
            return this.end != null && this.getDelta().m_82556_() > 1.0E-5;
        }
    }
}

