/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.tasks.CraftInInventoryTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.resources.MineAndCollectTask;
import com.player2.playerengine.util.CraftingRecipe;
import com.player2.playerengine.util.Dimension;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.MiningRequirement;
import com.player2.playerengine.util.RecipeTarget;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CollectAmethystBlockTask
extends ResourceTask {
    private final int count;

    public CollectAmethystBlockTask(int targetCount) {
        super(Items.f_150998_, targetCount);
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
        mod.getBehaviour().push();
        mod.getBehaviour().avoidBlockBreaking(blockPos -> {
            BlockState s = mod.getWorld().m_8055_(blockPos);
            return s.m_60734_() == Blocks.f_152491_;
        });
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        if (mod.getItemStorage().getItemCount(Items.f_151049_) >= 4) {
            int target = mod.getItemStorage().getItemCount(Items.f_150998_) + 1;
            ItemTarget s = new ItemTarget(Items.f_151049_, 1);
            return new CraftInInventoryTask(new RecipeTarget(Items.f_150998_, target, CraftingRecipe.newShapedRecipe("amethyst_block", new ItemTarget[]{s, s, s, s}, 1)));
        }
        return new MineAndCollectTask(new ItemTarget(Items.f_150998_, Items.f_151049_), new Block[]{Blocks.f_152490_, Blocks.f_152492_}, MiningRequirement.WOOD).forceDimension(Dimension.OVERWORLD);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
        mod.getBehaviour().pop();
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        return other instanceof CollectAmethystBlockTask;
    }

    @Override
    protected String toDebugStringName() {
        return "Collecting " + this.count + " Amethyst Blocks.";
    }
}

