/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.resources;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.DoToClosestBlockTask;
import com.player2.playerengine.tasks.ResourceTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockNearbyTask;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;

public class CollectFlintTask
extends ResourceTask {
    private static final float CLOSE_ENOUGH_FLINT = 10.0f;
    private final int count;

    public CollectFlintTask(int targetCount) {
        super(Items.f_42484_, targetCount);
        this.count = targetCount;
    }

    @Override
    protected boolean shouldAvoidPickingUp(PlayerEngineController mod) {
        return false;
    }

    @Override
    protected void onResourceStart(PlayerEngineController mod) {
    }

    @Override
    protected Task onResourceTick(PlayerEngineController mod) {
        Optional<BlockPos> closest = mod.getBlockScanner().getNearestBlock(mod.getPlayer().m_20182_(), validGravel -> WorldHelper.fallingBlockSafeToBreak(this.controller, validGravel) && WorldHelper.canBreak(this.controller, validGravel), Blocks.f_49994_);
        if (closest.isPresent() && closest.get().m_203195_((Position)mod.getPlayer().m_20182_(), 10.0)) {
            return new DoToClosestBlockTask(DestroyBlockTask::new, Blocks.f_49994_);
        }
        return mod.getItemStorage().hasItem(Items.f_41832_) ? new PlaceBlockNearbyTask(Blocks.f_49994_) : TaskCatalogue.getItemTask(Items.f_41832_, 1);
    }

    @Override
    protected void onResourceStop(PlayerEngineController mod, Task interruptTask) {
    }

    @Override
    protected boolean isEqualResource(ResourceTask other) {
        boolean bl;
        if (other instanceof CollectFlintTask) {
            CollectFlintTask task = (CollectFlintTask)other;
            bl = task.count == this.count;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    protected String toDebugStringName() {
        return "Collect " + this.count + " flint";
    }
}

