/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.DamageSourceWrapper;
import com.player2.playerengine.multiversion.MethodWrapper;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EntityHelper {
    public static final double ENTITY_GRAVITY = 0.08;

    public static boolean isAngryAtPlayer(PlayerEngineController mod, Entity mob) {
        boolean bl;
        boolean hostile = EntityHelper.isProbablyHostileToPlayer(mod, mob);
        if (!(mob instanceof Mob)) {
            bl = hostile;
        } else {
            Mob entity = (Mob)mob;
            bl = hostile && entity.m_5448_() == mod.getPlayer();
        }
        return bl;
    }

    public static boolean isProbablyHostileToPlayer(PlayerEngineController mod, Entity entity) {
        if (entity instanceof Mob) {
            boolean bl;
            Mob mob = (Mob)entity;
            if (mob instanceof Slime) {
                Slime slime = (Slime)mob;
                return slime.m_21133_(Attributes.f_22281_) > 0.0;
            }
            if (mob instanceof Piglin) {
                Piglin piglin = (Piglin)mob;
                return piglin.m_5912_() && !EntityHelper.isTradingPiglin((Entity)mob) && piglin.m_34667_();
            }
            if (mob instanceof EnderMan) {
                EnderMan enderman = (EnderMan)mob;
                return enderman.m_32531_();
            }
            if (mob instanceof ZombifiedPiglin) {
                ZombifiedPiglin zombifiedPiglin = (ZombifiedPiglin)mob;
                bl = zombifiedPiglin.m_5912_();
            } else {
                bl = mob.m_5912_() || mob instanceof Monster;
            }
            return bl;
        }
        return false;
    }

    public static boolean isTradingPiglin(Entity entity) {
        Piglin pig;
        if (entity instanceof Piglin && (pig = (Piglin)entity).m_6167_() != null) {
            for (ItemStack stack : pig.m_6167_()) {
                if (!stack.m_41720_().equals(Items.f_42417_)) continue;
                return true;
            }
        }
        return false;
    }

    public static double calculateResultingPlayerDamage(LivingEntity player, DamageSource src, double damageAmount) {
        DamageSourceWrapper source = DamageSourceWrapper.of(src);
        if (player.m_6673_(src)) {
            return 0.0;
        }
        if (!source.bypassesArmor()) {
            damageAmount = MethodWrapper.getDamageLeft(player, damageAmount, src, (double)player.m_21230_(), player.m_21133_(Attributes.f_22285_));
        }
        if (!source.bypassesShield()) {
            float k;
            if (player.m_21023_(MobEffects.f_19606_) && source.isOutOfWorld()) {
                k = (player.m_21124_(MobEffects.f_19606_).m_19564_() + 1) * 5;
                float j = 25.0f - k;
                double f = damageAmount * (double)j;
                damageAmount = Math.max(f / 25.0, 0.0);
            }
            if (damageAmount <= 0.0) {
                damageAmount = 0.0;
            } else {
                k = EnchantmentHelper.m_44856_((Iterable)player.m_6168_(), (DamageSource)src);
                if (k > 0.0f) {
                    damageAmount = CombatRules.m_19269_((float)((float)damageAmount), (float)k);
                }
            }
        }
        return Math.max(damageAmount - (double)player.m_6103_(), 0.0);
    }
}

