/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.multiversion.BlockTagVer;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.util.WoodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.material.MapColor;

public class ItemHelper {
    public static final Item[] SAPLINGS = new Item[]{Items.f_42799_, Items.f_42800_, Items.f_42801_, Items.f_41826_, Items.f_41827_, Items.f_41828_, Items.f_220175_, Items.f_271375_};
    public static final Block[] SAPLING_SOURCES = new Block[]{Blocks.f_50050_, Blocks.f_50051_, Blocks.f_50052_, Blocks.f_50053_, Blocks.f_50054_, Blocks.f_50055_, Blocks.f_220831_, Blocks.f_271115_};
    public static final Item[] HOSTILE_MOB_DROPS = new Item[]{Items.f_42585_, Items.f_42402_, Items.f_42581_, Items.f_42582_, Items.f_42583_, Items.f_42681_, Items.f_42403_, Items.f_42682_, Items.f_42747_, Items.f_42616_, Items.f_42485_, Items.f_42486_, Items.f_42454_, Items.f_42542_, Items.f_42714_, Items.f_42412_, Items.f_42450_, Items.f_42748_, Items.f_42500_, Items.f_42678_, Items.f_42518_, Items.f_42401_, Items.f_42591_, Items.f_220194_, Items.f_42590_, Items.f_42525_, Items.f_42451_, Items.f_42398_, Items.f_42501_, Items.f_42589_, Items.f_42686_, Items.f_42413_, Items.f_42679_, Items.f_42586_, Items.f_42416_, Items.f_42619_, Items.f_42620_, Items.f_42674_, Items.f_151052_};
    public static final Item[] DIRTS = new Item[]{Items.f_42329_, Items.f_151032_, Items.f_42382_, Items.f_151064_};
    public static final Item[] PLANKS = new Item[]{Items.f_42795_, Items.f_42753_, Items.f_42797_, Items.f_42796_, Items.f_42647_, Items.f_42794_, Items.f_42700_, Items.f_42798_, Items.f_220174_, Items.f_271154_, Items.f_243694_};
    public static final Item[] LEAVES = new Item[]{Items.f_41900_, Items.f_41898_, Items.f_41901_, Items.f_41896_, Items.f_41899_, Items.f_41897_, Items.f_220178_, Items.f_271517_};
    public static final Item[] WOOD = new Item[]{Items.f_41892_, Items.f_41890_, Items.f_41894_, Items.f_41893_, Items.f_41888_, Items.f_41891_, Items.f_41889_, Items.f_41895_, Items.f_220177_};
    public static final Item[] WOOD_BUTTON = new Item[]{Items.f_42088_, Items.f_42086_, Items.f_42090_, Items.f_42089_, Items.f_42084_, Items.f_42087_, Items.f_42085_, Items.f_42144_, Items.f_220199_, Items.f_244424_, Items.f_271474_};
    public static final Item[] WOOD_SIGN = new Item[]{Items.f_42442_, Items.f_42440_, Items.f_42444_, Items.f_42443_, Items.f_42438_, Items.f_42441_, Items.f_42439_, Items.f_42445_, Items.f_220209_, Items.f_244057_, Items.f_271504_};
    public static final Item[] WOOD_HANGING_SIGN = new Item[]{Items.f_244440_, Items.f_244431_, Items.f_244617_, Items.f_243805_, Items.f_244406_, Items.f_243722_, Items.f_243963_, Items.f_244637_, Items.f_244479_, Items.f_243999_, Items.f_271501_};
    public static final Item[] WOOD_PRESSURE_PLATE = new Item[]{Items.f_41972_, Items.f_41970_, Items.f_41974_, Items.f_41973_, Items.f_41968_, Items.f_41971_, Items.f_41969_, Items.f_41975_, Items.f_220196_, Items.f_244469_, Items.f_271282_};
    public static final Item[] WOOD_FENCE = new Item[]{Items.f_42042_, Items.f_42040_, Items.f_42043_, Items.f_42038_, Items.f_42041_, Items.f_42039_, Items.f_42044_, Items.f_42045_, Items.f_220188_, Items.f_244106_, Items.f_271316_};
    public static final Item[] WOOD_FENCE_GATE = new Item[]{Items.f_42034_, Items.f_42032_, Items.f_42035_, Items.f_42030_, Items.f_42033_, Items.f_42031_, Items.f_42036_, Items.f_42037_, Items.f_220206_, Items.f_244345_, Items.f_271205_};
    public static final Item[] WOOD_BOAT = new Item[]{Items.f_42745_, Items.f_42743_, Items.f_42746_, Items.f_42453_, Items.f_42744_, Items.f_42742_, Items.f_220204_, Items.f_271386_};
    public static final Item[] WOOD_DOOR = new Item[]{Items.f_42346_, Items.f_42344_, Items.f_42348_, Items.f_42347_, Items.f_42342_, Items.f_42345_, Items.f_42343_, Items.f_42349_, Items.f_220197_, Items.f_243820_, Items.f_271459_};
    public static final Item[] WOOD_SLAB = new Item[]{Items.f_41918_, Items.f_41916_, Items.f_41920_, Items.f_41919_, Items.f_41914_, Items.f_41917_, Items.f_41915_, Items.f_41921_, Items.f_220183_, Items.f_243860_, Items.f_271349_};
    public static final Item[] WOOD_STAIRS = new Item[]{Items.f_42202_, Items.f_42112_, Items.f_42114_, Items.f_42203_, Items.f_42008_, Items.f_42113_, Items.f_42111_, Items.f_42115_, Items.f_220189_, Items.f_244189_, Items.f_271397_};
    public static final Item[] WOOD_TRAPDOOR = new Item[]{Items.f_42060_, Items.f_42058_, Items.f_42062_, Items.f_42061_, Items.f_42056_, Items.f_42059_, Items.f_42057_, Items.f_42063_, Items.f_220198_, Items.f_244311_, Items.f_271114_};
    public static final Item[] LOG = new Item[]{Items.f_41841_, Items.f_41839_, Items.f_41842_, Items.f_41837_, Items.f_41840_, Items.f_41838_, Items.f_41892_, Items.f_41890_, Items.f_41893_, Items.f_41888_, Items.f_41891_, Items.f_41889_, Items.f_41849_, Items.f_41847_, Items.f_41850_, Items.f_41845_, Items.f_41848_, Items.f_41846_, Items.f_41884_, Items.f_41882_, Items.f_41885_, Items.f_41880_, Items.f_41883_, Items.f_41881_, Items.f_41843_, Items.f_41844_, Items.f_41894_, Items.f_41895_, Items.f_41851_, Items.f_41879_, Items.f_41886_, Items.f_41887_, Items.f_220179_, Items.f_220177_, Items.f_220182_, Items.f_220176_, Items.f_271090_, Items.f_271302_, Items.f_271164_, Items.f_271182_};
    public static final Item[] STRIPPED_LOGS = new Item[]{Items.f_41849_, Items.f_41847_, Items.f_41850_, Items.f_41845_, Items.f_41848_, Items.f_41846_, Items.f_41851_, Items.f_41879_, Items.f_220182_, Items.f_271164_};
    public static final Item[] STRIPPABLE_LOGS = new Item[]{Items.f_41841_, Items.f_41839_, Items.f_41842_, Items.f_41837_, Items.f_41840_, Items.f_41838_, Items.f_41843_, Items.f_41844_, Items.f_220179_, Items.f_271090_};
    public static final Item[] DYE = new Item[]{Items.f_42535_, Items.f_42498_, Items.f_42494_, Items.f_42495_, Items.f_42492_, Items.f_42490_, Items.f_42496_, Items.f_42538_, Items.f_42491_, Items.f_42540_, Items.f_42537_, Items.f_42536_, Items.f_42489_, Items.f_42493_, Items.f_42497_, Items.f_42539_};
    public static final Item[] WOOL = new Item[]{Items.f_41870_, Items.f_41938_, Items.f_41934_, Items.f_41935_, Items.f_41932_, Items.f_41877_, Items.f_41936_, Items.f_41873_, Items.f_41878_, Items.f_41875_, Items.f_41872_, Items.f_41871_, Items.f_41876_, Items.f_41933_, Items.f_41937_, Items.f_41874_};
    public static final Item[] BED = new Item[]{Items.f_42503_, Items.f_42571_, Items.f_42514_, Items.f_42568_, Items.f_42512_, Items.f_42510_, Items.f_42569_, Items.f_42506_, Items.f_42511_, Items.f_42508_, Items.f_42505_, Items.f_42504_, Items.f_42509_, Items.f_42513_, Items.f_42570_, Items.f_42507_};
    public static final Item[] CARPET = new Item[]{Items.f_42130_, Items.f_42198_, Items.f_42141_, Items.f_42142_, Items.f_42139_, Items.f_42137_, Items.f_42143_, Items.f_42133_, Items.f_42138_, Items.f_42135_, Items.f_42132_, Items.f_42131_, Items.f_42136_, Items.f_42140_, Items.f_42197_, Items.f_42134_};
    public static final Item[] SHULKER_BOXES = new Item[]{Items.f_42266_, Items.f_42229_, Items.f_42225_, Items.f_42226_, Items.f_42275_, Items.f_42273_, Items.f_42227_, Items.f_42269_, Items.f_42274_, Items.f_42271_, Items.f_42268_, Items.f_42267_, Items.f_42272_, Items.f_42224_, Items.f_42228_, Items.f_42270_};
    public static final Item[] FLOWER = new Item[]{Items.f_41942_, Items.f_41943_, Items.f_41941_, Items.f_41949_, Items.f_41939_, Items.f_42207_, Items.f_41950_, Items.f_41945_, Items.f_41948_, Items.f_41947_, Items.f_41940_, Items.f_42209_, Items.f_41944_, Items.f_42208_, Items.f_42206_, Items.f_41946_};
    public static final Item[] LEATHER_ARMORS = new Item[]{Items.f_42408_, Items.f_42462_, Items.f_42407_, Items.f_42463_};
    public static final Item[] GOLDEN_ARMORS = new Item[]{Items.f_42477_, Items.f_42478_, Items.f_42476_, Items.f_42479_};
    public static final Item[] IRON_ARMORS = new Item[]{Items.f_42469_, Items.f_42470_, Items.f_42468_, Items.f_42471_};
    public static final Item[] DIAMOND_ARMORS = new Item[]{Items.f_42473_, Items.f_42474_, Items.f_42472_, Items.f_42475_};
    public static final Item[] NETHERITE_ARMORS = new Item[]{Items.f_42481_, Items.f_42482_, Items.f_42480_, Items.f_42483_};
    public static final Item[] WOODEN_TOOLS = new Item[]{Items.f_42422_, Items.f_42421_, Items.f_42420_, Items.f_42423_, Items.f_42424_};
    public static final Item[] STONE_TOOLS = new Item[]{Items.f_42427_, Items.f_42426_, Items.f_42425_, Items.f_42428_, Items.f_42429_};
    public static final Item[] IRON_TOOLS = new Item[]{Items.f_42385_, Items.f_42384_, Items.f_42383_, Items.f_42386_, Items.f_42387_};
    public static final Item[] GOLDEN_TOOLS = new Item[]{Items.f_42432_, Items.f_42431_, Items.f_42430_, Items.f_42433_, Items.f_42434_};
    public static final Item[] DIAMOND_TOOLS = new Item[]{Items.f_42390_, Items.f_42389_, Items.f_42388_, Items.f_42391_, Items.f_42392_};
    public static final Item[] NETHERITE_TOOLS = new Item[]{Items.f_42395_, Items.f_42394_, Items.f_42393_, Items.f_42396_, Items.f_42397_};
    public static final Block[] WOOD_SIGNS_ALL = new Block[]{Blocks.f_50151_, Blocks.f_50150_, Blocks.f_50153_, Blocks.f_50095_, Blocks.f_50152_, Blocks.f_50149_, Blocks.f_50161_, Blocks.f_50160_, Blocks.f_50163_, Blocks.f_50158_, Blocks.f_50162_, Blocks.f_50159_, Blocks.f_220841_, Blocks.f_220839_, Blocks.f_244433_, Blocks.f_244608_, Blocks.f_271516_, Blocks.f_271107_};
    private static final Map<Item, Item> logToPlanks = new HashMap<Item, Item>(){
        {
            this.put(Items.f_271090_, Items.f_271154_);
            this.put(Items.f_271302_, Items.f_271154_);
            this.put(Items.f_271164_, Items.f_271154_);
            this.put(Items.f_271182_, Items.f_271154_);
            this.put(Items.f_220179_, Items.f_220174_);
            this.put(Items.f_220177_, Items.f_220174_);
            this.put(Items.f_220182_, Items.f_220174_);
            this.put(Items.f_220176_, Items.f_220174_);
            this.put(Items.f_41841_, Items.f_42795_);
            this.put(Items.f_41839_, Items.f_42753_);
            this.put(Items.f_41843_, Items.f_42797_);
            this.put(Items.f_41842_, Items.f_42796_);
            this.put(Items.f_41837_, Items.f_42647_);
            this.put(Items.f_41840_, Items.f_42794_);
            this.put(Items.f_41838_, Items.f_42700_);
            this.put(Items.f_41844_, Items.f_42798_);
            this.put(Items.f_41849_, Items.f_42795_);
            this.put(Items.f_41847_, Items.f_42753_);
            this.put(Items.f_41851_, Items.f_42797_);
            this.put(Items.f_41850_, Items.f_42796_);
            this.put(Items.f_41845_, Items.f_42647_);
            this.put(Items.f_41848_, Items.f_42794_);
            this.put(Items.f_41846_, Items.f_42700_);
            this.put(Items.f_41879_, Items.f_42798_);
            this.put(Items.f_41892_, Items.f_42795_);
            this.put(Items.f_41890_, Items.f_42753_);
            this.put(Items.f_41894_, Items.f_42797_);
            this.put(Items.f_41893_, Items.f_42796_);
            this.put(Items.f_41888_, Items.f_42647_);
            this.put(Items.f_41891_, Items.f_42794_);
            this.put(Items.f_41889_, Items.f_42700_);
            this.put(Items.f_41895_, Items.f_42798_);
            this.put(Items.f_41884_, Items.f_42795_);
            this.put(Items.f_41882_, Items.f_42753_);
            this.put(Items.f_41886_, Items.f_42797_);
            this.put(Items.f_41885_, Items.f_42796_);
            this.put(Items.f_41880_, Items.f_42647_);
            this.put(Items.f_41883_, Items.f_42794_);
            this.put(Items.f_41881_, Items.f_42700_);
            this.put(Items.f_41887_, Items.f_42798_);
        }
    };
    private static final Map<Item, Item> planksToLogs = new HashMap<Item, Item>(){
        {
            this.put(Items.f_271154_, Items.f_271090_);
            this.put(Items.f_220174_, Items.f_220179_);
            this.put(Items.f_42795_, Items.f_41841_);
            this.put(Items.f_42753_, Items.f_41839_);
            this.put(Items.f_42797_, Items.f_41843_);
            this.put(Items.f_42796_, Items.f_41842_);
            this.put(Items.f_42647_, Items.f_41837_);
            this.put(Items.f_42794_, Items.f_41840_);
            this.put(Items.f_42700_, Items.f_41838_);
            this.put(Items.f_42798_, Items.f_41844_);
        }
    };
    private static final Map<Item, Item> strippedToLogs = new HashMap<Item, Item>(){
        {
            this.put(Items.f_271164_, Items.f_271090_);
            this.put(Items.f_220182_, Items.f_220179_);
            this.put(Items.f_41849_, Items.f_41841_);
            this.put(Items.f_41847_, Items.f_41839_);
            this.put(Items.f_41851_, Items.f_41843_);
            this.put(Items.f_41850_, Items.f_41842_);
            this.put(Items.f_41845_, Items.f_41837_);
            this.put(Items.f_41848_, Items.f_41840_);
            this.put(Items.f_41846_, Items.f_41838_);
            this.put(Items.f_41879_, Items.f_41844_);
        }
    };
    private static final Map<MapColor, ColorfulItems> colorMap = new HashMap<MapColor, ColorfulItems>(){
        {
            this.p(DyeColor.RED, "red", Items.f_42497_, Items.f_41937_, Items.f_42570_, Items.f_42197_, Items.f_42174_, Items.f_42190_, Items.f_42125_, Items.f_42244_, Items.f_42313_, Items.f_42277_, Items.f_42727_, Items.f_42228_, Blocks.f_50392_);
            this.p(DyeColor.WHITE, "white", Items.f_42535_, Items.f_41870_, Items.f_42503_, Items.f_42130_, Items.f_42212_, Items.f_42176_, Items.f_42163_, Items.f_42230_, Items.f_42246_, Items.f_42315_, Items.f_42660_, Items.f_42266_, Blocks.f_50430_);
            this.p(DyeColor.BLACK, "black", Items.f_42498_, Items.f_41938_, Items.f_42571_, Items.f_42198_, Items.f_42175_, Items.f_42191_, Items.f_42126_, Items.f_42245_, Items.f_42314_, Items.f_42278_, Items.f_42728_, Items.f_42229_, Blocks.f_50393_);
            this.p(DyeColor.BLUE, "blue", Items.f_42494_, Items.f_41934_, Items.f_42514_, Items.f_42141_, Items.f_42171_, Items.f_42187_, Items.f_42122_, Items.f_42241_, Items.f_42310_, Items.f_42326_, Items.f_42671_, Items.f_42225_, Blocks.f_50389_);
            this.p(DyeColor.BROWN, "brown", Items.f_42495_, Items.f_41935_, Items.f_42568_, Items.f_42142_, Items.f_42172_, Items.f_42188_, Items.f_42123_, Items.f_42242_, Items.f_42311_, Items.f_42327_, Items.f_42672_, Items.f_42226_, Blocks.f_50390_);
            this.p(DyeColor.CYAN, "cyan", Items.f_42492_, Items.f_41932_, Items.f_42512_, Items.f_42139_, Items.f_42221_, Items.f_42185_, Items.f_42120_, Items.f_42239_, Items.f_42308_, Items.f_42324_, Items.f_42669_, Items.f_42275_, Blocks.f_50439_);
            this.p(DyeColor.GRAY, "gray", Items.f_42490_, Items.f_41877_, Items.f_42510_, Items.f_42137_, Items.f_42219_, Items.f_42183_, Items.f_42118_, Items.f_42237_, Items.f_42306_, Items.f_42322_, Items.f_42667_, Items.f_42273_, Blocks.f_50437_);
            this.p(DyeColor.GREEN, "green", Items.f_42496_, Items.f_41936_, Items.f_42569_, Items.f_42143_, Items.f_42173_, Items.f_42189_, Items.f_42124_, Items.f_42243_, Items.f_42312_, Items.f_42328_, Items.f_42673_, Items.f_42227_, Blocks.f_50391_);
            this.p(DyeColor.LIGHT_BLUE, "light_blue", Items.f_42538_, Items.f_41873_, Items.f_42506_, Items.f_42133_, Items.f_42215_, Items.f_42179_, Items.f_42166_, Items.f_42233_, Items.f_42249_, Items.f_42318_, Items.f_42663_, Items.f_42269_, Blocks.f_50433_);
            this.p(DyeColor.LIGHT_GRAY, "light_gray", Items.f_42491_, Items.f_41878_, Items.f_42511_, Items.f_42138_, Items.f_42220_, Items.f_42184_, Items.f_42119_, Items.f_42238_, Items.f_42307_, Items.f_42323_, Items.f_42668_, Items.f_42274_, Blocks.f_50438_);
            this.p(DyeColor.LIME, "lime", Items.f_42540_, Items.f_41875_, Items.f_42508_, Items.f_42135_, Items.f_42217_, Items.f_42181_, Items.f_42168_, Items.f_42235_, Items.f_42304_, Items.f_42320_, Items.f_42665_, Items.f_42271_, Blocks.f_50435_);
            this.p(DyeColor.MAGENTA, "magenta", Items.f_42537_, Items.f_41872_, Items.f_42505_, Items.f_42132_, Items.f_42214_, Items.f_42178_, Items.f_42165_, Items.f_42232_, Items.f_42248_, Items.f_42317_, Items.f_42662_, Items.f_42268_, Blocks.f_50432_);
            this.p(DyeColor.ORANGE, "orange", Items.f_42536_, Items.f_41871_, Items.f_42504_, Items.f_42131_, Items.f_42213_, Items.f_42177_, Items.f_42164_, Items.f_42231_, Items.f_42247_, Items.f_42316_, Items.f_42661_, Items.f_42267_, Blocks.f_50431_);
            this.p(DyeColor.PINK, "pink", Items.f_42489_, Items.f_41876_, Items.f_42509_, Items.f_42136_, Items.f_42218_, Items.f_42182_, Items.f_42169_, Items.f_42236_, Items.f_42305_, Items.f_42321_, Items.f_42666_, Items.f_42272_, Blocks.f_50436_);
            this.p(DyeColor.PURPLE, "purple", Items.f_42493_, Items.f_41933_, Items.f_42513_, Items.f_42140_, Items.f_42222_, Items.f_42186_, Items.f_42121_, Items.f_42240_, Items.f_42309_, Items.f_42325_, Items.f_42670_, Items.f_42224_, Blocks.f_50388_);
            this.p(DyeColor.RED, "red", Items.f_42497_, Items.f_41937_, Items.f_42570_, Items.f_42197_, Items.f_42174_, Items.f_42190_, Items.f_42125_, Items.f_42244_, Items.f_42313_, Items.f_42277_, Items.f_42727_, Items.f_42228_, Blocks.f_50392_);
            this.p(DyeColor.YELLOW, "yellow", Items.f_42539_, Items.f_41874_, Items.f_42507_, Items.f_42134_, Items.f_42216_, Items.f_42180_, Items.f_42167_, Items.f_42234_, Items.f_42303_, Items.f_42319_, Items.f_42664_, Items.f_42270_, Blocks.f_50434_);
        }

        void p(DyeColor color, String colorName, Item dye, Item wool, Item bed, Item carpet, Item stainedGlass, Item stainedGlassPane, Item terracotta, Item glazedTerracotta, Item concrete, Item concretePowder, Item banner, Item shulker, Block wallBanner) {
            this.put(color.m_284406_(), new ColorfulItems(color, colorName, dye, wool, bed, carpet, stainedGlass, stainedGlassPane, terracotta, glazedTerracotta, concrete, concretePowder, banner, shulker, wallBanner));
        }
    };
    private static final Map<WoodType, WoodItems> woodMap = new HashMap<WoodType, WoodItems>(){
        {
            this.p(WoodType.CHERRY, "cherry", Items.f_271154_, Items.f_271090_, Items.f_271164_, Items.f_271182_, Items.f_271302_, Items.f_271504_, Items.f_271501_, Items.f_271459_, Items.f_271474_, Items.f_271397_, Items.f_271349_, Items.f_271316_, Items.f_271205_, Items.f_271386_, Items.f_271375_, Items.f_271517_, Items.f_271282_, Items.f_271114_);
            this.p(WoodType.BAMBOO, "bamboo", null, null, Items.f_256923_, null, null, Items.f_244057_, Items.f_243999_, Items.f_243820_, Items.f_244424_, Items.f_244189_, Items.f_243860_, Items.f_244106_, Items.f_244345_, Items.f_244624_, Items.f_41911_, null, Items.f_244469_, Items.f_244311_);
            this.p(WoodType.MANGROVE, "mangrove", Items.f_220174_, Items.f_220179_, Items.f_220182_, Items.f_220176_, Items.f_220177_, Items.f_220209_, Items.f_244479_, Items.f_220197_, Items.f_220199_, Items.f_220189_, Items.f_220183_, Items.f_220188_, Items.f_220206_, Items.f_220204_, Items.f_220175_, Items.f_220178_, Items.f_220196_, Items.f_220198_);
            this.p(WoodType.ACACIA, "acacia", Items.f_42795_, Items.f_41841_, Items.f_41849_, Items.f_41884_, Items.f_41892_, Items.f_42442_, Items.f_244440_, Items.f_42346_, Items.f_42088_, Items.f_42202_, Items.f_41918_, Items.f_42042_, Items.f_42034_, Items.f_42745_, Items.f_41827_, Items.f_41900_, Items.f_41972_, Items.f_42060_);
            this.p(WoodType.BIRCH, "birch", Items.f_42753_, Items.f_41839_, Items.f_41847_, Items.f_41882_, Items.f_41890_, Items.f_42440_, Items.f_244431_, Items.f_42344_, Items.f_42086_, Items.f_42112_, Items.f_41916_, Items.f_42040_, Items.f_42032_, Items.f_42743_, Items.f_42801_, Items.f_41898_, Items.f_41970_, Items.f_42058_);
            this.p(WoodType.CRIMSON, "crimson", Items.f_42797_, Items.f_41843_, Items.f_41851_, Items.f_41886_, Items.f_41894_, Items.f_42444_, Items.f_244617_, Items.f_42348_, Items.f_42090_, Items.f_42114_, Items.f_41920_, Items.f_42044_, Items.f_42036_, null, Items.f_41954_, null, Items.f_41974_, Items.f_42062_);
            this.p(WoodType.DARK_OAK, "dark_oak", Items.f_42796_, Items.f_41842_, Items.f_41850_, Items.f_41885_, Items.f_41893_, Items.f_42443_, Items.f_243805_, Items.f_42347_, Items.f_42089_, Items.f_42203_, Items.f_41919_, Items.f_42043_, Items.f_42035_, Items.f_42746_, Items.f_41828_, Items.f_41901_, Items.f_41973_, Items.f_42061_);
            this.p(WoodType.OAK, "oak", Items.f_42647_, Items.f_41837_, Items.f_41845_, Items.f_41880_, Items.f_41888_, Items.f_42438_, Items.f_244406_, Items.f_42342_, Items.f_42084_, Items.f_42008_, Items.f_41914_, Items.f_42038_, Items.f_42030_, Items.f_42453_, Items.f_42799_, Items.f_41896_, Items.f_41968_, Items.f_42056_);
            this.p(WoodType.JUNGLE, "jungle", Items.f_42794_, Items.f_41840_, Items.f_41848_, Items.f_41883_, Items.f_41891_, Items.f_42441_, Items.f_243722_, Items.f_42345_, Items.f_42087_, Items.f_42113_, Items.f_41917_, Items.f_42041_, Items.f_42033_, Items.f_42744_, Items.f_41826_, Items.f_41899_, Items.f_41971_, Items.f_42059_);
            this.p(WoodType.SPRUCE, "spruce", Items.f_42700_, Items.f_41838_, Items.f_41846_, Items.f_41881_, Items.f_41889_, Items.f_42439_, Items.f_243963_, Items.f_42343_, Items.f_42085_, Items.f_42111_, Items.f_41915_, Items.f_42039_, Items.f_42031_, Items.f_42742_, Items.f_42800_, Items.f_41897_, Items.f_41969_, Items.f_42057_);
            this.p(WoodType.WARPED, "warped", Items.f_42798_, Items.f_41844_, Items.f_41879_, Items.f_41887_, Items.f_41895_, Items.f_42445_, Items.f_244637_, Items.f_42349_, Items.f_42144_, Items.f_42115_, Items.f_41921_, Items.f_42045_, Items.f_42037_, null, Items.f_41955_, null, Items.f_41975_, Items.f_42063_);
        }

        void p(WoodType type, String prefix, Item planks, Item log, Item strippedLog, Item strippedWood, Item wood, Item sign, Item hangingSign, Item door, Item button, Item stairs, Item slab, Item fence, Item fenceGate, Item boat, Item sapling, Item leaves, Item pressurePlate, Item trapdoor) {
            this.put(type, new WoodItems(prefix, planks, log, strippedLog, strippedWood, wood, sign, hangingSign, door, button, stairs, slab, fence, fenceGate, boat, sapling, leaves, pressurePlate, trapdoor));
        }
    };
    public static final HashMap<Item, Item> cookableFoodMap = new HashMap<Item, Item>(){
        {
            this.put(Items.f_42485_, Items.f_42486_);
            this.put(Items.f_42579_, Items.f_42580_);
            this.put(Items.f_42581_, Items.f_42582_);
            this.put(Items.f_42658_, Items.f_42659_);
            this.put(Items.f_42697_, Items.f_42698_);
            this.put(Items.f_42527_, Items.f_42531_);
            this.put(Items.f_42526_, Items.f_42530_);
            this.put(Items.f_42620_, Items.f_42674_);
        }
    };
    public static final Item[] RAW_FOODS = (Item[])cookableFoodMap.keySet().toArray(Item[]::new);
    public static final Item[] COOKED_FOODS = (Item[])cookableFoodMap.values().toArray(Item[]::new);
    private static Map<Item, Integer> fuelTimeMap = null;

    public static String stripItemName(Item item) {
        String[] possibilities;
        for (String possible : possibilities = new String[]{"item.minecraft.", "block.minecraft."}) {
            if (!item.m_5524_().startsWith(possible)) continue;
            return item.m_5524_().substring(possible.length());
        }
        return item.m_5524_();
    }

    public static Item[] blocksToItems(Block[] blocks) {
        Item[] result = new Item[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            result[i] = blocks[i].m_5456_();
        }
        return result;
    }

    public static Block[] itemsToBlocks(Item[] items) {
        ArrayList<Block> result = new ArrayList<Block>();
        for (Item item : items) {
            Block b;
            if (!(item instanceof BlockItem) || (b = Block.m_49814_((Item)item)) == null || b == Blocks.f_50016_) continue;
            result.add(b);
        }
        return (Block[])result.toArray(Block[]::new);
    }

    public static Item logToPlanks(Item logItem) {
        return logToPlanks.getOrDefault(logItem, null);
    }

    public static Item planksToLog(Item plankItem) {
        return planksToLogs.getOrDefault(plankItem, null);
    }

    public static Item strippedToLogs(Item logItem) {
        return strippedToLogs.getOrDefault(logItem, null);
    }

    public static ColorfulItems getColorfulItems(MapColor color) {
        return colorMap.get(color);
    }

    public static ColorfulItems getColorfulItems(DyeColor color) {
        return ItemHelper.getColorfulItems(color.m_284406_());
    }

    public static Collection<ColorfulItems> getColorfulItems() {
        return colorMap.values();
    }

    public static WoodItems getWoodItems(WoodType type) {
        return woodMap.get((Object)type);
    }

    public static Collection<WoodItems> getWoodItems() {
        return woodMap.values();
    }

    public static Optional<Item> getCookedFood(Item rawFood) {
        return Optional.ofNullable(cookableFoodMap.getOrDefault(rawFood, null));
    }

    public static String trimItemName(String name) {
        if (name.startsWith("block.minecraft.")) {
            name = name.substring("block.minecraft.".length());
        } else if (name.startsWith("item.minecraft.")) {
            name = name.substring("item.minecraft.".length());
        }
        return name;
    }

    public static boolean areShearsEffective(Block b) {
        return b instanceof LeavesBlock || b == Blocks.f_50033_ || b == Blocks.f_50034_ || b == Blocks.f_50359_ || b == Blocks.f_50196_ || b == Blocks.f_50035_ || b == Blocks.f_50036_ || b == Blocks.f_50191_ || b == Blocks.f_50267_ || BlockTagVer.isWool(b) || b == Blocks.f_50694_;
    }

    private static boolean isStackProtected(PlayerEngineController mod, ItemStack stack) {
        if (stack.m_41793_() && mod.getModSettings().getDontThrowAwayEnchantedItems()) {
            return true;
        }
        return ItemVer.hasCustomName(stack) && mod.getModSettings().getDontThrowAwayCustomNameItems() ? true : mod.getBehaviour().isProtected(stack.m_41720_()) || mod.getModSettings().isImportant(stack.m_41720_());
    }

    public static boolean canThrowAwayStack(PlayerEngineController mod, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return ItemHelper.isStackProtected(mod, stack) ? false : mod.getModSettings().isThrowaway(stack.m_41720_()) || mod.getModSettings().shouldThrowawayUnusedItems();
    }

    public static boolean canStackTogether(ItemStack from, ItemStack to) {
        return to.m_41619_() && from.m_41613_() <= from.m_41741_() ? true : to.m_41720_().equals(from.m_41720_()) && from.m_41613_() + to.m_41613_() < to.m_41741_();
    }

    private static Map<Item, Integer> getFuelTimeMap() {
        if (fuelTimeMap == null) {
            fuelTimeMap = AbstractFurnaceBlockEntity.m_58423_();
        }
        return fuelTimeMap;
    }

    public static double getFuelAmount(Item ... items) {
        double total = 0.0;
        for (Item item : items) {
            if (!ItemHelper.getFuelTimeMap().containsKey(item)) continue;
            int timeTicks = ItemHelper.getFuelTimeMap().get(item);
            total += (double)timeTicks / 200.0;
        }
        return total;
    }

    public static double getFuelAmount(ItemStack stack) {
        return ItemHelper.getFuelAmount(stack.m_41720_()) * (double)stack.m_41613_();
    }

    public static boolean isFuel(Item item) {
        return ItemHelper.getFuelTimeMap().containsKey(item);
    }

    public boolean isRawFood(Item item) {
        return cookableFoodMap.containsKey(item);
    }

    public static class ColorfulItems {
        public DyeColor color;
        public String colorName;
        public Item dye;
        public Item wool;
        public Item bed;
        public Item carpet;
        public Item stainedGlass;
        public Item stainedGlassPane;
        public Item terracotta;
        public Item glazedTerracotta;
        public Item concrete;
        public Item concretePowder;
        public Item banner;
        public Item shulker;
        public Block wallBanner;

        public ColorfulItems(DyeColor color, String colorName, Item dye, Item wool, Item bed, Item carpet, Item stainedGlass, Item stainedGlassPane, Item terracotta, Item glazedTerracotta, Item concrete, Item concretePowder, Item banner, Item shulker, Block wallBanner) {
            this.color = color;
            this.colorName = colorName;
            this.dye = dye;
            this.wool = wool;
            this.bed = bed;
            this.carpet = carpet;
            this.stainedGlass = stainedGlass;
            this.stainedGlassPane = stainedGlassPane;
            this.terracotta = terracotta;
            this.glazedTerracotta = glazedTerracotta;
            this.concrete = concrete;
            this.concretePowder = concretePowder;
            this.banner = banner;
            this.shulker = shulker;
            this.wallBanner = wallBanner;
        }
    }

    public static class WoodItems {
        public String prefix;
        public Item planks;
        public Item log;
        public Item strippedLog;
        public Item strippedWood;
        public Item wood;
        public Item sign;
        public Item hangingSign;
        public Item door;
        public Item button;
        public Item stairs;
        public Item slab;
        public Item fence;
        public Item fenceGate;
        public Item boat;
        public Item sapling;
        public Item leaves;
        public Item pressurePlate;
        public Item trapdoor;

        public WoodItems(String prefix, Item planks, Item log, Item strippedLog, Item strippedWood, Item wood, Item sign, Item hangingSign, Item door, Item button, Item stairs, Item slab, Item fence, Item fenceGate, Item boat, Item sapling, Item leaves, Item pressurePlate, Item trapdoor) {
            this.prefix = prefix;
            this.planks = planks;
            this.log = log;
            this.strippedLog = strippedLog;
            this.strippedWood = strippedWood;
            this.wood = wood;
            this.sign = sign;
            this.hangingSign = hangingSign;
            this.door = door;
            this.button = button;
            this.stairs = stairs;
            this.slab = slab;
            this.fence = fence;
            this.fenceGate = fenceGate;
            this.boat = boat;
            this.sapling = sapling;
            this.leaves = leaves;
            this.pressurePlate = pressurePlate;
            this.trapdoor = trapdoor;
        }

        public boolean isNetherWood() {
            return this.planks == Items.f_42797_ || this.planks == Items.f_42798_;
        }
    }
}

