/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.util.helpers;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.process.MineProcess;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.mixins.EntityAccessor;
import com.player2.playerengine.multiversion.MethodWrapper;
import com.player2.playerengine.multiversion.world.WorldVer;
import com.player2.playerengine.util.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CartographyTableBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LoomBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface WorldHelper {
    public static Vec3 toVec3d(BlockPos pos) {
        return pos == null ? null : new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static Vec3 toVec3d(Vec3i pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static Vec3i toVec3i(Vec3 pos) {
        return new Vec3i((int)pos.m_7096_(), (int)pos.m_7098_(), (int)pos.m_7094_());
    }

    public static BlockPos toBlockPos(Vec3 pos) {
        return new BlockPos((int)pos.m_7096_(), (int)pos.m_7098_(), (int)pos.m_7094_());
    }

    public static boolean isSourceBlock(PlayerEngineController controller, BlockPos pos, boolean onlyAcceptStill) {
        ServerLevel world = controller.getWorld();
        BlockState s = world.m_8055_(pos);
        if (s.m_60734_() instanceof LiquidBlock) {
            if (!s.m_60819_().m_76170_() && onlyAcceptStill) {
                return false;
            }
            int level = s.m_60819_().m_76186_();
            BlockState above = world.m_8055_(pos.m_7494_());
            return above.m_60734_() instanceof LiquidBlock ? false : level == 8;
        }
        return false;
    }

    public static double distanceXZSquared(Vec3 from, Vec3 to) {
        Vec3 delta = to.m_82546_(from);
        return delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_;
    }

    public static double distanceXZ(Vec3 from, Vec3 to) {
        return Math.sqrt(WorldHelper.distanceXZSquared(from, to));
    }

    public static boolean inRangeXZ(Vec3 from, Vec3 to, double range) {
        return WorldHelper.distanceXZSquared(from, to) < range * range;
    }

    public static boolean inRangeXZ(BlockPos from, BlockPos to, double range) {
        return WorldHelper.inRangeXZ(WorldHelper.toVec3d(from), WorldHelper.toVec3d(to), range);
    }

    public static boolean inRangeXZ(Entity entity, Vec3 to, double range) {
        return WorldHelper.inRangeXZ(entity.m_20182_(), to, range);
    }

    public static boolean inRangeXZ(Entity entity, BlockPos to, double range) {
        return WorldHelper.inRangeXZ(entity, WorldHelper.toVec3d(to), range);
    }

    public static boolean inRangeXZ(Entity entity, Entity to, double range) {
        return WorldHelper.inRangeXZ(entity, to.m_20182_(), range);
    }

    public static Dimension getCurrentDimension(PlayerEngineController controller) {
        ServerLevel world = controller.getWorld();
        if (world == null) {
            return Dimension.OVERWORLD;
        }
        if (world.m_6042_().f_63857_()) {
            return Dimension.NETHER;
        }
        return world.m_6042_().f_63858_() ? Dimension.OVERWORLD : Dimension.END;
    }

    public static boolean isSolidBlock(PlayerEngineController controller, BlockPos pos) {
        ServerLevel world = controller.getWorld();
        return world.m_8055_(pos).m_60796_((BlockGetter)world, pos);
    }

    public static BlockPos getBedHead(PlayerEngineController controller, BlockPos posWithBed) {
        ServerLevel world = controller.getWorld();
        BlockState state = world.m_8055_(posWithBed);
        if (state.m_60734_() instanceof BedBlock) {
            Direction facing = (Direction)state.m_61143_((Property)BedBlock.f_54117_);
            return ((BedPart)world.m_8055_(posWithBed).m_61143_((Property)BedBlock.f_49440_)).equals((Object)BedPart.HEAD) ? posWithBed : posWithBed.m_121945_(facing);
        }
        return null;
    }

    public static BlockPos getBedFoot(PlayerEngineController controller, BlockPos posWithBed) {
        ServerLevel world = controller.getWorld();
        BlockState state = world.m_8055_(posWithBed);
        if (state.m_60734_() instanceof BedBlock) {
            Direction facing = (Direction)state.m_61143_((Property)BedBlock.f_54117_);
            return ((BedPart)world.m_8055_(posWithBed).m_61143_((Property)BedBlock.f_49440_)).equals((Object)BedPart.FOOT) ? posWithBed : posWithBed.m_121945_(facing.m_122424_());
        }
        return null;
    }

    public static int getGroundHeight(PlayerEngineController controller, int x, int z) {
        ServerLevel world = controller.getWorld();
        for (int y = world.m_151558_(); y >= world.m_141937_(); --y) {
            BlockPos check = new BlockPos(x, y, z);
            if (!WorldHelper.isSolidBlock(controller, check)) continue;
            return y;
        }
        return -1;
    }

    public static BlockPos getADesertTemple(PlayerEngineController controller) {
        ServerLevel world = controller.getWorld();
        List<BlockPos> stonePressurePlates = controller.getBlockScanner().getKnownLocations(Blocks.f_50165_);
        if (!stonePressurePlates.isEmpty()) {
            for (BlockPos pos : stonePressurePlates) {
                if (world.m_8055_(pos).m_60734_() != Blocks.f_50165_ || world.m_8055_(pos.m_7495_()).m_60734_() != Blocks.f_50064_ || world.m_8055_(pos.m_6625_(2)).m_60734_() != Blocks.f_50077_) continue;
                return pos;
            }
        }
        return null;
    }

    public static boolean isUnopenedChest(PlayerEngineController controller, BlockPos pos) {
        return controller.getItemStorage().getContainerAtPosition(pos).isEmpty();
    }

    public static int getGroundHeight(PlayerEngineController controller, int x, int z, Block ... groundBlocks) {
        ServerLevel world = controller.getWorld();
        HashSet<Block> possibleBlocks = new HashSet<Block>(Arrays.asList(groundBlocks));
        for (int y = world.m_151558_(); y >= world.m_141937_(); --y) {
            BlockPos check = new BlockPos(x, y, z);
            if (!possibleBlocks.contains(world.m_8055_(check).m_60734_())) continue;
            return y;
        }
        return -1;
    }

    public static boolean canBreak(PlayerEngineController controller, BlockPos pos) {
        boolean prevInteractionPaused = controller.getExtraBaritoneSettings().isInteractionPaused();
        controller.getExtraBaritoneSettings().setInteractionPaused(false);
        boolean canBreak = controller.getWorld().m_8055_(pos).m_60800_((BlockGetter)controller.getWorld(), pos) >= 0.0f && !controller.getExtraBaritoneSettings().shouldAvoidBreaking(pos) && MineProcess.plausibleToBreak(new CalculationContext(controller.getBaritone()), pos) && WorldHelper.canReach(controller, pos);
        controller.getExtraBaritoneSettings().setInteractionPaused(prevInteractionPaused);
        return canBreak;
    }

    public static boolean isInNetherPortal(PlayerEngineController controller) {
        LivingEntity player = controller.getPlayer();
        return player == null ? false : ((EntityAccessor)player).isInNetherPortal();
    }

    public static boolean canPlace(PlayerEngineController controller, BlockPos pos) {
        return !controller.getExtraBaritoneSettings().shouldAvoidPlacingAt(pos) && WorldHelper.canReach(controller, pos);
    }

    public static boolean canReach(PlayerEngineController controller, BlockPos pos) {
        return controller.getModSettings().shouldAvoidOcean() && controller.getPlayer().m_20186_() > 47.0 && controller.getChunkTracker().isChunkLoaded(pos) && WorldHelper.isOcean((Holder<Biome>)controller.getWorld().m_204166_(pos)) && pos.m_123342_() < 64 && WorldHelper.getGroundHeight(controller, pos.m_123341_(), pos.m_123343_(), Blocks.f_49990_) > pos.m_123342_() ? false : !controller.getBlockScanner().isUnreachable(pos);
    }

    public static boolean isOcean(Holder<Biome> b) {
        return WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.f_48174_) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.f_48168_) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.f_48171_) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.f_48225_) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.f_48172_) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.f_48170_) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.f_48167_) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.f_48166_) || WorldVer.isBiome(b, (ResourceKey<Biome>)Biomes.f_48211_);
    }

    public static boolean isAir(PlayerEngineController controller, BlockPos pos) {
        return controller.getBlockScanner().isBlockAtPosition(pos, Blocks.f_50016_, Blocks.f_50627_, Blocks.f_50626_);
    }

    public static boolean isAir(Block block) {
        return block == Blocks.f_50016_ || block == Blocks.f_50627_ || block == Blocks.f_50626_;
    }

    public static boolean isInteractableBlock(PlayerEngineController controller, BlockPos pos) {
        Block block = controller.getWorld().m_8055_(pos).m_60734_();
        return block instanceof ChestBlock || block instanceof EnderChestBlock || block instanceof CraftingTableBlock || block instanceof AbstractFurnaceBlock || block instanceof LoomBlock || block instanceof CartographyTableBlock || block instanceof EnchantmentTableBlock || block instanceof RedStoneOreBlock || block instanceof BarrelBlock;
    }

    public static boolean isInsidePlayer(PlayerEngineController controller, BlockPos pos) {
        return pos.m_203195_((Position)controller.getPlayer().m_20182_(), 2.0);
    }

    public static Iterable<BlockPos> getBlocksTouchingPlayer(LivingEntity player) {
        return WorldHelper.getBlocksTouchingBox(player.m_20191_());
    }

    public static Iterable<BlockPos> getBlocksTouchingBox(AABB box) {
        BlockPos min = new BlockPos((int)box.f_82288_, (int)box.f_82289_, (int)box.f_82290_);
        BlockPos max = new BlockPos((int)box.f_82291_, (int)box.f_82292_, (int)box.f_82293_);
        return WorldHelper.scanRegion(min, max);
    }

    public static Iterable<BlockPos> scanRegion(final BlockPos start, final BlockPos end) {
        return () -> new Iterator<BlockPos>(){
            int x;
            int y;
            int z;
            {
                this.x = start.m_123341_();
                this.y = start.m_123342_();
                this.z = start.m_123343_();
            }

            @Override
            public boolean hasNext() {
                return this.y <= end.m_123342_() && this.z <= end.m_123343_() && this.x <= end.m_123341_();
            }

            @Override
            public BlockPos next() {
                BlockPos result = new BlockPos(this.x, this.y, this.z);
                ++this.x;
                if (this.x > end.m_123341_()) {
                    this.x = start.m_123341_();
                    ++this.z;
                    if (this.z > end.m_123343_()) {
                        this.z = start.m_123343_();
                        ++this.y;
                    }
                }
                return result;
            }
        };
    }

    public static boolean fallingBlockSafeToBreak(PlayerEngineController controller, BlockPos pos) {
        BlockStateInterface bsi = new BlockStateInterface(controller.getBaritone().getEntityContext());
        ServerLevel clientWorld = controller.getWorld();
        if (clientWorld == null) {
            throw new AssertionError();
        }
        while (WorldHelper.isFallingBlock(controller, pos)) {
            if (MovementHelper.avoidBreaking(bsi, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), clientWorld.m_8055_(pos), controller.getBaritoneSettings())) {
                return false;
            }
            pos = pos.m_7494_();
        }
        return true;
    }

    public static boolean isFallingBlock(PlayerEngineController controller, BlockPos pos) {
        ServerLevel clientWorld = controller.getWorld();
        if (clientWorld == null) {
            throw new AssertionError();
        }
        return clientWorld.m_8055_(pos).m_60734_() instanceof FallingBlock;
    }

    public static Entity getSpawnerEntity(PlayerEngineController controller, BlockPos pos) {
        Entity entity;
        BlockEntity blockEntity;
        ServerLevel world = controller.getWorld();
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof SpawnerBlock && (blockEntity = world.m_7702_(pos)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity blockEntity2 = (SpawnerBlockEntity)blockEntity;
            entity = MethodWrapper.getRenderedEntity(blockEntity2.m_59801_(), (Level)world, pos);
        } else {
            entity = null;
        }
        return entity;
    }

    public static boolean isChest(PlayerEngineController controller, BlockPos block) {
        Block b = controller.getWorld().m_8055_(block).m_60734_();
        return WorldHelper.isChest(b);
    }

    public static boolean isChest(Block b) {
        return b instanceof ChestBlock || b instanceof EnderChestBlock;
    }

    public static boolean isBlock(PlayerEngineController controller, BlockPos pos, Block block) {
        return controller.getWorld().m_8055_(pos).m_60734_() == block;
    }

    public static boolean canSleep(PlayerEngineController controller) {
        ServerLevel world = controller.getWorld();
        if (world != null) {
            if (world.m_46470_() && world.m_46471_()) {
                return true;
            }
            int time = WorldHelper.getTimeOfDay(controller);
            return 12542 <= time && time <= 23992;
        }
        return false;
    }

    public static int getTimeOfDay(PlayerEngineController controller) {
        ServerLevel world = controller.getWorld();
        return world != null ? (int)(world.m_46468_() % 24000L) : 0;
    }

    public static boolean isVulnerable(LivingEntity player) {
        int armor = player.m_21230_();
        float health = player.m_21223_();
        if (armor <= 15 && health < 3.0f) {
            return true;
        }
        return armor < 10 && health < 10.0f ? true : armor < 5 && health < 18.0f;
    }

    public static boolean isSurroundedByHostiles(PlayerEngineController controller) {
        List<LivingEntity> hostiles = controller.getEntityTracker().getHostiles();
        return WorldHelper.isSurrounded(controller, hostiles);
    }

    public static boolean isSurrounded(PlayerEngineController controller, List<LivingEntity> entities) {
        LivingEntity player = controller.getPlayer();
        BlockPos playerPos = player.m_20183_();
        int MIN_SIDES_TO_SURROUND = 2;
        ArrayList<Direction> uniqueSides = new ArrayList<Direction>();
        for (Entity entity : entities) {
            BlockPos entityPos;
            double angle;
            boolean isUnique;
            if (!entity.m_19950_((Entity)player, 8.0) || !(isUnique = !uniqueSides.contains(WorldHelper.getHorizontalDirectionFromYaw(angle = WorldHelper.calculateAngle(playerPos, entityPos = entity.m_20183_()))))) continue;
            uniqueSides.add(WorldHelper.getHorizontalDirectionFromYaw(angle));
        }
        return uniqueSides.size() >= 2;
    }

    private static double calculateAngle(BlockPos origin, BlockPos target) {
        double translatedX = target.m_123341_() - origin.m_123341_();
        double translatedZ = target.m_123343_() - origin.m_123343_();
        double angleRad = Math.atan2(translatedZ, translatedX);
        double angleDeg = Math.toDegrees(angleRad);
        if ((angleDeg -= 90.0) < 0.0) {
            angleDeg += 360.0;
        }
        return angleDeg;
    }

    private static Direction getHorizontalDirectionFromYaw(double yaw) {
        if ((yaw %= 360.0) < 0.0) {
            yaw += 360.0;
        }
        if (!(yaw >= 45.0 && yaw < 135.0 || yaw >= -315.0 && yaw < -225.0)) {
            if (!(yaw >= 135.0 && yaw < 225.0 || yaw >= -225.0 && yaw < -135.0)) {
                return !(yaw >= 225.0 && yaw < 315.0 || yaw >= -135.0 && yaw < -45.0) ? Direction.SOUTH : Direction.EAST;
            }
            return Direction.NORTH;
        }
        return Direction.WEST;
    }
}

