/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.utils;

import com.player2.playerengine.automaton.api.utils.BlockUtils;
import com.player2.playerengine.automaton.api.utils.accessor.IItemStack;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public final class BlockOptionalMeta {
    private final Block block;
    private final Set<BlockState> blockstates;
    private final IntSet stateHashes;
    private final IntSet stackHashes;
    private static final Pattern pattern = Pattern.compile("^(.+?)(?::(\\d+))?$");
    private static final Map<Block, List<Item>> drops = new HashMap<Block, List<Item>>();

    public BlockOptionalMeta(ServerLevel world, Block block) {
        this.block = block;
        this.blockstates = BlockOptionalMeta.getStates(block);
        this.stateHashes = BlockOptionalMeta.getStateHashes(this.blockstates);
        this.stackHashes = BlockOptionalMeta.getStackHashes(world, this.blockstates);
    }

    public BlockOptionalMeta(ServerLevel world, String selector) {
        Matcher matcher = pattern.matcher(selector);
        if (!matcher.find()) {
            throw new IllegalArgumentException("invalid block selector");
        }
        MatchResult matchResult = matcher.toMatchResult();
        this.block = BlockUtils.stringToBlockRequired(matchResult.group(1));
        this.blockstates = BlockOptionalMeta.getStates(this.block);
        this.stateHashes = BlockOptionalMeta.getStateHashes(this.blockstates);
        this.stackHashes = BlockOptionalMeta.getStackHashes(world, this.blockstates);
    }

    private static Set<BlockState> getStates(Block block) {
        return new HashSet<BlockState>((Collection<BlockState>)block.m_49965_().m_61056_());
    }

    private static IntSet getStateHashes(Set<BlockState> blockstates) {
        return (IntSet)blockstates.stream().map(Object::hashCode).collect(Collectors.toCollection(IntOpenHashSet::new));
    }

    private static IntSet getStackHashes(ServerLevel world, Set<BlockState> blockstates) {
        return (IntSet)blockstates.stream().flatMap(state -> BlockOptionalMeta.drops(world, state.m_60734_()).stream().map(item -> new ItemStack((ItemLike)item, 1))).map(stack -> ((IItemStack)stack).getBaritoneHash()).collect(Collectors.toCollection(IntOpenHashSet::new));
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean matches(Block block) {
        return block == this.block;
    }

    public boolean matches(BlockState blockstate) {
        Block block = blockstate.m_60734_();
        return block == this.block && this.stateHashes.contains(blockstate.hashCode());
    }

    public boolean matches(ItemStack stack) {
        int hash = ((IItemStack)stack).getBaritoneHash();
        return this.stackHashes.contains(hash -= stack.m_41773_());
    }

    public String toString() {
        return String.format("BlockOptionalMeta{block=%s}", this.block);
    }

    public BlockState getAnyBlockState() {
        return this.blockstates.size() > 0 ? this.blockstates.iterator().next() : null;
    }

    private static synchronized List<Item> drops(ServerLevel world, Block b) {
        return drops.computeIfAbsent(b, block -> {
            ResourceLocation lootTableLocation = block.m_60589_();
            if (lootTableLocation == BuiltInLootTables.f_78712_) {
                return Collections.emptyList();
            }
            ArrayList items = new ArrayList();
            world.m_7654_().m_278653_().m_278676_(lootTableLocation).m_79148_(new LootContext.Builder(new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82528_((Vec3i)BlockPos.f_121853_)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, null).m_287286_(LootContextParams.f_81461_, (Object)block.m_49966_()).m_287235_(LootContextParamSets.f_81421_)).m_78965_(world.m_7328_()).m_287259_(null), stack -> items.add(stack.m_41720_()));
            return items;
        });
    }
}

