/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.api.utils;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class BlockUtils {
    private static transient Map<String, Block> resourceCache = new HashMap<String, Block>();

    public static String blockToString(Block block) {
        ResourceLocation loc = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        String name = loc.m_135815_();
        if (!loc.m_135827_().equals("minecraft")) {
            name = loc.toString();
        }
        return name;
    }

    public static Block stringToBlockRequired(String name) {
        Block block = BlockUtils.stringToBlockNullable(name);
        if (block == null) {
            throw new IllegalArgumentException(String.format("Invalid block name %s", name));
        }
        return block;
    }

    public static Block stringToBlockNullable(String name) {
        Block block = resourceCache.get(name);
        if (block != null) {
            return block;
        }
        if (resourceCache.containsKey(name)) {
            return null;
        }
        block = BuiltInRegistries.f_256975_.m_6612_(ResourceLocation.m_135820_((String)(name.contains(":") ? name : "minecraft:" + name))).orElse(null);
        HashMap<String, Block> copy = new HashMap<String, Block>(resourceCache);
        copy.put(name, block);
        resourceCache = copy;
        return block;
    }

    private BlockUtils() {
    }
}

