/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.entity;

import com.mojang.logging.LogUtils;
import com.player2.playerengine.PlayerEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CustomFishingBobberEntity
extends ThrowableProjectile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RandomSource velocityRandom = RandomSource.m_216327_();
    private boolean caughtFish;
    private int outOfOpenWaterTicks;
    private static final int MAX_TIME_OUT_OF_WATER = 10;
    private static final EntityDataAccessor<Integer> HOOK_ENTITY_ID = SynchedEntityData.m_135353_(CustomFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CAUGHT_FISH = SynchedEntityData.m_135353_(CustomFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int removalTimer;
    private int hookCountdown;
    private int waitCountdown;
    private int fishTravelCountdown;
    private float fishAngle;
    private boolean inOpenWater = true;
    @Nullable
    private Entity hookedEntity;
    private State state = State.FLYING;
    private final int luckOfTheSeaLevel;
    private final int lureLevel;

    public CustomFishingBobberEntity(EntityType<? extends CustomFishingBobberEntity> type, Level world, int luckOfTheSeaLevel, int lureLevel) {
        super(type, world);
        this.f_19811_ = true;
        this.luckOfTheSeaLevel = Math.max(0, luckOfTheSeaLevel);
        this.lureLevel = Math.max(0, lureLevel);
    }

    public CustomFishingBobberEntity(EntityType<? extends CustomFishingBobberEntity> entityType, Level world) {
        this(entityType, world, 0, 0);
    }

    public CustomFishingBobberEntity(LivingEntity thrower, Level world, int luckOfTheSeaLevel, int lureLevel) {
        this((EntityType<? extends CustomFishingBobberEntity>)((EntityType)PlayerEngine.FISHING_BOBBER.get()), world, luckOfTheSeaLevel, lureLevel);
        this.m_5602_((Entity)thrower);
        float f = thrower.m_146909_();
        float g = thrower.m_146908_();
        float h = Mth.m_14089_((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = Mth.m_14031_((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float k = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        double d = thrower.m_20185_() - (double)i * 0.3;
        double e = thrower.m_20188_();
        double l = thrower.m_20189_() - (double)h * 0.3;
        this.m_7678_(d, e, l, g, f);
        Vec3 vec3d = new Vec3((double)(-i), (double)Mth.m_14036_((float)(-(k / j)), (float)-5.0f, (float)5.0f), (double)(-h));
        double m = vec3d.m_82553_();
        vec3d = vec3d.m_82542_(0.6 / m + this.f_19796_.m_216328_(0.5, 0.0103365), 0.6 / m + this.f_19796_.m_216328_(0.5, 0.0103365), 0.6 / m + this.f_19796_.m_216328_(0.5, 0.0103365));
        this.m_20256_(vec3d);
        this.m_146922_((float)(Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_) * 180.0 / 3.1415927410125732));
        this.m_146926_((float)(Mth.m_14136_((double)vec3d.f_82480_, (double)vec3d.m_165924_()) * 180.0 / 3.1415927410125732));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(HOOK_ENTITY_ID, (Object)0);
        this.m_20088_().m_135372_(CAUGHT_FISH, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (HOOK_ENTITY_ID.equals(data)) {
            int i = (Integer)this.m_20088_().m_135370_(HOOK_ENTITY_ID);
            Entity entity = this.hookedEntity = i > 0 ? this.m_9236_().m_6815_(i - 1) : null;
        }
        if (CAUGHT_FISH.equals(data)) {
            this.caughtFish = (Boolean)this.m_20088_().m_135370_(CAUGHT_FISH);
            if (this.caughtFish) {
                this.m_20334_(this.m_20184_().f_82479_, -0.4f * Mth.m_216267_((RandomSource)this.velocityRandom, (float)0.6f, (float)1.0f), this.m_20184_().f_82481_);
            }
        }
        super.m_7350_(data);
    }

    public boolean m_6783_(double distance) {
        double d = 64.0;
        return distance < 4096.0;
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
    }

    public void m_8119_() {
        this.velocityRandom.m_188584_(this.m_20148_().getLeastSignificantBits() ^ this.m_9236_().m_46467_());
        this.m_6075_();
        LivingEntity playerEntity = this.getPlayerOwner();
        if (playerEntity == null) {
            this.m_146870_();
        } else if (this.m_9236_().f_46443_ || !this.removeIfInvalid(playerEntity)) {
            boolean bl;
            if (this.m_20096_()) {
                ++this.removalTimer;
                if (this.removalTimer >= 1200) {
                    this.m_146870_();
                    return;
                }
            } else {
                this.removalTimer = 0;
            }
            float f = 0.0f;
            BlockPos blockPos = this.m_20183_();
            FluidState fluidState = this.m_9236_().m_6425_(blockPos);
            if (fluidState.m_205070_(FluidTags.f_13131_)) {
                f = fluidState.m_76155_((BlockGetter)this.m_9236_(), blockPos);
            }
            boolean bl2 = bl = f > 0.0f;
            if (this.state == State.FLYING) {
                if (this.hookedEntity != null) {
                    this.m_20256_(Vec3.f_82478_);
                    this.state = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (bl) {
                    this.m_20256_(this.m_20184_().m_82542_(0.3, 0.2, 0.3));
                    this.state = State.BOBBING;
                    return;
                }
                this.checkForCollision();
            } else {
                if (this.state == State.HOOKED_IN_ENTITY) {
                    if (this.hookedEntity != null) {
                        if (!this.hookedEntity.m_213877_() && this.hookedEntity.m_9236_().m_46472_() == this.m_9236_().m_46472_()) {
                            this.m_6034_(this.hookedEntity.m_20185_(), this.hookedEntity.m_20227_(0.8), this.hookedEntity.m_20189_());
                        } else {
                            this.updateHookedEntityId(null);
                            this.state = State.FLYING;
                        }
                    }
                    return;
                }
                if (this.state == State.BOBBING) {
                    Vec3 vec3d = this.m_20184_();
                    double d = this.m_20186_() + vec3d.f_82480_ - (double)blockPos.m_123342_() - (double)f;
                    if (Math.abs(d) < 0.01) {
                        d += Math.signum(d) * 0.1;
                    }
                    this.m_20334_(vec3d.f_82479_ * 0.9, vec3d.f_82480_ - d * (double)this.f_19796_.m_188501_() * 0.2, vec3d.f_82481_ * 0.9);
                    if (this.hookCountdown <= 0 && this.fishTravelCountdown <= 0) {
                        this.inOpenWater = true;
                    } else {
                        boolean bl3 = this.inOpenWater = this.inOpenWater && this.outOfOpenWaterTicks < 10 && this.isOpenOrWaterAround(blockPos);
                    }
                    if (bl) {
                        this.outOfOpenWaterTicks = Math.max(0, this.outOfOpenWaterTicks - 1);
                        if (this.caughtFish) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1 * (double)this.velocityRandom.m_188501_() * (double)this.velocityRandom.m_188501_(), 0.0));
                        }
                        if (!this.m_9236_().f_46443_) {
                            this.tickFishingLogic(blockPos);
                        }
                    } else {
                        this.outOfOpenWaterTicks = Math.min(10, this.outOfOpenWaterTicks + 1);
                    }
                }
            }
            if (!fluidState.m_205070_(FluidTags.f_13131_)) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_37283_();
            if (this.state == State.FLYING && (this.m_20096_() || this.f_19862_)) {
                this.m_20256_(Vec3.f_82478_);
            }
            double e = 0.92;
            this.m_20256_(this.m_20184_().m_82490_(0.92));
            this.m_20090_();
        }
    }

    private boolean removeIfInvalid(LivingEntity player) {
        ItemStack itemStack = player.m_21205_();
        ItemStack itemStack2 = player.m_21206_();
        boolean bl = itemStack.m_150930_(Items.f_42523_);
        boolean bl2 = itemStack2.m_150930_(Items.f_42523_);
        if (!player.m_213877_() && player.m_6084_() && (bl || bl2) && !(this.m_20280_((Entity)player) > 1024.0)) {
            return false;
        }
        this.m_146870_();
        return true;
    }

    private void checkForCollision() {
        HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        this.m_6532_(hitResult);
    }

    protected boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) || entity.m_6084_() && entity instanceof ItemEntity;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (!this.m_9236_().f_46443_) {
            this.updateHookedEntityId(entityHitResult.m_82443_());
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_20256_(this.m_20184_().m_82541_().m_82490_(blockHitResult.m_82448_((Entity)this)));
    }

    private void updateHookedEntityId(@Nullable Entity entity) {
        this.hookedEntity = entity;
        this.m_20088_().m_135381_(HOOK_ENTITY_ID, (Object)(entity == null ? 0 : entity.m_19879_() + 1));
    }

    private void tickFishingLogic(BlockPos pos) {
        ServerLevel serverWorld = (ServerLevel)this.m_9236_();
        int i = 1;
        BlockPos blockPos = pos.m_7494_();
        if (this.f_19796_.m_188501_() < 0.25f && this.m_9236_().m_46758_(blockPos)) {
            ++i;
        }
        if (this.f_19796_.m_188501_() < 0.5f && !this.m_9236_().m_45527_(blockPos)) {
            --i;
        }
        if (this.hookCountdown > 0) {
            --this.hookCountdown;
            if (this.hookCountdown <= 0) {
                this.waitCountdown = 0;
                this.fishTravelCountdown = 0;
                this.m_20088_().m_135381_(CAUGHT_FISH, (Object)false);
            }
        } else if (this.fishTravelCountdown > 0) {
            this.fishTravelCountdown -= i;
            if (this.fishTravelCountdown > 0) {
                double j;
                double e;
                this.fishAngle += (float)this.f_19796_.m_216328_(0.0, 9.188);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float g = Mth.m_14031_((float)f);
                float h = Mth.m_14089_((float)f);
                double d = this.m_20185_() + (double)(g * (float)this.fishTravelCountdown * 0.1f);
                BlockState blockState = serverWorld.m_8055_(BlockPos.m_274561_((double)d, (double)((e = (double)((float)Mth.m_14107_((double)this.m_20186_()) + 1.0f)) - 1.0), (double)(j = this.m_20189_() + (double)(h * (float)this.fishTravelCountdown * 0.1f))));
                if (blockState.m_60713_(Blocks.f_49990_)) {
                    if (this.f_19796_.m_188501_() < 0.15f) {
                        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123795_, d, e - (double)0.1f, j, 1, (double)g, 0.1, (double)h, 0.0);
                    }
                    float k = g * 0.04f;
                    float l = h * 0.04f;
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123816_, d, e, j, 0, (double)l, 0.01, (double)(-k), 1.0);
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123816_, d, e, j, 0, (double)(-l), 0.01, (double)k, 1.0);
                }
            } else {
                this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
                double m = this.m_20186_() + 0.5;
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), m, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), (double)0.2f);
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123816_, this.m_20185_(), m, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), (double)0.2f);
                this.hookCountdown = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)40);
                this.m_20088_().m_135381_(CAUGHT_FISH, (Object)true);
            }
        } else if (this.waitCountdown > 0) {
            this.waitCountdown -= i;
            float f = 0.15f;
            if (this.waitCountdown < 20) {
                f += (float)(20 - this.waitCountdown) * 0.05f;
            } else if (this.waitCountdown < 40) {
                f += (float)(40 - this.waitCountdown) * 0.02f;
            } else if (this.waitCountdown < 60) {
                f += (float)(60 - this.waitCountdown) * 0.01f;
            }
            if (this.f_19796_.m_188501_() < f) {
                double j;
                double e;
                float g = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float h = Mth.m_216267_((RandomSource)this.f_19796_, (float)25.0f, (float)60.0f);
                double d = this.m_20185_() + (double)(Mth.m_14031_((float)g) * h) * 0.1;
                BlockState blockState = serverWorld.m_8055_(BlockPos.m_274561_((double)d, (double)((e = (double)((float)Mth.m_14107_((double)this.m_20186_()) + 1.0f)) - 1.0), (double)(j = this.m_20189_() + (double)(Mth.m_14089_((float)g) * h) * 0.1)));
                if (blockState.m_60713_(Blocks.f_49990_)) {
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123769_, d, e, j, 2 + this.f_19796_.m_188503_(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.waitCountdown <= 0) {
                this.fishAngle = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f);
                this.fishTravelCountdown = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)80);
            }
        } else {
            this.waitCountdown = Mth.m_216271_((RandomSource)this.f_19796_, (int)100, (int)600);
            this.waitCountdown -= this.lureLevel * 20 * 5;
        }
    }

    private boolean isOpenOrWaterAround(BlockPos pos) {
        PositionType positionType = PositionType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            PositionType positionType2 = this.getPositionType(pos.m_7918_(-2, i, -2), pos.m_7918_(2, i, 2));
            switch (positionType2.ordinal()) {
                case 2: {
                    return false;
                }
                case 0: {
                    if (positionType != PositionType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (positionType != PositionType.ABOVE_WATER) break;
                    return false;
                }
            }
            positionType = positionType2;
        }
        return true;
    }

    private PositionType getPositionType(BlockPos start, BlockPos end) {
        return BlockPos.m_121990_((BlockPos)start, (BlockPos)end).map(this::getPositionType).reduce((positionType, positionType2) -> positionType == positionType2 ? positionType : PositionType.INVALID).orElse(PositionType.INVALID);
    }

    private PositionType getPositionType(BlockPos pos) {
        BlockState blockState = this.m_9236_().m_8055_(pos);
        if (!blockState.m_60795_() && !blockState.m_60713_(Blocks.f_50196_)) {
            FluidState fluidState = blockState.m_60819_();
            return fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76170_() && blockState.m_60812_((BlockGetter)this.m_9236_(), pos).m_83281_() ? PositionType.INSIDE_WATER : PositionType.INVALID;
        }
        return PositionType.ABOVE_WATER;
    }

    public boolean isInOpenWater() {
        return this.inOpenWater;
    }

    public void m_7380_(CompoundTag nbt) {
    }

    public void m_7378_(CompoundTag nbt) {
    }

    public int use(ItemStack usedItem) {
        LivingEntity playerEntity = this.getPlayerOwner();
        if (!this.m_9236_().f_46443_ && playerEntity != null && !this.removeIfInvalid(playerEntity)) {
            int i = 0;
            if (this.hookedEntity != null) {
                this.pullHookedEntity(this.hookedEntity);
                this.m_9236_().m_7605_((Entity)this, (byte)31);
                i = this.hookedEntity instanceof ItemEntity ? 3 : 5;
            } else if (this.hookCountdown > 0) {
                LootParams lootContextParameterSet = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)usedItem).m_287286_(LootContextParams.f_81455_, (Object)this).m_287239_((float)this.luckOfTheSeaLevel).m_287235_(LootContextParamSets.f_81414_);
                LootTable lootTable = this.m_9236_().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78720_);
                for (ItemStack itemStack : lootTable.m_287195_(lootContextParameterSet)) {
                    ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), itemStack);
                    double d = playerEntity.m_20185_() - this.m_20185_();
                    double e = playerEntity.m_20186_() - this.m_20186_();
                    double f = playerEntity.m_20189_() - this.m_20189_();
                    double g = 0.1;
                    itemEntity.m_20334_(d * 0.1, e * 0.1 + Math.sqrt(Math.sqrt(d * d + e * e + f * f)) * 0.08, f * 0.1);
                    this.m_9236_().m_7967_((Entity)itemEntity);
                    playerEntity.m_9236_().m_7967_((Entity)new ExperienceOrb(playerEntity.m_9236_(), playerEntity.m_20185_(), playerEntity.m_20186_() + 0.5, playerEntity.m_20189_() + 0.5, this.f_19796_.m_188503_(6) + 1));
                    if (!itemStack.m_204117_(ItemTags.f_13156_)) continue;
                }
                i = 1;
            }
            if (this.m_20096_()) {
                i = 2;
            }
            this.m_146870_();
            return i;
        }
        return 0;
    }

    public void m_7822_(byte status) {
        if (status == 31 && this.m_9236_().f_46443_ && this.hookedEntity instanceof LivingEntity) {
            this.pullHookedEntity(this.hookedEntity);
        }
        super.m_7822_(status);
    }

    protected void pullHookedEntity(Entity entity) {
        Entity entity2 = this.m_19749_();
        if (entity2 != null) {
            Vec3 vec3d = new Vec3(entity2.m_20185_() - this.m_20185_(), entity2.m_20186_() - this.m_20186_(), entity2.m_20189_() - this.m_20189_()).m_82490_(0.1);
            entity.m_20256_(entity.m_20184_().m_82549_(vec3d));
        }
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.setPlayerFishHook(null);
        super.m_142687_(reason);
    }

    public void m_142036_() {
        this.setPlayerFishHook(null);
    }

    public void m_5602_(@Nullable Entity entity) {
        super.m_5602_(entity);
        this.setPlayerFishHook(this);
    }

    private void setPlayerFishHook(@Nullable CustomFishingBobberEntity fishingBobber) {
        LivingEntity playerEntity = this.getPlayerOwner();
        if (playerEntity != null) {
            // empty if block
        }
    }

    @Nullable
    public LivingEntity getPlayerOwner() {
        Entity entity = this.m_19749_();
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    @Nullable
    public Entity getHookedEntity() {
        return this.hookedEntity;
    }

    public boolean m_6072_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.m_19749_();
        return new ClientboundAddEntityPacket((Entity)this, entity == null ? this.m_19879_() : entity.m_19879_());
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        if (this.getPlayerOwner() == null) {
            int i = packet.m_131509_();
            LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.m_9236_().m_6815_(i), (Object)i);
            this.m_6074_();
        }
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    static enum PositionType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

