/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement.movements;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.entity.LivingEntityInventory;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.behavior.InventoryBehavior;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementDescend;
import com.player2.playerengine.automaton.utils.pathing.MutableMoveResult;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.phys.Vec3;

public class MovementFall
extends Movement {
    public MovementFall(IBaritone baritone, BetterBlockPos src, BetterBlockPos dest) {
        super(baritone, src, dest, MovementFall.buildPositionsToBreak(src, dest));
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementDescend.cost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, result);
        return result.y != this.dest.y ? 1000000.0 : result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        HashSet<BetterBlockPos> set = new HashSet<BetterBlockPos>();
        set.add(this.src);
        for (int y = this.src.y - this.dest.y; y >= 0; --y) {
            set.add(this.dest.up(y));
        }
        return set;
    }

    private boolean willPlaceBucket() {
        CalculationContext context = new CalculationContext(this.baritone);
        MutableMoveResult result = new MutableMoveResult();
        return MovementDescend.dynamicFallCost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, 0.0, context.get(this.dest.x, this.src.y - 2, this.dest.z), result);
    }

    @Override
    public MovementState updateState(MovementState state) {
        Vec3i avoid;
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        BetterBlockPos playerFeet = this.ctx.feetPos();
        Rotation toDest = RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), VecUtils.getBlockPosCenter(this.dest), this.ctx.entityRotations());
        Rotation targetRotation = null;
        BlockState destState = this.ctx.world().m_8055_((BlockPos)this.dest);
        boolean isWater = destState.m_60819_().m_76152_() instanceof WaterFluid;
        if (!isWater && this.willPlaceBucket() && !playerFeet.equals((Object)this.dest)) {
            LivingEntityInventory inventory = this.ctx.inventory();
            if (inventory == null || !LivingEntityInventory.isValidHotbarIndex(InventoryBehavior.getSlotWithStack(inventory, PlayerEngine.WATER_BUCKETS)) || this.ctx.world().m_6042_().f_63857_()) {
                return state.setStatus(MovementStatus.UNREACHABLE);
            }
            if (this.ctx.entity().m_20186_() - (double)this.dest.m_123342_() < this.ctx.playerController().getBlockReachDistance() && !this.ctx.entity().m_20096_()) {
                inventory.selectedSlot = InventoryBehavior.getSlotWithStack(inventory, PlayerEngine.WATER_BUCKETS);
                targetRotation = new Rotation(toDest.getYaw(), 90.0f);
                if (this.ctx.isLookingAt(this.dest) || this.ctx.isLookingAt(this.dest.down())) {
                    state.setInput(Input.CLICK_RIGHT, true);
                }
            }
        }
        if (targetRotation != null) {
            state.setTarget(new MovementState.MovementTarget(targetRotation, true));
        } else {
            state.setTarget(new MovementState.MovementTarget(toDest, false));
        }
        if (playerFeet.equals((Object)this.dest) && (this.ctx.entity().m_20186_() - (double)playerFeet.m_123342_() < 0.094 || isWater)) {
            if (!isWater) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
            state.setInput(Input.JUMP, true);
            LivingEntityInventory inventoryx = this.ctx.inventory();
            if (inventoryx != null && LivingEntityInventory.isValidHotbarIndex(InventoryBehavior.getSlotWithStack(inventoryx, PlayerEngine.EMPTY_BUCKETS))) {
                inventoryx.selectedSlot = InventoryBehavior.getSlotWithStack(inventoryx, PlayerEngine.EMPTY_BUCKETS);
                if (this.ctx.entity().m_20184_().f_82480_ >= 0.0) {
                    return state.setInput(Input.CLICK_RIGHT, true);
                }
                return state;
            }
            if (this.ctx.entity().m_20184_().f_82480_ >= 0.0) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
        }
        Vec3 destCenter = VecUtils.getBlockPosCenter(this.dest);
        if (Math.abs(this.ctx.entity().m_20185_() + this.ctx.entity().m_20184_().f_82479_ - destCenter.f_82479_) > 0.1 || Math.abs(this.ctx.entity().m_20189_() + this.ctx.entity().m_20184_().f_82481_ - destCenter.f_82481_) > 0.1) {
            if (!this.ctx.entity().m_20096_() && Math.abs(this.ctx.entity().m_20184_().f_82480_) > 0.4) {
                state.setInput(Input.SNEAK, true);
            }
            state.setInput(Input.MOVE_FORWARD, true);
        }
        if ((avoid = (Vec3i)Optional.ofNullable(this.avoid()).map(Direction::m_122436_).orElse(null)) == null) {
            avoid = this.src.m_121996_((Vec3i)this.dest);
        } else {
            double dist = Math.abs((double)avoid.m_123341_() * (destCenter.f_82479_ - (double)avoid.m_123341_() / 2.0 - this.ctx.entity().m_20185_())) + Math.abs((double)avoid.m_123343_() * (destCenter.f_82481_ - (double)avoid.m_123343_() / 2.0 - this.ctx.entity().m_20189_()));
            if (dist < 0.6) {
                state.setInput(Input.MOVE_FORWARD, true);
            } else if (!this.ctx.entity().m_20096_()) {
                state.setInput(Input.SNEAK, false);
            }
        }
        if (targetRotation == null) {
            Vec3 destCenterOffset = new Vec3(destCenter.f_82479_ + 0.125 * (double)avoid.m_123341_(), destCenter.f_82480_, destCenter.f_82481_ + 0.125 * (double)avoid.m_123343_());
            state.setTarget(new MovementState.MovementTarget(RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), destCenterOffset, this.ctx.entityRotations()), false));
        }
        if (this.ctx.world().m_8055_((BlockPos)playerFeet).m_60713_(Blocks.f_50616_) || this.ctx.world().m_8055_(playerFeet.m_7495_()).m_60713_(Blocks.f_50616_)) {
            state.setInput(Input.SNEAK, true);
        }
        return state;
    }

    private Direction avoid() {
        for (int i = 0; i < 15; ++i) {
            BlockState state = this.ctx.world().m_8055_((BlockPos)this.ctx.feetPos().down(i));
            if (state.m_60734_() != Blocks.f_50155_) continue;
            return (Direction)state.m_61143_((Property)LadderBlock.f_54337_);
        }
        return null;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return this.ctx.feetPos().equals((Object)this.src) || state.getStatus() != MovementStatus.RUNNING;
    }

    private static BetterBlockPos[] buildPositionsToBreak(BetterBlockPos src, BetterBlockPos dest) {
        int diffX = src.m_123341_() - dest.m_123341_();
        int diffZ = src.m_123343_() - dest.m_123343_();
        int diffY = src.m_123342_() - dest.m_123342_();
        BetterBlockPos[] toBreak = new BetterBlockPos[diffY + 2];
        for (int i = 0; i < toBreak.length; ++i) {
            toBreak[i] = new BetterBlockPos(src.m_123341_() - diffX, src.m_123342_() + 1 - i, src.m_123343_() - diffZ);
        }
        return toBreak;
    }

    @Override
    protected boolean prepared(MovementState state) {
        if (state.getStatus() == MovementStatus.WAITING) {
            return true;
        }
        for (int i = 0; i < 4 && i < this.positionsToBreak.length; ++i) {
            if (MovementHelper.canWalkThrough(this.ctx, this.positionsToBreak[i])) continue;
            return super.prepared(state);
        }
        return true;
    }
}

