/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement.movements;

import com.google.common.collect.ImmutableSet;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.pathing.movement.movements.MovementPillar;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.pathing.MutableMoveResult;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MovementTraverse
extends Movement {
    private boolean wasTheBridgeBlockAlwaysThere = true;

    public MovementTraverse(IBaritone baritone, BetterBlockPos from, BetterBlockPos to) {
        super(baritone, from, to, MovementTraverse.buildPositionsToBreak((Entity)baritone.getEntityContext().entity(), from, to), to.down());
    }

    @Override
    public void reset() {
        super.reset();
        this.wasTheBridgeBlockAlwaysThere = true;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementTraverse.cost(context, this.src.x, this.src.y, this.src.z, this.dest.x, this.dest.z, result);
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest));
    }

    public static BetterBlockPos[] buildPositionsToBreak(Entity e, BetterBlockPos from, BetterBlockPos to) {
        int x = from.x;
        int y = from.y;
        int z = from.z;
        int destX = to.x;
        int destZ = to.z;
        int diffX = destX - x;
        int diffZ = destZ - z;
        EntityDimensions dimensions = e.m_6972_(Pose.STANDING);
        int requiredSideSpace = CalculationContext.getRequiredSideSpace(dimensions);
        int checkedXShift = diffX * requiredSideSpace;
        int checkedZShift = diffZ * requiredSideSpace;
        int checkedX = destX + checkedXShift;
        int checkedZ = destZ + checkedZShift;
        int height = Mth.m_14167_((float)dimensions.f_20378_);
        int requiredForwardSpace = requiredSideSpace == 0 ? 1 : 2;
        int volume = requiredForwardSpace * (requiredSideSpace * 2 + 1) * height;
        int i = 0;
        BetterBlockPos[] ret = new BetterBlockPos[volume];
        for (int df = 0; df < requiredForwardSpace; ++df) {
            for (int ds = -requiredSideSpace; ds <= requiredSideSpace; ++ds) {
                for (int dy = 0; dy < height; ++dy) {
                    ret[i++] = new BetterBlockPos(checkedX + diffZ * ds - diffX * df, y + dy, checkedZ + diffX * ds - diffZ * df);
                }
            }
        }
        return ret;
    }

    public static void cost(CalculationContext context, int x, int y, int z, int destX, int destZ, MutableMoveResult result) {
        BlockState destOn = context.get(destX, y - 1, destZ);
        BlockState srcOn = context.get(x, y - 1, z);
        Block srcOnBlock = srcOn.m_60734_();
        int movX = destX - x;
        int movZ = destZ - z;
        int checkedXShift = movX * context.requiredSideSpace;
        int checkedZShift = movZ * context.requiredSideSpace;
        int checkedX = destX + checkedXShift;
        int checkedZ = destZ + checkedZShift;
        if (MovementHelper.canWalkOn(context.bsi, destX, y - 1, destZ, destOn, context.baritone.settings())) {
            double WC = 0.0;
            boolean water = false;
            BlockState destHeadState = context.get(destX, y + context.height - 1, destZ);
            if (MovementHelper.isWater(destHeadState)) {
                WC = context.waterWalkSpeed;
                water = true;
            } else {
                for (int dy = 0; dy < context.height - 1; ++dy) {
                    if (!MovementHelper.isWater(context.get(destX, y + dy, destZ))) continue;
                    WC = context.waterWalkSpeed;
                    water = true;
                    break;
                }
            }
            if (!water) {
                WC = destOn.m_60734_() == Blocks.f_49990_ ? context.walkOnWaterOnePenalty : 4.63284688441047 / (double)destOn.m_60734_().m_49961_() / 2.0;
                WC += 4.63284688441047 / (double)srcOnBlock.m_49961_() / 2.0;
            }
            double hardness = 0.0;
            BlockState srcHeadState = context.get(x, y + context.height - 1, z);
            int hardnessModifier = !MovementHelper.isWater(srcHeadState) && srcOnBlock != Blocks.f_50155_ && srcOnBlock != Blocks.f_50191_ ? 1 : 5;
            for (int dxz = -context.requiredSideSpace; dxz <= context.requiredSideSpace; ++dxz) {
                for (int dyx = 0; dyx < context.height; ++dyx) {
                    if (!((hardness += MovementHelper.getMiningDurationTicks(context, checkedX + dxz * movZ, y + dyx, checkedZ + dxz * movX, dyx == context.height - 1) * (double)hardnessModifier) >= 1000000.0)) continue;
                    return;
                }
            }
            if (hardness == 0.0 && !water && context.canSprint) {
                WC *= 0.7692444761225944;
            }
            result.cost = WC + hardness;
            result.oxygenCost = context.oxygenCost(WC / 2.0 + hardness, srcHeadState) + context.oxygenCost(WC / 2.0, destHeadState);
        } else {
            if (srcOnBlock == Blocks.f_50155_ || srcOnBlock == Blocks.f_50191_) {
                return;
            }
            if (MovementHelper.isReplaceable(destX, y - 1, destZ, destOn, context.bsi)) {
                double placeCost;
                boolean throughWater = false;
                for (int dyxx = 0; dyxx < context.height; ++dyxx) {
                    if (!MovementHelper.isWater(context.get(destX, y + dyxx, destZ))) continue;
                    throughWater = true;
                    if (!MovementHelper.isWater(destOn)) break;
                    return;
                }
                if ((placeCost = context.costOfPlacingAt(destX, y - 1, destZ, destOn)) >= 1000000.0) {
                    return;
                }
                double hardness = 0.0;
                for (int dxz = -context.requiredSideSpace; dxz <= context.requiredSideSpace; ++dxz) {
                    for (int dyxxx = 0; dyxxx < context.height; ++dyxxx) {
                        if (!((hardness += MovementHelper.getMiningDurationTicks(context, checkedX + dxz * movZ, y + dyxxx, checkedZ + dxz * movX, dyxxx == context.height - 1)) >= 1000000.0)) continue;
                        return;
                    }
                }
                double WCx = throughWater ? context.waterWalkSpeed : 4.63284688441047;
                for (int i = 0; i < 5; ++i) {
                    int againstX = destX + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].m_122429_();
                    int againstY = y - 1 + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].m_122430_();
                    int againstZ = destZ + HORIZONTALS_BUT_ALSO_DOWN_____SO_EVERY_DIRECTION_EXCEPT_UP[i].m_122431_();
                    if (againstX == x && againstZ == z || !MovementHelper.canPlaceAgainst(context.bsi, againstX, againstY, againstZ)) continue;
                    result.cost = WCx + placeCost + hardness;
                    return;
                }
                if (!srcOn.m_247087_() && !srcOn.m_60838_((BlockGetter)context.world, BlockPos.f_121853_)) {
                    return;
                }
                if (srcOn.m_60819_().m_76152_() instanceof WaterFluid) {
                    return;
                }
                result.cost = (WCx *= 3.3207692307692307) + placeCost + hardness;
                result.oxygenCost = context.oxygenCost(result.cost, Blocks.f_50016_.m_49966_());
            }
        }
    }

    @Override
    public MovementState updateState(MovementState state) {
        super.updateState(state);
        BlockState[] bss = new BlockState[this.positionsToBreak.length];
        for (int i = 0; i < this.positionsToBreak.length; ++i) {
            bss[i] = BlockStateInterface.get(this.ctx, this.positionsToBreak[i]);
        }
        if (state.getStatus() != MovementStatus.RUNNING) {
            if (!this.baritone.settings().walkWhileBreaking.get().booleanValue()) {
                return state;
            }
            if (state.getStatus() != MovementStatus.PREPPING) {
                return state;
            }
            for (BlockState pb : bss) {
                if (!MovementHelper.avoidWalkingInto(pb)) continue;
                return state;
            }
            double dist = Math.max(Math.abs(this.ctx.entity().m_20185_() - ((double)this.dest.m_123341_() + 0.5)), Math.abs(this.ctx.entity().m_20189_() - ((double)this.dest.m_123343_() + 0.5)));
            if (dist < 0.83) {
                return state;
            }
            if (state.getTarget().getRotation().isEmpty()) {
                return state;
            }
            EntityDimensions dims = this.ctx.entity().m_6972_(this.ctx.entity().m_20089_());
            if (!(dims.f_20377_ > 1.0f || dims.f_20378_ < 1.0f || dims.f_20378_ > 2.0f)) {
                float yawToDest = RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), VecUtils.calculateBlockCenter((Level)this.ctx.world(), this.dest), this.ctx.entityRotations()).getYaw();
                float pitchToBreak = state.getTarget().getRotation().get().getPitch();
                if (MovementHelper.isBlockNormalCube(bss[0]) || bss[0].m_60734_() instanceof AirBlock && (MovementHelper.isBlockNormalCube(bss[1]) || bss[1].m_60734_() instanceof AirBlock)) {
                    pitchToBreak = 26.0f;
                }
                return state.setTarget(new MovementState.MovementTarget(new Rotation(yawToDest, pitchToBreak), true)).setInput(Input.MOVE_FORWARD, true).setInput(Input.SPRINT, true);
            }
            return state;
        }
        state.setInput(Input.SNEAK, false);
        BlockState fd = BlockStateInterface.get(this.ctx, this.src.down());
        boolean ladder = fd.m_204336_(BlockTags.f_13082_);
        for (BlockState bs : bss) {
            if (!this.tryOpenDoors(state, bs, this.dest, this.src)) continue;
            return state;
        }
        if (this.tryOpenDoors(state, BlockStateInterface.get(this.ctx, this.src), this.src, this.dest)) {
            return state;
        }
        boolean isTheBridgeBlockThere = MovementHelper.canWalkOn(this.ctx, this.positionToPlace) || ladder;
        BetterBlockPos feet = this.ctx.feetPos();
        BlockPos standingOnPos = feet.m_7495_();
        BlockState standingOn = BlockStateInterface.get(this.ctx, standingOnPos);
        if (MovementHelper.isWater(standingOn) && this.ctx.entity().m_20186_() < (double)this.src.m_123342_() + Math.random() * 0.2) {
            state.setInput(Input.JUMP, true);
        } else if (feet.m_123342_() != this.dest.m_123342_() && !ladder) {
            this.baritone.logDebug("Wrong Y coordinate");
            if (feet.m_123342_() < this.dest.m_123342_()) {
                MovementHelper.moveTowards(this.ctx, state, this.dest);
                return state.setInput(Input.MOVE_FORWARD, false).setInput(Input.JUMP, true);
            }
            return state;
        }
        if (isTheBridgeBlockThere) {
            if (feet.equals((Object)this.dest)) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
            if (this.baritone.settings().overshootTraverse.get().booleanValue() && (feet.equals(this.dest.m_121955_((Vec3i)this.getDirection())) || feet.equals(this.dest.m_121955_((Vec3i)this.getDirection()).m_121955_((Vec3i)this.getDirection())))) {
                return state.setStatus(MovementStatus.SUCCESS);
            }
            BlockState lowBs = BlockStateInterface.get(this.ctx, this.src);
            Block low = lowBs.m_60734_();
            Block high = BlockStateInterface.get(this.ctx, this.src.up()).m_60734_();
            if (!(!(this.ctx.entity().m_20186_() > (double)this.src.y + 0.1) || this.ctx.entity().m_20096_() || low != Blocks.f_50191_ && low != Blocks.f_50155_ && high != Blocks.f_50191_ && high != Blocks.f_50155_ || MovementHelper.isLiquid(lowBs))) {
                return state;
            }
            BlockPos into = this.dest.m_121996_((Vec3i)this.src).m_121955_((Vec3i)this.dest);
            BlockState intoBelow = BlockStateInterface.get(this.ctx, into);
            BlockState intoAbove = BlockStateInterface.get(this.ctx, into.m_7494_());
            if (!(!this.wasTheBridgeBlockAlwaysThere || MovementHelper.isLiquid(this.ctx, feet) && !this.baritone.settings().sprintInWater.get().booleanValue() || MovementHelper.avoidWalkingInto(intoBelow) && !MovementHelper.isWater(intoBelow) || MovementHelper.avoidWalkingInto(intoAbove))) {
                state.setInput(Input.SPRINT, true);
            }
            BlockState destDown = BlockStateInterface.get(this.ctx, this.dest.down());
            if (feet.m_123342_() != this.dest.m_123342_() && ladder && destDown.m_204336_(BlockTags.f_13082_)) {
                BlockPos against = MovementPillar.getSupportingBlock(this.baritone, this.ctx, this.src, destDown);
                if (against != null) {
                    MovementHelper.moveTowards(this.ctx, state, against);
                } else {
                    MovementPillar.centerForAscend(this.ctx, this.dest, state, 0.25);
                }
                state.setInput(Input.JUMP, true);
            } else {
                MovementHelper.moveTowards(this.ctx, state, this.dest.up());
            }
        } else {
            double dist;
            this.wasTheBridgeBlockAlwaysThere = false;
            VoxelShape collisionShape = standingOn.m_60812_((BlockGetter)this.ctx.world(), standingOnPos);
            if (!collisionShape.m_83281_() && collisionShape.m_83215_().f_82292_ < 1.0 && (dist = Math.max(Math.abs((double)this.dest.m_123341_() + 0.5 - this.ctx.entity().m_20185_()), Math.abs((double)this.dest.m_123343_() + 0.5 - this.ctx.entity().m_20189_()))) < 0.85) {
                MovementHelper.moveTowards(this.ctx, state, this.dest);
                return state.setInput(Input.MOVE_FORWARD, false).setInput(Input.MOVE_BACK, true);
            }
            double dist1 = Math.max(Math.abs(this.ctx.entity().m_20185_() - ((double)this.dest.m_123341_() + 0.5)), Math.abs(this.ctx.entity().m_20189_() - ((double)this.dest.m_123343_() + 0.5)));
            MovementHelper.PlaceResult p = MovementHelper.attemptToPlaceABlock(state, this.baritone, this.dest.down(), false, true);
            if ((p == MovementHelper.PlaceResult.READY_TO_PLACE || dist1 < 0.6) && !this.baritone.settings().assumeSafeWalk.get().booleanValue()) {
                state.setInput(Input.SNEAK, true);
            }
            switch (p) {
                case READY_TO_PLACE: {
                    if (this.ctx.entity().m_6144_() || this.baritone.settings().assumeSafeWalk.get().booleanValue()) {
                        state.setInput(Input.CLICK_RIGHT, true);
                    }
                    return state;
                }
                case ATTEMPTING: {
                    if (dist1 > 0.83) {
                        float yaw = RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), VecUtils.getBlockPosCenter(this.dest), this.ctx.entityRotations()).getYaw();
                        if ((double)Math.abs(state.getTarget().rotation.getYaw() - yaw) < 0.1) {
                            return state.setInput(Input.MOVE_FORWARD, true);
                        }
                    } else if (this.ctx.entityRotations().isReallyCloseTo(state.getTarget().rotation)) {
                        return state.setInput(Input.CLICK_LEFT, true);
                    }
                    return state;
                }
            }
            if (feet.equals((Object)this.dest)) {
                double faceX = ((double)(this.dest.m_123341_() + this.src.m_123341_()) + 1.0) * 0.5;
                double faceY = ((double)(this.dest.m_123342_() + this.src.m_123342_()) - 1.0) * 0.5;
                double faceZ = ((double)(this.dest.m_123343_() + this.src.m_123343_()) + 1.0) * 0.5;
                BetterBlockPos goalLook = this.src.down();
                Rotation backToFace = RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), new Vec3(faceX, faceY, faceZ), this.ctx.entityRotations());
                float pitch = backToFace.getPitch();
                double dist2 = Math.max(Math.abs(this.ctx.entity().m_20185_() - faceX), Math.abs(this.ctx.entity().m_20189_() - faceZ));
                if (dist2 < 0.29) {
                    float yaw = RotationUtils.calcRotationFromVec3d(VecUtils.getBlockPosCenter(this.dest), this.ctx.headPos(), this.ctx.entityRotations()).getYaw();
                    state.setTarget(new MovementState.MovementTarget(new Rotation(yaw, pitch), true));
                    state.setInput(Input.MOVE_BACK, true);
                } else {
                    state.setTarget(new MovementState.MovementTarget(backToFace, true));
                }
                if (this.ctx.isLookingAt(goalLook)) {
                    return state.setInput(Input.CLICK_RIGHT, true);
                }
                if (this.ctx.entityRotations().isReallyCloseTo(state.getTarget().rotation)) {
                    state.setInput(Input.CLICK_LEFT, true);
                }
                return state;
            }
            MovementHelper.moveTowards(this.ctx, state, this.dest.up());
        }
        return state;
    }

    private boolean tryOpenDoors(MovementState state, BlockState bs, BetterBlockPos dest, BetterBlockPos src) {
        if (bs.m_60734_() instanceof DoorBlock) {
            boolean notPassable = bs.m_60734_() instanceof DoorBlock && !MovementHelper.isDoorPassable(this.ctx, dest, src);
            boolean canOpen = DoorBlock.m_52817_((BlockState)bs);
            if (notPassable && canOpen) {
                state.setTarget(new MovementState.MovementTarget(RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), VecUtils.calculateBlockCenter((Level)this.ctx.world(), dest.up()), this.ctx.entityRotations()), true)).setInput(Input.CLICK_RIGHT, true);
                return true;
            }
        } else if (bs.m_60734_() instanceof FenceGateBlock) {
            Optional<Rotation> rotation;
            BetterBlockPos blocked;
            BetterBlockPos betterBlockPos = !MovementHelper.isGatePassable(this.ctx, dest.up(), src.up()) ? dest.up() : (blocked = !MovementHelper.isGatePassable(this.ctx, dest, src) ? dest : null);
            if (blocked != null && (rotation = RotationUtils.reachable(this.ctx, blocked)).isPresent()) {
                state.setTarget(new MovementState.MovementTarget(rotation.get(), true)).setInput(Input.CLICK_RIGHT, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean safeToCancel(MovementState state) {
        return state.getStatus() != MovementStatus.RUNNING || MovementHelper.canWalkOn(this.ctx, this.dest.down());
    }

    @Override
    protected boolean prepared(MovementState state) {
        Block block;
        if ((this.ctx.feetPos().equals((Object)this.src) || this.ctx.feetPos().equals((Object)this.src.down())) && ((block = BlockStateInterface.getBlock(this.ctx, this.src.down())) == Blocks.f_50155_ || block == Blocks.f_50191_)) {
            state.setInput(Input.SNEAK, true);
        }
        return super.prepared(state);
    }
}

