/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.player2.playerengine.automaton.api.BaritoneAPI;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.utils.PathRenderer;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class GuiClick
extends Screen {
    private final UUID callerUuid;
    private Matrix4f projectionViewMatrix;
    private BlockPos clickStart;
    private BlockPos currentMouseOver;

    public GuiClick(UUID callerUuid) {
        super((Component)Component.m_237113_((String)"CLICK"));
        this.callerUuid = callerUuid;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        double mx = mc.f_91067_.m_91589_();
        double my = mc.f_91067_.m_91594_();
        my = (double)mc.m_91268_().m_85444_() - my;
        Vec3 near = this.toWorld(mx *= (double)mc.m_91268_().m_85441_() / (double)mc.m_91268_().m_85443_(), my *= (double)mc.m_91268_().m_85442_() / (double)mc.m_91268_().m_85444_(), 0.0);
        Vec3 far = this.toWorld(mx, my, 1.0);
        if (near != null && far != null) {
            Vec3 viewerPos = new Vec3(PathRenderer.posX(), PathRenderer.posY(), PathRenderer.posZ());
            Player player = (Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
            BlockHitResult result = player.m_9236_().m_45547_(new ClipContext(near.m_82549_(viewerPos), far.m_82549_(viewerPos), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (result != null && result.m_6662_() == HitResult.Type.BLOCK) {
                this.currentMouseOver = result.m_82425_();
            }
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.currentMouseOver != null) {
            Minecraft client = this.f_96541_;
            assert (client != null);
            assert (client.f_91074_ != null);
            assert (client.f_91073_ != null);
            if (mouseButton == 0) {
                if (this.clickStart != null && !this.clickStart.equals((Object)this.currentMouseOver)) {
                    client.f_91074_.f_108617_.m_246623_(String.format("execute as %s run automatone sel clear", this.callerUuid));
                    client.f_91074_.f_108617_.m_246623_(String.format("execute as %s run automatone sel 1 %d %d %d", this.callerUuid, this.clickStart.m_123341_(), this.clickStart.m_123342_(), this.clickStart.m_123343_()));
                    client.f_91074_.f_108617_.m_246623_(String.format("execute as %s run automatone sel 2 %d %d %d", this.callerUuid, this.currentMouseOver.m_123341_(), this.currentMouseOver.m_123342_(), this.currentMouseOver.m_123343_()));
                    MutableComponent component = Component.m_237113_((String)"").m_7220_(BaritoneAPI.getPrefix()).m_130946_(" Selection made! For usage: /automatone help sel");
                    component.m_6270_(component.m_7383_().m_131157_(ChatFormatting.WHITE).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/automatone help sel")));
                    client.f_91065_.m_93076_().m_93785_((Component)component);
                } else {
                    client.f_91074_.f_108617_.m_246623_(String.format("execute as %s run automatone goto %d %d %d", this.callerUuid, this.currentMouseOver.m_123341_(), this.currentMouseOver.m_123342_(), this.currentMouseOver.m_123343_()));
                }
            } else if (mouseButton == 1) {
                client.f_91074_.f_108617_.m_246623_(String.format("execute as %s run automatone goto %d %d %d", this.callerUuid, this.currentMouseOver.m_123341_(), this.currentMouseOver.m_123342_() + 1, this.currentMouseOver.m_123343_()));
            }
        }
        this.clickStart = null;
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.clickStart = this.currentMouseOver;
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void onRender(PoseStack modelViewStack, Matrix4f projectionMatrix) {
        this.projectionViewMatrix = new Matrix4f((Matrix4fc)projectionMatrix);
        this.projectionViewMatrix.mul((Matrix4fc)modelViewStack.m_85850_().m_252922_());
        this.projectionViewMatrix.invert();
        if (this.currentMouseOver != null) {
            Entity e = Minecraft.m_91087_().m_91288_();
            Camera c = Minecraft.m_91087_().f_91063_.m_109153_();
            assert (e != null);
            VertexConsumer vertexConsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
            LevelRenderer.m_109646_((PoseStack)modelViewStack, (VertexConsumer)vertexConsumer, (AABB)new AABB(this.currentMouseOver).m_82386_(-c.m_90583_().f_82479_, -c.m_90583_().f_82480_, -c.m_90583_().f_82481_).m_82400_(0.002), (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.clickStart != null && !this.clickStart.equals((Object)this.currentMouseOver)) {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                RenderSystem.lineWidth((float)BaritoneAPI.getGlobalSettings().pathRenderLineWidthPixels.get().floatValue());
                RenderSystem.setShader(GameRenderer::m_172811_);
                RenderSystem.depthMask((boolean)false);
                RenderSystem.disableDepthTest();
                BetterBlockPos a = new BetterBlockPos(this.currentMouseOver);
                BetterBlockPos b = new BetterBlockPos(this.clickStart);
                LevelRenderer.m_109646_((PoseStack)modelViewStack, (VertexConsumer)vertexConsumer, (AABB)new AABB((double)Math.min(a.x, b.x), (double)Math.min(a.y, b.y), (double)Math.min(a.z, b.z), (double)(Math.max(a.x, b.x) + 1), (double)(Math.max(a.y, b.y) + 1), (double)(Math.max(a.z, b.z) + 1)).m_82386_(-c.m_90583_().f_82479_, -c.m_90583_().f_82480_, -c.m_90583_().f_82481_), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                RenderSystem.enableDepthTest();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.disableBlend();
            }
        }
    }

    private Vec3 toWorld(double x, double y, double z) {
        if (this.projectionViewMatrix == null) {
            return null;
        }
        Window window = Minecraft.m_91087_().m_91268_();
        x /= (double)window.m_85441_();
        y /= (double)window.m_85442_();
        x = x * 2.0 - 1.0;
        y = y * 2.0 - 1.0;
        Vector4f pos = new Vector4f((float)x, (float)y, (float)z, 1.0f);
        pos.mul((Matrix4fc)this.projectionViewMatrix);
        if (pos.w == 0.0f) {
            return null;
        }
        pos.div(pos.w);
        return new Vec3((double)pos.x, (double)pos.y, (double)pos.z);
    }
}

