/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.commands;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.commands.base.Arg;
import com.player2.playerengine.commands.base.ArgParser;
import com.player2.playerengine.commands.base.Command;
import com.player2.playerengine.commands.base.CommandException;
import com.player2.playerengine.util.Debug;

public class SetAIBridgeEnabledCommand
extends Command {
    public SetAIBridgeEnabledCommand() throws CommandException {
        super("chatclef", "Turns chatclef on or off, can ONLY be run by the user (NOT the agent).", new Arg<ToggleState>(ToggleState.class, "onOrOff"));
    }

    @Override
    protected void call(PlayerEngineController mod, ArgParser parser) throws CommandException {
        ToggleState toggle = parser.get(ToggleState.class);
        switch (toggle.ordinal()) {
            case 0: {
                Debug.logMessage("Enabling the AI Bridge! You can now hear the player again and will intercept their messages, give them a quick welcome back message.");
                mod.setChatClefEnabled(true);
                break;
            }
            case 1: {
                Debug.logMessage("AI Bridge disabled! Say goodbye to the player as you won't hear or intercept any of their messages until they turn you back on.");
                mod.setChatClefEnabled(false);
            }
        }
        this.finish();
    }

    public static enum ToggleState {
        ON,
        OFF;

    }
}

