/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.player2api.status;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.entity.IAutomatone;
import com.player2.playerengine.player2api.status.ObjectStatus;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.util.helpers.ItemHelper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;

public class StatusUtils {
    public static String getInventoryString(PlayerEngineController mod) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (int i = 0; i < mod.getBaritone().getEntityContext().inventory().m_6643_(); ++i) {
            ItemStack stack = mod.getBaritone().getEntityContext().inventory().m_8020_(i);
            if (stack.m_41619_()) continue;
            String name = ItemHelper.stripItemName(stack.m_41720_());
            counts.put(name, counts.getOrDefault(name, 0) + stack.m_41613_());
        }
        ObjectStatus status = new ObjectStatus();
        for (Map.Entry entry : counts.entrySet()) {
            status.add((String)entry.getKey(), ((Integer)entry.getValue()).toString());
        }
        return status.toString();
    }

    public static String getDimensionString(PlayerEngineController mod) {
        return mod.getWorld().m_46472_().m_135782_().toString().replace("minecraft:", "");
    }

    public static String getWeatherString(PlayerEngineController mod) {
        boolean isRaining = mod.getWorld().m_46471_();
        boolean isThundering = mod.getWorld().m_46470_();
        ObjectStatus status = new ObjectStatus().add("isRaining", String.valueOf(isRaining)).add("isThundering", String.valueOf(isThundering));
        return status.toString();
    }

    public static String getSpawnPosString(PlayerEngineController mod) {
        BlockPos spawnPos = mod.getWorld().m_220360_();
        return String.format("(%d, %d, %d)", spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
    }

    public static String getTaskStatusString(PlayerEngineController mod) {
        String noTask = "No tasks currently running.";
        List<Task> tasks = mod.getUserTaskChain().getTasks();
        return tasks.isEmpty() ? noTask : (tasks.get(0).toString().contains("LookAtOwner") ? noTask : tasks.get(0).toString());
    }

    public static String getNearbyBlocksString(PlayerEngineController mod) {
        int radius = 12;
        BlockPos center = mod.getPlayer().m_20183_();
        HashMap<String, Integer> blockCounts = new HashMap<String, Integer>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos = center.m_7918_(dx, dy, dz);
                    String blockName = mod.getWorld().m_8055_(pos).m_60734_().m_7705_().replace("block.minecraft.", "");
                    if (blockName.equals("air")) continue;
                    blockCounts.put(blockName, blockCounts.getOrDefault(blockName, 0) + 1);
                }
            }
        }
        ObjectStatus status = new ObjectStatus();
        for (Map.Entry entry : blockCounts.entrySet()) {
            status.add((String)entry.getKey(), ((Integer)entry.getValue()).toString());
        }
        return status.toString();
    }

    public static String getOxygenString(PlayerEngineController mod) {
        return String.format("%s/300", mod.getPlayer().m_20146_());
    }

    public static String getNearbyHostileMobs(PlayerEngineController mod) {
        int radius = 32;
        ArrayList<CallSite> descriptions = new ArrayList<CallSite>();
        for (Entity entity : mod.getWorld().m_8583_()) {
            if (!(entity instanceof Monster) || !(entity.m_20270_((Entity)mod.getPlayer()) < (float)radius)) continue;
            String type = entity.m_6095_().m_20675_();
            String niceName = type.replace("entity.minecraft.", "");
            String position = entity.m_20182_().m_82517_(EnumSet.allOf(Direction.Axis.class)).toString();
            descriptions.add((CallSite)((Object)(niceName + " at " + position)));
        }
        return descriptions.isEmpty() ? String.format("no nearby hostile mobs within %d", radius) : "[" + String.join((CharSequence)",", (CharSequence[])descriptions.stream().map(s -> "\"" + s + "\"").toArray(String[]::new)) + "]";
    }

    public static String getEquippedArmorStatusString(PlayerEngineController mod) {
        LivingEntity player = mod.getPlayer();
        ObjectStatus status = new ObjectStatus();
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
        ItemStack offhand = player.m_6844_(EquipmentSlot.OFFHAND);
        status.add("helmet", !head.m_41619_() && head.m_41720_() instanceof ArmorItem ? head.m_41720_().m_5524_().replace("item.minecraft.", "") : "none");
        status.add("chestplate", !chest.m_41619_() && chest.m_41720_() instanceof ArmorItem ? chest.m_41720_().m_5524_().replace("item.minecraft.", "") : "none");
        status.add("leggings", !legs.m_41619_() && legs.m_41720_() instanceof ArmorItem ? legs.m_41720_().m_5524_().replace("item.minecraft.", "") : "none");
        status.add("boots", !feet.m_41619_() && feet.m_41720_() instanceof ArmorItem ? feet.m_41720_().m_5524_().replace("item.minecraft.", "") : "none");
        status.add("offhand_shield", !offhand.m_41619_() && offhand.m_41720_() instanceof ShieldItem ? offhand.m_41720_().m_5524_().replace("item.minecraft.", "") : "none");
        return status.toString();
    }

    public static String getNearbyPlayers(PlayerEngineController mod) {
        ArrayList<CallSite> descriptions = new ArrayList<CallSite>();
        for (Entity entity : mod.getEntityTracker().getCloseEntities()) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (!(entity.m_20270_((Entity)mod.getPlayer()) < 64.0f)) continue;
            String username = player.m_7755_().getString();
            String position = entity.m_20182_().m_82517_(EnumSet.allOf(Direction.Axis.class)).toString();
            descriptions.add((CallSite)((Object)(username + " at " + position)));
        }
        return descriptions.isEmpty() ? String.format("no nearby users within %.2f", Float.valueOf(64.0f)) : "[" + String.join((CharSequence)",", (CharSequence[])descriptions.stream().map(s -> "\"" + s + "\"").toArray(String[]::new)) + "]";
    }

    public static String getNearbyNPCs(PlayerEngineController mod) {
        ArrayList<CallSite> descriptions = new ArrayList<CallSite>();
        for (Entity entity : mod.getEntityTracker().getCloseEntities()) {
            String username;
            if (!(entity instanceof IAutomatone) || !(entity.m_20270_((Entity)mod.getPlayer()) < 32.0f) || Objects.equals(username = entity.m_5446_().getString(), mod.getPlayer().m_5446_().getString())) continue;
            String position = entity.m_20182_().m_82517_(EnumSet.allOf(Direction.Axis.class)).toString();
            descriptions.add((CallSite)((Object)(username + " at " + position)));
        }
        return descriptions.isEmpty() ? String.format("no nearby npcs within %d", 32) : "[" + String.join((CharSequence)",", (CharSequence[])descriptions.stream().map(s -> "\"" + s + "\"").toArray(String[]::new)) + "]";
    }

    public static float getUserNameDistance(PlayerEngineController mod, String targetUsername) {
        for (Player player : mod.getWorld().m_6907_()) {
            String username = player.m_7755_().getString();
            if (!username.equals(targetUsername)) continue;
            return player.m_20270_((Entity)mod.getPlayer());
        }
        return Float.MAX_VALUE;
    }

    public static String getDifficulty(PlayerEngineController mod) {
        return mod.getWorld().m_46791_().toString();
    }

    public static String getTimeString(PlayerEngineController mod) {
        ObjectStatus status = new ObjectStatus();
        status.add("isDay", Boolean.toString(mod.getWorld().m_46461_()));
        status.add("timeOfDay", String.format("%d/24,000", mod.getWorld().m_46468_() % 24000L));
        return status.toString();
    }

    public static String getGamemodeString(PlayerEngineController mod) {
        return mod.getInteractionManager().getGameType().m_46408_() ? "creative" : "survival";
    }

    public static String getCurrentPosition(PlayerEngineController mod) {
        return mod.getEntity().m_146892_().toString();
    }

    public static String getTaskTree(PlayerEngineController mod) {
        Task task = mod.getUserTaskChain().getCurrentTask();
        return task == null ? "Task tree is empty" : task.getTaskTree();
    }

    public static float getDistanceToUUID(PlayerEngineController mod, UUID target) {
        for (Entity entity : mod.getWorld().m_8583_()) {
            if (!entity.m_20148_().equals(target)) continue;
            return entity.m_20270_((Entity)mod.getPlayer());
        }
        return Float.MAX_VALUE;
    }

    public static float getDistanceToUsername(PlayerEngineController mod, String username) {
        return mod.getWorld().m_6907_().stream().filter(p -> p.m_7755_().getString().equals(username)).findFirst().map(p -> Float.valueOf(p.m_20270_((Entity)mod.getPlayer()))).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue();
    }
}

