/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.control.InputControls;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.PlaceStructureBlockTask;
import com.player2.playerengine.util.helpers.LookHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SafeNetherPortalTask
extends Task {
    private final TimerGame wait = new TimerGame(1.0);
    private boolean keyReset = false;
    private boolean finished = false;
    private List<BlockPos> positions = null;
    private List<Direction> directions = null;
    private Direction.Axis axis = null;

    @Override
    protected void onStart() {
        this.controller.getBaritone().getInputOverrideHandler().clearAllKeys();
        this.wait.reset();
    }

    @Override
    protected Task onTick() {
        if (!this.wait.elapsed()) {
            return null;
        }
        PlayerEngineController mod = this.controller;
        if (!this.keyReset) {
            this.keyReset = true;
            mod.getBaritone().getInputOverrideHandler().clearAllKeys();
        }
        if (mod.getPlayer().m_287157_() < 10) {
            if (this.positions != null && this.directions != null) {
                boolean passed;
                BlockPos pos1 = mod.getPlayer().m_20097_().m_5487_(this.axis, 1);
                BlockPos pos2 = mod.getPlayer().m_20097_().m_5487_(this.axis, -1);
                if (mod.getWorld().m_8055_(pos1).m_60795_() || mod.getWorld().m_8055_(pos1).m_60734_().equals(Blocks.f_50135_)) {
                    passed = false;
                    for (Direction dir : Direction.values()) {
                        if (!mod.getWorld().m_8055_(pos1.m_7494_().m_121945_(dir)).m_60734_().equals(Blocks.f_50142_)) continue;
                        passed = true;
                        break;
                    }
                    if (passed) {
                        return new ReplaceSafeBlock(pos1);
                    }
                }
                if (mod.getWorld().m_8055_(pos2).m_60795_() || mod.getWorld().m_8055_(pos2).m_60734_().equals(Blocks.f_50135_)) {
                    passed = false;
                    for (Direction dirx : Direction.values()) {
                        if (!mod.getWorld().m_8055_(pos2.m_7494_().m_121945_(dirx)).m_60734_().equals(Blocks.f_50142_)) continue;
                        passed = true;
                        break;
                    }
                    if (passed) {
                        return new ReplaceSafeBlock(pos2);
                    }
                }
            }
            this.finished = true;
            this.setDebugState("We are not in a portal");
            return null;
        }
        BlockState state = mod.getWorld().m_8055_(mod.getPlayer().m_20183_());
        if (this.positions != null && this.directions != null) {
            for (BlockPos pos : this.positions) {
                for (Direction dirxx : this.directions) {
                    BlockPos newPos = pos.m_7495_().m_121945_(dirxx);
                    if (!mod.getWorld().m_8055_(newPos).m_60795_() && !mod.getWorld().m_8055_(newPos).m_60734_().equals(Blocks.f_50135_)) continue;
                    this.setDebugState("Changing block...");
                    return new ReplaceSafeBlock(newPos);
                }
            }
            this.finished = true;
            this.setDebugState("Portal is safe");
            return null;
        }
        if (state.m_60734_().equals(Blocks.f_50142_)) {
            this.axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_);
            this.positions = new ArrayList<BlockPos>();
            this.positions.add(mod.getPlayer().m_20183_());
            for (Direction dirxxx : Direction.values()) {
                if (dirxxx.m_122434_().m_122478_()) continue;
                BlockPos pos = mod.getPlayer().m_20183_().m_121945_(dirxxx);
                if (!mod.getWorld().m_8055_(pos).m_60734_().equals(Blocks.f_50142_)) continue;
                this.positions.add(pos);
            }
            this.directions = List.of(Direction.WEST, Direction.EAST);
            if (this.axis == Direction.Axis.X) {
                this.directions = List.of(Direction.NORTH, Direction.SOUTH);
            }
        } else {
            this.finished = true;
            this.setDebugState("We are not standing inside a nether portal block");
        }
        return null;
    }

    @Override
    protected void onStop(Task interruptTask) {
        InputControls controls = this.controller.getInputControls();
        controls.release(Input.MOVE_FORWARD);
        controls.release(Input.SNEAK);
        controls.release(Input.CLICK_LEFT);
        this.controller.getBaritone().getInputOverrideHandler().clearAllKeys();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof SafeNetherPortalTask;
    }

    @Override
    protected String toDebugString() {
        return "Making nether portal safe";
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    private static class ReplaceSafeBlock
    extends Task {
        private final BlockPos pos;
        private boolean finished = false;

        public ReplaceSafeBlock(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        protected void onStart() {
            this.controller.getBaritone().getInputOverrideHandler().clearAllKeys();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected Task onTick() {
            PlayerEngineController mod = this.controller;
            if (mod.getWorld().m_8055_(this.pos).m_60795_()) {
                this.setDebugState("Placing block...");
                return new PlaceStructureBlockTask(this.pos);
            }
            if (!this.controller.getWorld().m_8055_(this.pos).m_60734_().equals(Blocks.f_50135_)) {
                this.finished = true;
                return null;
            }
            LookHelper.lookAt(mod, this.pos);
            HitResult hitResult = mod.getPlayer().m_19907_(3.0, 0.0f, true);
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                if (mod.getWorld().m_8055_(blockHitResult.m_82425_()).m_60734_().equals(Blocks.f_50142_)) {
                    this.setDebugState("Getting closer to target...");
                    mod.getInputControls().hold(Input.MOVE_FORWARD);
                    mod.getInputControls().hold(Input.SNEAK);
                    return null;
                }
            }
            this.setDebugState("Breaking block");
            mod.getInputControls().release(Input.MOVE_FORWARD);
            mod.getInputControls().release(Input.SNEAK);
            mod.getInputControls().hold(Input.CLICK_LEFT);
            return null;
        }

        @Override
        protected void onStop(Task interruptTask) {
            InputControls controls = this.controller.getInputControls();
            controls.release(Input.MOVE_FORWARD);
            controls.release(Input.SNEAK);
            controls.release(Input.CLICK_LEFT);
            this.controller.getBaritone().getInputOverrideHandler().clearAllKeys();
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean isEqual(Task other) {
            if (!(other instanceof ReplaceSafeBlock)) return false;
            ReplaceSafeBlock same = (ReplaceSafeBlock)other;
            if (!same.pos.equals((Object)this.pos)) return false;
            return true;
        }

        @Override
        protected String toDebugString() {
            return "Making sure " + String.valueOf(this.pos) + " is safe";
        }
    }
}

