/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.tasks.construction.compound;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.TaskCatalogue;
import com.player2.playerengine.tasks.InteractWithBlockTask;
import com.player2.playerengine.tasks.base.Task;
import com.player2.playerengine.tasks.construction.DestroyBlockTask;
import com.player2.playerengine.tasks.construction.PlaceBlockTask;
import com.player2.playerengine.tasks.construction.PlaceStructureBlockTask;
import com.player2.playerengine.tasks.movement.TimeoutWanderTask;
import com.player2.playerengine.util.Debug;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.WorldHelper;
import com.player2.playerengine.util.time.TimerGame;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ConstructNetherPortalObsidianTask
extends Task {
    private static final Vec3i[] PORTAL_FRAME = new Vec3i[]{new Vec3i(0, 0, -1), new Vec3i(0, 1, -1), new Vec3i(0, 2, -1), new Vec3i(0, 0, 2), new Vec3i(0, 1, 2), new Vec3i(0, 2, 2), new Vec3i(0, 3, 0), new Vec3i(0, 3, 1), new Vec3i(0, -1, 0), new Vec3i(0, -1, 1)};
    private static final Vec3i[] PORTAL_INTERIOR = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(0, 1, 0), new Vec3i(0, 2, 0), new Vec3i(0, 0, 1), new Vec3i(0, 1, 1), new Vec3i(0, 2, 1), new Vec3i(1, 0, 0), new Vec3i(1, 1, 0), new Vec3i(1, 2, 0), new Vec3i(1, 0, 1), new Vec3i(1, 1, 1), new Vec3i(1, 2, 1), new Vec3i(-1, 0, 0), new Vec3i(-1, 1, 0), new Vec3i(-1, 2, 0), new Vec3i(-1, 0, 1), new Vec3i(-1, 1, 1), new Vec3i(-1, 2, 1)};
    private static final Vec3i PORTALABLE_REGION_SIZE = new Vec3i(3, 6, 6);
    private final TimerGame areaSearchTimer = new TimerGame(5.0);
    private BlockPos origin;
    private BlockPos destroyTarget;

    private BlockPos getBuildableAreaNearby(PlayerEngineController mod) {
        BlockPos checkOrigin = mod.getPlayer().m_20183_();
        for (BlockPos toCheck : WorldHelper.scanRegion(checkOrigin, checkOrigin.m_121955_(PORTALABLE_REGION_SIZE))) {
            boolean validToWorld;
            if (this.controller.getWorld() == null) {
                return null;
            }
            BlockState state = this.controller.getWorld().m_8055_(toCheck);
            boolean bl = validToWorld = WorldHelper.canPlace(this.controller, toCheck) || WorldHelper.canBreak(this.controller, toCheck);
            if (validToWorld && state.m_60734_() != Blocks.f_49991_ && state.m_60734_() != Blocks.f_49990_ && state.m_60734_() != Blocks.f_50752_) continue;
            return null;
        }
        return checkOrigin;
    }

    @Override
    protected void onStart() {
        PlayerEngineController mod = this.controller;
        mod.getBehaviour().push();
        mod.getBehaviour().avoidBlockBreaking(block -> {
            if (this.origin != null) {
                for (Vec3i framePosRelative : PORTAL_FRAME) {
                    BlockPos framePos = this.origin.m_121955_(framePosRelative);
                    if (!block.equals((Object)framePos)) continue;
                    return mod.getWorld().m_8055_(framePos).m_60734_() == Blocks.f_50080_;
                }
            }
            return false;
        });
        mod.getBehaviour().addProtectedItems(Items.f_42409_);
    }

    @Override
    protected Task onTick() {
        PlayerEngineController mod = this.controller;
        if (this.origin != null && mod.getWorld().m_8055_(this.origin.m_7494_()).m_60734_() == Blocks.f_50142_) {
            this.setDebugState("Done constructing nether portal.");
            mod.getBlockScanner().addBlock(Blocks.f_50142_, this.origin.m_7494_());
            return null;
        }
        int neededObsidian = 10;
        BlockPos placeTarget = null;
        if (this.origin != null) {
            for (Vec3i frameOffs : PORTAL_FRAME) {
                BlockPos framePos = this.origin.m_121955_(frameOffs);
                if (!mod.getBlockScanner().isBlockAtPosition(framePos, Blocks.f_50080_)) {
                    placeTarget = framePos;
                    break;
                }
                --neededObsidian;
            }
        }
        if (mod.getItemStorage().getItemCount(Items.f_41999_) < neededObsidian) {
            this.setDebugState("Getting obsidian");
            return TaskCatalogue.getItemTask(Items.f_41999_, neededObsidian);
        }
        if (this.origin == null) {
            if (this.areaSearchTimer.elapsed()) {
                this.areaSearchTimer.reset();
                Debug.logMessage("(Searching for area to build portal nearby...)");
                this.origin = this.getBuildableAreaNearby(mod);
            }
            this.setDebugState("Looking for portalable area...");
            return new TimeoutWanderTask();
        }
        if (!mod.getItemStorage().hasItem(Items.f_42409_)) {
            this.setDebugState("Getting flint and steel");
            return TaskCatalogue.getItemTask(Items.f_42409_, 1);
        }
        if (placeTarget == null) {
            if (this.destroyTarget != null && !WorldHelper.isAir(this.controller.getWorld().m_8055_(this.destroyTarget).m_60734_())) {
                return new DestroyBlockTask(this.destroyTarget);
            }
            for (Vec3i middleOffs : PORTAL_INTERIOR) {
                BlockPos middlePos = this.origin.m_121955_(middleOffs);
                if (WorldHelper.isAir(this.controller.getWorld().m_8055_(middlePos).m_60734_())) continue;
                this.destroyTarget = middlePos;
                return new DestroyBlockTask(this.destroyTarget);
            }
            return new InteractWithBlockTask(new ItemTarget(Items.f_42409_, 1), Direction.UP, this.origin.m_7495_(), true);
        }
        ServerLevel clientWorld = mod.getWorld();
        if (this.surroundedByAir((Level)clientWorld, placeTarget)) {
            LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
            queue.add(placeTarget);
            while (this.surroundedByAir((Level)clientWorld, placeTarget)) {
                BlockPos pos = (BlockPos)queue.removeFirst();
                if (!this.surroundedByAir((Level)clientWorld, pos)) {
                    return new PlaceStructureBlockTask(pos);
                }
                queue.add(pos.m_7494_());
                queue.add(pos.m_7495_());
                queue.add(pos.m_122029_());
                queue.add(pos.m_122024_());
                queue.add(pos.m_122012_());
                queue.add(pos.m_122019_());
            }
            mod.logWarning("Did not find any block to place obsidian on");
        }
        if (!clientWorld.m_8055_(placeTarget).m_60795_() && !clientWorld.m_8055_(placeTarget).m_60734_().equals(Blocks.f_50080_)) {
            return new DestroyBlockTask(placeTarget);
        }
        this.setDebugState("Placing frame...");
        return new PlaceBlockTask(placeTarget, Blocks.f_50080_);
    }

    private boolean surroundedByAir(Level world, BlockPos pos) {
        return world.m_8055_(pos.m_122024_()).m_60795_() && world.m_8055_(pos.m_122019_()).m_60795_() && world.m_8055_(pos.m_122029_()).m_60795_() && world.m_8055_(pos.m_7494_()).m_60795_() && world.m_8055_(pos.m_7495_()).m_60795_() && world.m_8055_(pos.m_122012_()).m_60795_();
    }

    @Override
    protected void onStop(Task interruptTask) {
        this.controller.getBehaviour().pop();
    }

    @Override
    protected boolean isEqual(Task other) {
        return other instanceof ConstructNetherPortalObsidianTask;
    }

    @Override
    protected String toDebugString() {
        return "Building nether portal with obsidian";
    }
}

